<?php
/*
 *  메인페이지, 그룹메인페이지 설정
 *  등록후에 게시판별 최신글을 배치합니다.
 */
include_once './_common.php';
set_session("ask_delete_token", $token = uniqid(time()));
include_once './index.php';

if (!defined('_GNUBOARD_')) {
    exit;
}

include_once G5_PLUGIN_PATH . "/asktheme/_admin/head.php";
add_stylesheet('<link rel="stylesheet" href="' . G5_PLUGIN_URL . '/asktheme/plugin/' . $plugin['id'] . '/plugin_style.css">', 0);
//수정모드일때
if ($w == 'u' && $idx) {
    $sql = "select * from ask_plugin_indexgroup where aig_idx = '{$idx}'";
    $data = sql_fetch($sql);
    if (!$data) {
        alert('데이터가 없습니다.', './indexgroup_list.php');
    }
}
?>
<div id="container">
    <div class="row">
        <div class="small-12 medium-12 large-12 columns">
            <div class="panel panel-default">
                <div class="panel-header">
                    <h1><?php echo $plugin['name'], $plugin['version']; ?> 1단계 등록하기</h1>
                </div>
                <div class="panel-body">
                    <form class="add_indexgroup" action="./indexgroup_add_update.php"  onsubmit="return form_submit(this);" method="post" enctype="multipart/form-data" autocomplete="off" >
                        <?php
                        if ($w == 'u' && $idx) {
                            echo "<input type='hidden' name='w' value='u'>";
                            echo "<input type='hidden' name='aig_idx' value='{$data['aig_idx']}'>";
                        }
                        ?>
                        <input type="hidden" name="pc_id" value="<?php echo $plugin['id'] ?>"/>
                        <input type="hidden" name="pc_name" value="<?php echo $plugin['name'] ?>"/>
                        <input type="hidden" name="popup" value="<?php echo $popup?>/">

                        <div class="responsetable write-table">
                            <div class="tb-body">
                                <div class="tb-row">
                                    <div class="tb-cell"><label for="aig_status">사용여부<strong class="sound-only">필수</strong></label></div>
                                    <div class="tb-cell">
                                        <?php
                                        if ($data['aig_status'] == '1') {
                                            $aig_use = "checked";
                                        } elseif ($data['aig_status'] == '0') {
                                            $aig_unuse = "checked";
                                        }
                                        ?>
                                        <label><input type="radio" name="aig_status" value="1" <?php echo $aig_use ?> class="slider-start">사용하기</label>
                                        <label><input type="radio" name="aig_status" value="0" <?php echo $aig_unuse ?> class="slider-stop">중지하기</label>
                                    </div>
                                </div>
                                <div class="tb-row">
                                    <div class="tb-cell"><label for="aig_area">위치<strong class="sound-only">필수</strong></label></div>
                                    <div class="tb-cell">
                                        <?php if ($w == 'u' && $idx) { ?>
                                            <script type="text/javascript">
                                                $(function () {
                                                    $('select[name=aig_area]').val('<?php echo $data['aig_area'] ?>');
                                                });
                                            </script>
                                        <?php } ?>
                                        <select name="aig_area" class="input">
                                            <option value="">--선택하세요--</option>
                                            <optgroup label='PC'>
                                                <option value="index">메인페이지</option>
                                                <option value="index-aside">메인페이지-ASIDE</option>
                                                <option value="index-aside">ASIDE</option>
                                                <?php
                                                echo ask_group_option();
                                                ?>
                                            </optgroup>
                                            <optgroup label='모바일-그룹메인'>
                                                <option value="mobile-index">메인페이지</option>
                                                <?php
                                                echo ask_group_option(true);
                                                ?>
                                            </optgroup>
                                            <optgroup label='기타페이지'>
                                                <option value="etc_1">페이지1</option>
                                                <option value="etc_2">페이지2</option>
                                                <option value="etc_3">페이지3</option>
                                                <option value="etc_4">페이지4</option>
                                                <option value="etc_5">페이지5</option>
                                                <option value="etc_6">페이지6</option>
                                                <option value="etc_7">페이지7</option>
                                                <option value="etc_8">페이지8</option>
                                                <option value="etc_9">페이지9</option>
                                                <option value="etc_10">페이지10</option>
                                            </optgroup>
                                        </select>
                                        <div class="text text-default help">
                                            &middot; 메인페이지 및 그룹별 메인페이지에 최신글 배치를 합니다. 같은 위치로 여러개 등록하면 한페이지에 모두 출력됩니다.<br/>
                                            &middot; 종류를 선택후 최신글 등록을 통해 배치 가능합니다. 여러개 배치 가능하며 1,2,3열 배치 선택 가능합니다.<br/>
                                            &middot; 아래의 코드로 동작됩니다.<br/>
                                            <?php if ($w == 'u') { ?>
                                                <span class="code">&lt;?php echo plugin_run('<?php echo $data['aig_area'] ?>', '[[indexgroup]]', false, '<?php echo $data['aig_area'] ?>');?&gt;</span>
                                            <?php } else { ?>
                                                <span class="code">&lt;?php echo plugin_run('페이지위치명', '[[indexgroup]]', false, '페이지위치명');?&gt;</span>
                                            <?php } ?>
                                            <br/> 
                                            &middot; 사용자 지정 페이지에 넣고싶다면 기타페이지를 선택후 코드에 위치명을 입력해서 해당페이지에 삽입하시면 됩니다.
                                        </div>
                                    </div>
                                </div>

                                <div class="tb-row">
                                    <div class="tb-cell"><label for="">열수 선택<strong class="sound-only">필수</strong></label></div>
                                    <div class="tb-cell">
                                        <?php if ($w == 'u' && $idx) { ?>
                                            <script>
                                                $(function () {
                                                    setTimeout(function () {
                                                        $('input[name=aig_column][value="<?php echo $data['aig_column'] ?>"]').attr('chekced', true).trigger('click');
                                                    }, 300);
                                                    $('input[name=aig_column][value="<?php echo $data['aig_column'] ?>"]').attr('chekced', true).trigger('click');
                                                });
                                            </script>
                                        <?php } ?>
                                        <div class="aig_column">
                                            <label>
                                                <input type="radio" name="aig_column" value="1"> 1열
                                                <img src='./image/1.png'>
                                            </label>
                                            <label>
                                                <input type="radio" name="aig_column" value="2-1-1"> 2열(1:1)
                                                <img src='./image/2-1.png'>
                                            </label>
                                            <label>
                                                <input type="radio" name="aig_column" value="2-2-1"> 2열(2:1)
                                                <img src='./image/2-2.png'>
                                            </label>
                                            <label>
                                                <input type="radio" name="aig_column" value="2-1-2"> 2열(1:2)
                                                <img src='./image/2-3.png'>
                                            </label>
                                            <label>
                                                <input type="radio" name="aig_column" value="3"> 3열
                                                <img src='./image/3.png'>
                                            </label>
                                        </div>
                                        <span class="help text text-default">
                                            &middot; 배치될 열수를 선택하세요. <br/>
                                            &middot; 메인페이지-ASIDE 선택시 1열을 선택하세요.
                                        </span>
                                            <div class="alert alert-danger">
                                                열에 맞게 2단계 최신글을 등록해야 합니다. 1열은 최소 1개, 2열은 2개, 3열은 3개. 선택한 열의 배수로 최신글을 등록하세요. <br/>예를 들면 3열에 2개의 최신글을 등록하면 화면이 비정상으로 출력됩니다.
                                            </div>
                                    </div>
                                </div>
                                <div class="tb-row">
                                    <div class="tb-cell">
                                        정렬
                                    </div>
                                    <div class="tb-cell">
                                        <input type="text" name='aig_sort' value="<?php echo $data['aig_sort'] ?>" class="input" placeholder="숫자입력">
                                        <span class="help text text-default">숫자를 입력하세요. 작은 숫자가 상단에 출력됩니다.</span>
                                    </div>
                                </div>

                                <div class="tb-row">
                                    <div class="tb-cell">

                                    </div>
                                    <div class="tb-cell">
                                        <div class="button-group float-left">
                                            <button type="submit" class="button primary submit"><i class="fa fa-check"></i> 확인</button>
                                            <button type="button" class="button danger cancel"><i class="fa fa-ban"></i> 취소</button>
                                        </div>
                                        <?php if ($w == 'u' && $idx) { ?>
                                            <div class="button-group float-right">
                                                <a href='./indexgroup_delete.php?idx=<?php echo $data['aig_idx'] ?>&type=parent&amp;token=<?php echo $token?>' class="button danger delete"><i class="fa fa-trash"></i> 삭제</a>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--responsetable-->
                    </form>
                </div>
                <!--  등록된 최신글 목록 -->
                <?php
                if ($w == 'u' && $idx) {
                    ?>
                    <div class="panel-body">
                        <div class="button-group">
                            <a href='./indexgroup_child_add.php?parent_idx=<?php echo $idx ?>' class="button"><i class="fa fa-check"></i> 2단계 - 최신글 등록</a>
                            <a href='./indexgroup_child_tab_add.php?parent_idx=<?php echo $idx ?>' class="button"><i class="fa fa-folder-o "></i> 2단계 - Tab 최신글 등록</a>
                            <a href='./indexgroup_child_page_add.php?parent_idx=<?php echo $idx ?>' class="button"><i class="fa fa-html5"></i> 2단계 - HTML 등록</a>
                        </div>
                        <?php
                        $indexgroup_config = get_plugin_config($plugin['id']);
                        $sql = "select * from ask_plugin_indexgroup_child where aic_parent_idx = '{$idx}' order by aic_sort";
                        $result = sql_query($sql);
                        if ($indexgroup_config['pc_use'] == 0) {
                            echo "<div class='alert alert-default'>플러그인이 사용 중지상태입니다. 설정 메뉴에서 변경가능합니다.</div>";
                        }
                        ?>

                        <div class="responsetable tb-even center">
                            <div class="caption">
                                등록된 최신글 / HTML 컨텐츠 목록
                            </div>
                            <div class="tb-header">
                                <div class="tb-row">
                                    <div class="tb-cell">
                                        게시판
                                    </div>
                                    <div class="tb-cell">
                                        줄수
                                    </div>
                                    <div class="tb-cell">
                                        스킨
                                    </div>
                                    <div class="tb-cell">
                                        상태
                                    </div>
                                    <div class="tb-cell">
                                        관리
                                    </div>
                                </div>
                            </div>
                            <div class="tb-body">
                                <?php for ($i = 0; $rows = sql_fetch_array($result); $i++) { ?>
                                    <div class="tb-row">
                                        <div class="tb-cell">
                                            <?php
                                            if ($rows['aic_bo_table'] && !$rows['aic_tab']) {
                                                $bo_name = ask_get_board($rows['aic_bo_table']);
                                                echo "<a href='" . G5_BBS_URL . "/board.php?bo_table={$bo_name['bo_table']}' target='_blank'><i class='fa fa-link'></i> " . $bo_name['bo_subject'] . "</a>";
                                            } else if ($rows['aic_tab']) {
                                                //탭표시
                                                $array = explode(',', trim($rows['aic_bo_table']));
                                                $tables = array_filter($array);
                                                echo "TAB : ";
                                                foreach ($tables as $val) {
                                                    $tabs = preg_replace("/\(.*?\)/", "", $val);
                                                    $bo_subject = ask_get_board($tabs);
                                                    echo "<a href='" . G5_BBS_URL . "/board.php?bo_table={$bo_name['bo_table']}' target='_blank'><i class='fa fa-link'></i> " . $bo_subject['bo_subject'] . "</a> ";
                                                }
                                            }
                                            if ($rows['aic_html']) {
                                                echo cut_str(strip_tags($rows['aic_html']), 30);
                                            }
                                            ?>
                                        </div>
                                        <div class="tb-cell">
                                            <?php echo $rows['aic_rows'] ?>
                                        </div>
                                        <div class="tb-cell">
                                            <?php echo $rows['aic_type'] ?>
                                            <?php
                                            if ($rows['aic_html']) {
                                                echo '<i class="fa fa-html5"></i> HTML 컨텐츠';
                                            }
                                            ?>
                                        </div>
                                        <div class="tb-cell">
                                            <?php
                                            if ($rows['aic_status']) {
                                                echo '<i class="fa fa-toggle-on"></i>';
                                            } else {
                                                echo '<i class="fa fa-toggle-off"></i>';
                                            }
                                            ?>    
                                        </div>

                                        <div class="tb-cell">
                                            <div class="button-group nowrap">
                                                <?php
                                                if ($rows['aic_html']) {
                                                    $page = 'page_';
                                                } elseif ($rows['aic_tab'] == '1') {
                                                    $page = 'tab_';
                                                } else {
                                                    $page = '';
                                                }
                                                ?>
                                                <a href="./indexgroup_child_<?php echo $page ?>add.php?w=u&idx=<?php echo $rows['aic_idx'] ?>" class="button primary button-sm"><i class="fa fa-pencil"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if ($i == 0) { ?>
                                    <div class="tb-row-group">
                                        <div class="tb-row">
                                            <div class="tb-cell empty-table">
                                                등록된 꾸미기가 없습니다.
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>


                        <script type="text/javascript">
                            $(function () {
                                $('.child-delete').click(function () {
                                    if (confirm('페이지를 삭제하시겠습니까?')) {
                                        return true;
                                    } else {
                                        return false;
                                    }
                                });
                            });
                        </script>
                    </div>

                <?php } ?>
                <div class="panel-footer">
                    &middot; 꾸미기 등록후 하위 최신글을 여러개 추가 가능합니다.
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(function () {
        $('.cancel').click(function () {
            if (confirm('취소하시겠습니까?')) {
<?php if ($popup) { ?>
                    window.close();
<?php } else { ?>
                    location.href = history.go(-1);
<?php } ?>
            } else {
                return false;
            }
        });
        $('.delete').click(function () {
            if (confirm('꾸미기를 삭제하면 하위 최신글 설정이 모두 삭제됩니다. \n\n삭제하시겠습니까?')) {
                return true;
            } else {
                return false;
            }
        });
    });
    function form_submit(f) {
        //console.log(f);
        var use_indexgroup = $('input[name=aig_status]:checked').val();
        if (use_indexgroup === undefined) {
            alert('꾸미기 사용여부를 선택하세요');
            return false;
        }
        if ($('select[name=aig_area]').val() == "") {
            alert('꾸미기 위치를 입력하세요.');
            return false;
        }

        var use_column = $('input[name=aig_column]:checked').val();
        if (use_column === undefined) {
            alert('열수를 선택하세요.');
            return false;
        }
        if ($('input[name=aig_sort]').val() == '') {
            alert('정렬용 숫자를 입력하세요');
            return false;
        }

        return true;
    }
</script>
<?php
include_once G5_PLUGIN_PATH . "/asktheme/_admin/tail.php";

