<?php
if (!defined("_GNUBOARD_")) {
    exit;
} // 개별 페이지 접근 불가
// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="' . G5_THEME_CSS_URL . '/skin/mobile/asktheme.poll.css">', 0);
include G5_THEME_PATH . "/head.php";
?>

<div class="page-wrap poll-result">
    <div class="page-title">
        <h1><?php echo $g5['title'] ?> - <?php echo $po_subject ?> 결과</h1>
    </div>

    <section>
        <dl>
            <dt><span>전체 <?php echo $nf_total_po_cnt ?>표</span></dt>
            <dd>
                <ol class="poll-list">
                    <?php for ($i = 1; $i <= count($list); $i++) { ?>
                        <li>
                            <p>
                                <span class="poll-item"><?php echo $list[$i]['content'] ?></span>
                                <strong><?php echo $list[$i]['cnt'] ?> 표</strong>
                                <span><?php echo number_format($list[$i]['rate'], 1) ?> 퍼센트</span>
                            </p>
                            <div class="poll_result_graph">
                                <span style="width:<?php echo number_format($list[$i]['rate'], 1) ?>%"></span>
                            </div>
                        </li>
                    <?php } ?>
                </ol>
            </dd>
        </dl>
    </section>
    <!-- } 설문조사 결과 그래프 끝 -->

    <!-- 설문조사 기타의견 시작 { -->
    <?php if ($is_etc) { ?>
        <hr>
        <section class="etc-result">
            <div class="alert alert-default">이 설문에 대한 기타의견</div>

            <?php 
            for ($i = 0; $i < count($list2); $i++) {
                $list2[$i]['name'] = no_popup($list2[$i]['name']);
                ?>
                <article class="etc-contents">
                    <header>
                        <h5 class="sound-only"><?php echo $list2[$i]['pc_name'] ?> 님의 의견 </h5>
                        <?php echo $list2[$i]['name'] ?>
                        <span class="poll_datetime"><?php echo $list2[$i]['datetime'] ?></span>
                    </header>
                    <p>
                        <?php echo $list2[$i]['idea'] ?>
                    </p>
                    <footer>
                        <span class="poll_cmt_del">
                            <?php
                            if ($list2[$i]['del']) {
                                $list2[$i]['del'] = str_replace('poll_delete', 'poll_delete button', $list2[$i]['del']);
                                echo $list2[$i]['del'] . "<i class='fa fa-trash'></i></a>";
                            }
                            ?>
                        </span>
                    </footer>
                </article>
            <?php } ?>

            <?php if ($member['mb_level'] >= $po['po_level']) { ?>
            <hr>
                <form name="fpollresult" action="./poll_etc_update.php" onsubmit="return fpollresult_submit(this);" method="post" autocomplete="off">
                    <input type="hidden" name="po_id" value="<?php echo $po_id ?>">
                    <input type="hidden" name="w" value="">
                    <input type="hidden" name="skin_dir" value="<?php echo urlencode($skin_dir); ?>">
                    <?php if ($is_member) { ?><input type="hidden" name="pc_name" value="<?php echo get_text(cut_str($member['mb_nick'], 255)) ?>"><?php } ?>
                    <div class="alert alert-default"><?php echo $po_etc ?></div>

                    <div class="responsetable form-table poll-etc">
                        <div class="tb-body">
                            <?php if ($is_guest) { ?>
                                <div class='tb-row'>
                                    <div class='tb-cell tb-hd'><label for="pc_name">이름<strong class="sound_only">필수</strong></label></div>
                                    <div><input type="text" name="pc_name" id="pc_name" required class="input required" size="10" placeholder="이름"></div>
                                </div>
                            <?php } ?>
                            <div class='tb-row'>
                                <div class='tb-cell tb-hd'><label for="pc_idea">의견<strong class="sound_only">필수</strong></label></div>
                                <div class="tb-cell"><input type="text" id="pc_idea" name="pc_idea" required class="input required" size="47" maxlength="100" placeholder="의견을 입력하세요."></div>
                            </div>
                            <?php if ($is_guest) { ?>
                                <div class='tb-row'>
                                    <div class='tb-cell tb-hd'>자동등록방지</div> 
                                    <div class="tb-cell"><?php
                                        $captcha_html = ask_captcha_html();
                                        echo $captcha_html;
                                        ?>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>

                    <div class="form-action">
                        <input type="submit" class="button" value="의견남기기">
                    </div>
                </form>
            <?php } ?>

        </section>
    <?php } ?>
    <!-- } 설문조사 기타의견 끝 -->

    <!-- 설문조사 다른 결과 보기 시작 { -->
    <aside class="etc-poll-list">
        <div class="alert alert-default">다른 투표 결과 보기</div>
        <ul>
            <?php for ($i = 0; $i < count($list3); $i++) { ?>
                <li><a href="./poll_result.php?po_id=<?php echo $list3[$i]['po_id'] ?>&amp;skin_dir=<?php echo urlencode($skin_dir); ?>">[<?php echo $list3[$i]['date'] ?>] <?php echo $list3[$i]['subject'] ?></a></li>
            <?php } ?>
        </ul>
    </aside>
</div>

<script type="text/javascript">
    $(function () {
        $(".poll_delete").click(function () {
            if (!confirm("해당 기타의견을 삭제하시겠습니까?"))
                return false;
        });
    });

    function fpollresult_submit(f)
    {
<?php
if ($is_guest) {
    echo chk_captcha_js();
}
?>

        return true;
    }
</script>
<?php
include G5_THEME_PATH . "/tail.php";
