<?php
if (!defined("_GNUBOARD_")) {
    exit;
} // 개별 페이지 접근 불가
// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="' . G5_THEME_CSS_URL . '/skin/mobile/asktheme.search.css">', 0);
?>
<div class="page-wrap page-search">
    <div class="page-title">
        <h1>상세검색</h1>
    </div>

    <div class="search-wrap">
        <!-- 전체검색 시작 { -->
        <form name="fsearch" onsubmit="return fsearch_submit(this);" method="get">
            <div class="row">
                <input type="hidden" name="srows" value="<?php echo $srows ?>">
                <fieldset class="center">
                    <legend class="sound-only">상세검색</legend>
                    <div class='small-12 medium-3 large-3 columns'>
                        <?php
                        echo str_replace('select', 'select input-x', $group_select);
                        ?>
                        <script>document.getElementById("gr_id").value = "<?php echo $gr_id ?>";</script>
                    </div>
                    <div class='small-12 medium-3 large-3 columns'>
                        <label for="sfl" class="sound_only">검색조건</label>
                        <select name="sfl" id="sfl" class="">
                            <option value="wr_subject||wr_content"<?php echo get_selected($_GET['sfl'], "wr_subject||wr_content") ?>>제목+내용</option>
                            <option value="wr_subject"<?php echo get_selected($_GET['sfl'], "wr_subject") ?>>제목</option>
                            <option value="wr_content"<?php echo get_selected($_GET['sfl'], "wr_content") ?>>내용</option>
                            <option value="mb_id"<?php echo get_selected($_GET['sfl'], "mb_id") ?>>회원아이디</option>
                            <option value="wr_name"<?php echo get_selected($_GET['sfl'], "wr_name") ?>>이름</option>
                        </select>
                    </div>

                    <div class='small-12 medium-6 large-6 columns'>
                        <label for="stx" class="sound_only">검색어<strong class="sound_only"> 필수</strong></label>
                        <div class="input-group">
                            <input type="text" name="stx" value="<?php echo $text_stx ?>" id="stx" required class="input-group-field required" maxlength="20" placeholder="검색어 입력">
                            <div class="input-group-button">
                                <button type="submit" class="button"><i class="fa fa-search"></i></button>
                            </div>
                        </div>
                    </div>
                    <script type="text/javascript">
                        function fsearch_submit(f)
                        {
                            if (f.stx.value.length < 2) {
                                alert("검색어는 두글자 이상 입력하십시오.");
                                f.stx.select();
                                f.stx.focus();
                                return false;
                            }

                            // 검색에 많은 부하가 걸리는 경우 이 주석을 제거하세요.
                            var cnt = 0;
                            for (var i = 0; i < f.stx.value.length; i++) {
                                if (f.stx.value.charAt(i) == ' ')
                                    cnt++;
                            }

                            if (cnt > 1) {
                                alert("빠른 검색을 위하여 검색어에 공백은 한개만 입력할 수 있습니다.");
                                f.stx.select();
                                f.stx.focus();
                                return false;
                            }

                            f.action = "";
                            return true;
                        }
                    </script>
                    <div class='tb-caption'>
                        <input type="radio" value="or" <?php echo ($sop == "or") ? "checked" : ""; ?> id="sop_or" name="sop">
                        <label for="sop_or">OR</label>
                        <input type="radio" value="and" <?php echo ($sop == "and") ? "checked" : ""; ?> id="sop_and" name="sop">
                        <label for="sop_and">AND</label>
                    </div>
                </fieldset>
            </div>
            <div class="popular row">
                <?php echo popular('theme/basic'); ?>
            </div>
        </form>
    </div><!--//.search-wrap -->
    <div class="search-result">
        <?php
        if ($stx) {
            if ($board_count) {
                ?>
                <section class="info-box">
                    <h2 class="info-box-title"><?php echo $stx ?> 전체검색 결과</h2>
                    <dl class="info-box-body">
                        <dt>게시판 : </dt>
                        <dd><strong class="sch_word"><?php echo $board_count ?>개</strong></dd>
                        <dt>게시물 : </dt>
                        <dd><strong class="sch_word"><?php echo number_format($total_count) ?>개</strong></dd>
                    </dl>
                    <p><?php echo number_format($page) ?>/<?php echo number_format($total_page) ?> 페이지 열람 중</p>
                    <?php if ($board_count) {
                        ?>
                        <nav aria-label="Search result:" role="navigation">
                            <ul class="breadcrumbs">
                                <li><a href="?<?php echo $search_query ?>&amp;gr_id=<?php echo $gr_id ?>" <?php echo $sch_all ?>>전체게시판</a></li>
                                <?php echo $str_board_list; ?>
                            </ul>
                        </nav>
                        <?php
                    }
                    ?>
                </section>
                <?php
            } else {
                ?>
                <div class="center">검색된 자료가 없습니다.</div>
                <?php
            }
        }
        ?>

        <?php if ($stx && $board_count) { ?>
            <section class="search-result-wrap">
            <?php } ?>
            <?php
            $k = 0;
            for ($idx = $table_index, $k = 0; $idx < count($search_table) && $k < $rows; $idx++) {
                ?>
                <h2><a href="./board.php?bo_table=<?php echo $search_table[$idx] ?>&amp;<?php echo $search_query ?>"><?php echo $bo_subject[$idx] ?> 게시판 내 결과</a></h2>
                <ul>
                    <?php
                    for ($i = 0; $i < count($list[$idx]) && $k < $rows; $i++, $k++) {
                        if ($list[$idx][$i]['wr_is_comment']) {
                            $comment_def = '<span class="cmt_def">댓글 | </span>';
                            $comment_href = '#c_' . $list[$idx][$i]['wr_id'];
                        } else {
                            $comment_def = '';
                            $comment_href = '';
                        }
                        ?>

                        <li>
                            <a href="<?php echo $list[$idx][$i]['href'] ?><?php echo $comment_href ?>" class="subject"><?php echo $comment_def ?><?php echo $list[$idx][$i]['subject'] ?></a>
                            <a href="<?php echo $list[$idx][$i]['href'] ?><?php echo $comment_href ?>" target="_blank" class="new-link"><i class="fa fa-link"></i> 새창</a>
                            <p><?php echo $list[$idx][$i]['content'] ?></p>
                            <div class="wr-info">
                                <i class="fa fa-user"></i> <?php echo $list[$idx][$i]['name'] ?>
                                <span><?php echo $list[$idx][$i]['wr_datetime'] ?></span>
                            </div>

                        </li>
                    <?php } ?>
                </ul>
                <div class="more-view center">
                    <a href="./board.php?bo_table=<?php echo $search_table[$idx] ?>&amp;<?php echo $search_query ?>" class="button"><strong><?php echo $bo_subject[$idx] ?></strong> 결과 더보기 <i class="fa fa-link"></i></a>
                </div>
                <hr>
            <?php } ?>
            <?php if ($stx && $board_count) { ?>
            </section>
        <?php } ?>

        <div class="paging-wrap">
            <?php echo $write_pages ?>
        </div>
    </div>
</div>