<?php
if (!defined('_GNUBOARD_')) {
    exit;
} // 개별 페이지 접근 불가
// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="' . G5_THEME_CSS_URL . '/skin/asktheme.member.css">', 0);
include G5_THEME_PATH . "/head.php";
?>

<div class='page-wrap formmail-page'>
    <div class='page-title'>
        <h1><?php echo $name ?>님께 메일보내기</h1>
    </div>

    <form name="fformmail" action="./formmail_send.php" onsubmit="return fformmail_submit(this);" method="post" enctype="multipart/form-data" style="margin:0px;">
        <input type="hidden" name="to" value="<?php echo $email ?>">
        <input type="hidden" name="attach" value="2">
        <?php if ($is_member) { // 회원이면     ?>
            <input type="hidden" name="fnick" value="<?php echo get_text($member['mb_nick']) ?>">
            <input type="hidden" name="fmail" value="<?php echo $member['mb_email'] ?>">
        <?php } ?>

        <?php if (!$is_member) { ?>
            <div class='row'>
                <div class='small-12 medium-2 large-2 columns'><label for="fnick" class="middle">이름<strong class="sound_only">필수</strong></label></div>
                <div class='small-12 medium-10 large-10 columns'><input type="text" name="fnick" id="fnick" required class="input required"></div>
            </div>
            <div class='row'>
                <div class='small-12 medium-2 large-2 columns'><label for="fmail" class="middle">E-mail<strong class="sound_only">필수</strong></label></div>
                <div class='small-12 medium-10 large-10 columns'><input type="text" name="fmail"  id="fmail" required class="input required"></div>
            </div>
        <?php } ?>
        <div class='row'>
            <div class='small-12 medium-2 large-2 columns'><label for="subject" class="middle mail-subject">제목<strong class="sound_only">필수</strong></label></div>
            <div class='small-12 medium-10 large-10 columns'><input type="text" name="subject" id="subject" required class="input required"></div>
        </div>
        <div class='row'>
            <div class='small-12 medium-2 large-2 columns'><label class="middle">형식</label></div>
            <div class='small-12 medium-10 large-10 columns'>
                <input type="radio" name="type" value="0" id="type_text" checked> <label for="type_text">TEXT</label>
                <input type="radio" name="type" value="1" id="type_html"> <label for="type_html">HTML</label>
                <input type="radio" name="type" value="2" id="type_both"> <label for="type_both">TEXT+HTML</label>
            </div>
        </div>
        <div class='row'>
            <div class='small-12 medium-2 large-2 columns'><label for="content" class="middle">내용<strong class="sound_only">필수</strong></label></div>
            <div class='small-12 medium-10 large-10 columns'><textarea name="content" id="content" required class="required textarea"></textarea></div>
        </div>
        <div class='row'>
            <div class='small-12 medium-2 large-2 columns'><label for="file1" class="middle">첨부 파일 1</label></div>
            <div class='small-12 medium-10 large-10 columns'>
                <input type="file" name="file1"  id="file1"  class="file">
                <div class="alert alert-default">첨부 파일은 누락될 수 있으므로 메일을 보낸 후 파일이 첨부 되었는지 반드시 확인해 주시기 바랍니다.</div>
            </div>
        </div>
        <div class='row'>
            <div class='small-12 medium-2 large-2 columns'><label for="file2" class="middle">첨부 파일 2</label></div>
            <div class='small-12 medium-10 large-10 columns'><input type="file" name="file2" id="file2" class="file"></div>
        </div>
        <div class='row'>
            <div class='small-12 medium-2 large-2 columns show-for-medium'>자동등록방지</div>
            <div class='small-12 medium-10 large-10 columns'>
                <?php echo ask_captcha_html(); ?>
            </div>
        </div>

        <div class="form-footer float-right">
            <input type="submit" value="메일발송" id="btn_submit" class="button">
        </div>

    </form>
</div>

<script type="text/javascript">
    with (document.fformmail) {
        if (typeof fname != "undefined")
            fname.focus();
        else if (typeof subject != "undefined")
            subject.focus();
    }

    function fformmail_submit(f) {
<?php echo chk_captcha_js(); ?>

        if (f.file1.value || f.file2.value) {
            // 4.00.11
            if (!confirm("첨부파일의 용량이 큰경우 전송시간이 오래 걸립니다.\n\n메일보내기가 완료되기 전에 창을 닫거나 새로고침 하지 마십시오."))
                return false;
        }

        document.getElementById('btn_submit').disabled = true;

        return true;
    }
</script>

<?php
include G5_THEME_PATH . "/tail.php";
