<?php
if (!defined("_GNUBOARD_")) {
    exit;
} // 개별 페이지 접근 불가
// 선택삭제으로 인해 셀합치기가 가변적으로 변함
$colspan = 5;

if ($is_admin) {
    $colspan++;
}

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="' . G5_THEME_CSS_URL . '/skin/asktheme.new.css">', 0);
?>
<div class="page-wrap">
    <div class="page-title">
        <h1>최신글</h1>
    </div>

    <!-- 전체게시물 검색 시작 { -->
    <fieldset id="new_sch" class="new-search-form row">
        <legend class="sound-only">상세검색</legend>
        <div class='small-12 medium-8 large-6 medium-centered large-centered columns'>
            <form name="fnew" method="get">
                <div class="row">
                    <div class='small-12 medium-3 large-3 columns'>
                        <?php echo str_replace('name="gr_id"', 'name="gr_id" class="input"', $group_select) ?>
                    </div>
                    <div class='small-12 medium-3 large-3 columns'>
                        <label for="view" class="sound-only">검색대상</label>
                        <select name="view" id="view" class="input">
                            <option value="">전체게시물</option>
                            <option value="w">원글만</option>
                            <option value="c">코멘트만</option>
                        </select>
                    </div>
                    <div class='small-12 medium-6 large-6 columns'>
                        <div class="input-group">
                            <label for="mb_id" class="sound-only">검색어<strong class="sound_only"> 필수</strong></label>
                            <input type="text" name="mb_id" value="<?php echo $mb_id ?>" id="mb_id" required class="input-group-field required">
                            <div class="input-group-button">
                                <input type="submit" value="검색" class="button">
                            </div>
                        </div>
                        <span class="help-text"> 회원 아이디만 검색 가능</span>
                    </div>
                </div>
            </form>
        </div>
        <script type="text/javascript">
            /* 셀렉트 박스에서 자동 이동 해제
             function select_change()
             {
             document.fnew.submit();
             }
             */
            document.getElementById("gr_id").value = "<?php echo $gr_id ?>";
            document.getElementById("view").value = "<?php echo $view ?>";
        </script>
    </fieldset>
    <!-- } 전체게시물 검색 끝 -->

    <!-- 전체게시물 목록 시작 { -->
    <form name="fnewlist" method="post" action="#" onsubmit="return fnew_submit(this);">
        <input type="hidden" name="sw"       value="move">
        <input type="hidden" name="view"     value="<?php echo $view; ?>">
        <input type="hidden" name="sfl"      value="<?php echo $sfl; ?>">
        <input type="hidden" name="stx"      value="<?php echo $stx; ?>">
        <input type="hidden" name="bo_table" value="<?php echo $bo_table; ?>">
        <input type="hidden" name="page"     value="<?php echo $page; ?>">
        <input type="hidden" name="pressed"  value="">

        <div class='responsetable tb-even'>
            <div class='tb-header'>
                <div class='tb-row'>
                    <?php if ($is_admin) { ?>
                        <div class='tb-cell'>
                            <label for="all_chk" class="sound_only">목록 전체</label>
                            <input type="checkbox" id="all_chk">
                        </div>
                    <?php } ?>
                    <div class='tb-cell'>그룹</div>
                    <div class='tb-cell'>게시판</div>
                    <div class='tb-cell'>제목</div>
                    <div class='tb-cell'>이름</div>
                    <div class='tb-cell'>일시</div>
                </div>
            </div>
            <div class="tb-body">
                <?php
                for ($i = 0; $i < count($list); $i++) {
                    $num = $total_count - ($page - 1) * $config['cf_page_rows'] - $i;
                    $gr_subject = cut_str($list[$i]['gr_subject'], 20);
                    $bo_subject = cut_str($list[$i]['bo_subject'], 20);
                    $wr_subject = get_text(cut_str($list[$i]['wr_subject'], 80));
                    ?>
                    <div class='tb-row'>
                        <?php if ($is_admin) { ?>
                            <div class='tb-cell center'>
                                <label for="chk_bn_id_<?php echo $i; ?>" class="sound-only"><?php echo $num ?>번</label>
                                <input type="checkbox" name="chk_bn_id[]" value="<?php echo $i; ?>" id="chk_bn_id_<?php echo $i; ?>">
                                <input type="hidden" name="bo_table[<?php echo $i; ?>]" value="<?php echo $list[$i]['bo_table']; ?>">
                                <input type="hidden" name="wr_id[<?php echo $i; ?>]" value="<?php echo $list[$i]['wr_id']; ?>">
                            </div>
                        <?php } ?>
                        <div class='tb-cell center'><a href="./new.php?gr_id=<?php echo $list[$i]['gr_id'] ?>"><?php echo $gr_subject ?></a></div>
                        <div class='tb-cell center'><a href="./board.php?bo_table=<?php echo $list[$i]['bo_table'] ?>"><?php echo $bo_subject ?></a></div>
                        <div class='tb-cell wr-subject'>
                            <a href="<?php echo $list[$i]['href'] ?>"><?php echo $list[$i]['comment'] ?><?php echo $wr_subject ?></a>
                            <span class="mobi-view"><?php echo $list[$i]['name'] ?></span>
                            <span class="mobi-view"><?php echo $list[$i]['datetime2'] ?></span>
                        </div>
                        <div class='tb-cell center'><div><?php echo $list[$i]['name'] ?></div></div>
                        <div class='tb-cell center'><?php echo $list[$i]['datetime2'] ?></div>
                    </div>
                <?php } ?>

                <?php
                if ($i == 0) {
                    echo "<div class='tb-row'><div class='empty_table tb-cell'>게시물이 없습니다.</div></div>";
                }
                ?>
            </div>
        </div>

        <?php if ($is_admin) { ?>
            <div class="button-group">
                <input type="submit" onclick="document.pressed = this.value" value="선택삭제" class="button danger">
            </div>
        <?php } ?>
    </form>

    <?php if ($is_admin) { ?>
        <script type=text/javascript"">
            $(function () {
                $('#all_chk').click(function () {
                    $('[name="chk_bn_id[]"]').attr('checked', this.checked);
                });
            });

            function fnew_submit(f)
            {
                f.pressed.value = document.pressed;

                var cnt = 0;
                for (var i = 0; i < f.length; i++) {
                    if (f.elements[i].name == "chk_bn_id[]" && f.elements[i].checked)
                        cnt++;
                }

                if (!cnt) {
                    alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
                    return false;
                }

                if (!confirm("선택한 게시물을 정말 " + document.pressed + " 하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다")) {
                    return false;
                }

                f.action = "./new_delete.php";

                return true;
            }
        </script>
    <?php } ?>
    <div class="paging-wrap">
        <?php echo $write_pages ?>
    </div>

</div>