<?

//=================================================
$viewBase["ImgMenu"]		= "no";		// 메뉴 이미지 사용여부, yes:이미지 사용, no:텍스트 사용
// 이미지 사용시 유의사항
/*
1. /viewRes/images 폴더에 mainmenu, submenu 폴더를 생성한다.
	
2. mainmenu 폴더 : 메인메뉴에 사용되는 이미지를 저장
	contents 게시판에서 분류명(메인메뉴)으로 입력한 순서대로 메인 이미지를 넣어준다.
	예) 메뉴1|메뉴2|메뉴3 .... 
		=> 메뉴 1 이미지 : mainmenu/0_out.png, mainmenu/0_over.png 2개의 이미지를 넣어준다.
		=> 메뉴 2 이미지 : mainmenu/1_out.png, mainmenu/1_over.png 2개의 이미지를 넣어준다.
		=> 메뉴 3 이미지 : mainmenu/2_out.png, mainmenu/2_over.png 2개의 이미지를 넣어준다.
		=> 메뉴0|메뉴1|메뉴2 .. : 분류의 순번은 차례대로 0, 1, 2 가 된다.
	
	메인메뉴의 서브메뉴 이미지
		예) 메뉴1(분류 첫번째 일때) : 메뉴11(wr_id=25), 메뉴22(wr_id=30) ...
			=> 메뉴11 : sub_25_out.png, sub_25_over.png
			=> 메뉴22 : sub_30_out.png, sub_30_over.png
			=> wr_id 를 이용하여 파일명을 만든다.
	
3. submenu 폴더 : 서브메뉴에 사용할 이미지를 저장
	각 서브메뉴의 wr_id 를 이용하여 이미지를 생성한다.
	예) 인사말:wr_id=10, 찾아오시는 길:wr_id=11 일때
		=> 인사말 		: submenu/10_out.png, submenu/10_over.png 2개의 이미지를 넣어준다.
		=> 찾아오시는 길 : submenu/11_out.png, submenu/11_over.png 2개의 이미지를 넣어준다.
	=> wr_id 를 이용하여 파일명을 만든다.
*/
//=================================================

//=================================================
$viewBase["Folder"]		= "viewRes";
$viewBase["bo_table"] 	= "contents";										// 게시판의 bo_table 명
$viewBase["table"] 		= "g5_write_" . $viewBase["bo_table"];	// 컨텐츠 게시판의 테이블 명
$viewBase["page"] 		= G5_THEME_URL . "/view.php";						// 컨텐츠 보여지는 페이지


define('G5_CMS_DIR', $viewBase["Folder"]);
define('G5_CMS_URL', G5_URL.'/'.G5_CMS_DIR);

/*
echo "===>" . G5_URL . "<br />";
echo "===>" . G5_CMS_DIR  . "<br />";
echo "===>" . G5_CMS_URL . "<br />";
echo "<br />";
echo "===>" . G5_THEME_DIR  . "<br />";
echo "===>" . G5_THEME_PATH  . "<br />";
echo "===>" . G5_THEME_URL  . "<br />";
echo "<br />";
echo "===>" . G5_THEME_MOBILE_PATH  . "<br />";
echo "<br />";
*/


// 메인메뉴 데이타 가져오기
// 컨텐츠 게시판의 카테고리를 읽어와서 메인메뉴를 만든다.
//=================================================
$sql_cate = " select bo_category_list from {$g5['board_table']} where bo_table = '{$viewBase["bo_table"]}' "; 
$row_cate = sql_fetch ($sql_cate);

$MainMenuData = explode("|", $row_cate["bo_category_list"]);	// 읽어온 카테고리가 주메뉴가 된다.

$MainMenuHidden = array("마이페이지");	// 카테고리중 메인메뉴 노출을 안할 것들


$tmpCount = 0;
unset($tmpMenuData);
foreach ($MainMenuData as $key => $value) {		// 메인메뉴 노출안할 것들 여기서 감추기
	
	$tmpChk = "no";
	foreach ($MainMenuHidden as $key2 => $value2) {
		if ($value == $value2) {	// 감춰야할 메인메뉴가 있는지 체크, 있으면 ok
			$tmpChk = "ok";
		}
	}
	
	if ($tmpChk == "no") {			// 감춰야할 메인메뉴는 기억하지 않는다.
		$tmpMenuData[$tmpCount] = $value;
		$tmpCount ++;
	}
}

unset($MainMenuData);
$MainMenuData = $tmpMenuData;	// 실제사용할 데이타들만 기억한다.
//=================================================

//=================================================
// 코드를 입력받아서 해당 컨텐츠의 정보들 읽어오기
$pageID = $_REQUEST["pageID"];
if (!$pageID) {		// 페이지 코드값이 없을 때는 bo_table 값으로 가져온다.
	
	if ($bo_table) {	// 게시판일때, bo_table 로 해당 pageID 를 찾는다.
		$sql_boTable = " select wr_id from  {$viewBase["table"]} where wr_3 = '{$bo_table}' ";
	
	} else {				// bo_table값도 없을 때, 현재파일로 검색해서 pageID 를 찾는다.
		$sql_boTable = " select wr_id from  {$viewBase["table"]} where wr_3 = '{$_SERVER["PHP_SELF"]}' ";

	}

	$row_boTable = sql_fetch($sql_boTable);
	$pageID = $row_boTable["wr_id"];		

	
	if (!$pageID) {		// 페이지가 정의되지 않았으면, wr_good:출력순서가 가장  낮고, 작성일자가 가장 오래된 것을 가져온다.
		$sql_boTable = " select wr_id from  {$viewBase["table"]} order by wr_good asc, wr_id asc ";
		$row_boTable = sql_fetch($sql_boTable);
		$pageID = $row_boTable["wr_id"];		
	}
}
//echo "pageID=>" .  $pageID . "::" . !defined('_GNUBOARD_'); 


// 게시판설정에서 출력방법을 'wr_good 추천수 높은것부터' 로 설정해주세요.
// 출력순서는 모두 다르게 하고, 같으면 탭메뉴에서 사용하게 된다.

// 읽어올 컨텐츠 가져오기
$sql_view = " select * from {$viewBase["table"]} where wr_id = '{$pageID}' ";
$row_view = sql_fetch($sql_view);

if ($pageID != $row_view["wr_id"]) {		// pageID에 대한 정보가 없으면, 메인으로 보낸다.
	alert(" {$pageID} : 페이지 정보가 없습니다. ", "/");
}
	
$viewData["ca_name"] = $row_view["ca_name"];
$viewData["wr_id"] = $row_view["wr_id"];


// 제목이 없을때는 메인메뉴를 보여준다. 회원가입,정보수정 등
$viewData["wr_subject"] = $row_view["wr_subject"];
if ( !($viewData["wr_subject"]) ) $viewData["wr_subject"] = $MainMenuHidden[0];	

$viewData["wr_content"] = $row_view["wr_content"];

$viewData["wr_good"] = $row_view["wr_good"];	// 출력순서, 숫자가 높을 수록 먼저 출력
$viewData["wr_nogood"] = $row_view["wr_nogood"];	// 메뉴단계, 2~5

$viewData["wr_1"] = $row_view["wr_1"];		// 출력여부 1:출력, 2:감춤
$viewData["wr_2"] = $row_view["wr_2"];		// 컨텐츠 분류 1:HTML, 2:LINK, 3:IFRAME, 4:게시판
$viewData["wr_3"] = $row_view["wr_3"];		// URL => HTML:필요없음 LINK와 IFRAME:풀URL  게시판:게시판아이디(bo_table)
$viewData["wr_4"] = $row_view["wr_4"];		// TARGET _blank, _self
$viewData["wr_5"] = $row_view["wr_5"];		// 탭메뉴 사용여부 1:사용안함, 2:사용
$viewData["wr_6"] = $row_view["wr_6"];		// 탭메뉴 출력순서, 숫자가 높을수록 먼저 출력
$viewData["wr_7"] = $row_view["wr_7"];		// 로그인시 출력여부, 1:모두출력, 2:로그인시 출력, 3:로그아웃시 출력
//=================================================



function funcBoardLink($rowRead) {		// 해당 데이타를 받아서, 링크를 만들어, 링크와 타겟을 반환한다.
	global $viewBase;

	$tmpData["wr_id"] = $rowRead["wr_id"];	
	$tmpData["wr_2"] = $rowRead["wr_2"];	// wr_2 -> 1:HTML, 2:LINK, 3:IFRAME
	$tmpData["wr_3"] = $rowRead["wr_3"];	// URL
	$tmpData["wr_4"] = $rowRead["wr_4"];	// _blank:새창, _self:현재창

	$url = "";
	$target = "";
	switch ($tmpData["wr_2"]) {		
		case "2" : 
			$url = $tmpData["wr_3"]; 
			$target = $tmpData["wr_4"]; 
			break;		// 2 : LINK 일때
			
		default : 		// 1:HTML, 3:IFRAME 일때는 일반 링크를 반환
			$url = $viewBase["page"] . "?pageID={$tmpData["wr_id"]}"; 
			$target = $tmpData["wr_4"]; 
			break;
	}
	
	return array($url, $target);
}

?>