<?php
if(!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once('open_check.php');

$boa_table = str_replace("_result","",$write_table);
$bot_table = str_replace("_result","",$bo_table);

$today = date("Y-m-d");
$mid = get_text($member['mb_id']);

$page_rows = 10;	// 보여줄 게시글 수
if ($page < 1) $page = 1; // 페이지가 없으면 1 페이지
$from_record = ($page - 1) * $page_rows; // 시작 열을 구함

$sql = "select count(*) as cnt  from $boa_table";
$tcount = sql_fetch($sql);
$sql = "select * from $boa_table order by wr_3  limit {$from_record}, {$page_rows}";
$result = sql_query($sql);

$total_count = $tcount["cnt"];	//총 레코드 수
$total_page  = ceil($total_count / $page_rows);  // 전체 페이지 계산

$write_pages = get_paging($page_rows, $page, $total_page, get_pretty_url($bo_table, '', $qstr.'&amp;page='));

$x = 0;
?>
<script>
$(document).ready(function(){
  $('[data-bs-toggle="tooltip"]').tooltip();
});
</script>
<div class="container-fluid mb-5">

	<div class="d-flex border-bottom mt-3 mb-5">
	  <div class="fs-4 fw-bold flex-grow-1">체험프로그램</div>
	  <div>
		  <?php if($is_member) { ?>
		  <button class="btn btn-success btn-sm" type="button" data-bs-toggle="collapse" data-bs-target="#collapseExample" aria-expanded="false" aria-controls="collapseExample">
			내신청현황</button>
		  <?php } else { ?>
		  <a href="./board.php?bo_table=<?=$bo_table?>&type=3" class="btn btn-danger btn-sm">신청확인</a>
		  <?php } ?>	  	  
	  </div>
	</div>
	<?php if($is_member) { ?>
	<div class="collapse mb-4" id="collapseExample">
		<?php include_once('myselect_list.php'); ?>
	</div>
	<?php } ?>

	<?php foreach($result as $field) {
	
		$openk = open_confirm($field["wr_2"]);
		if($openk == 0) {
			$bt = "신청하기";
			$disabled = "";
			$bc = "primary";
		} elseif($openk == 1) {
			$bt = "접수대기";
			$disabled = " disabled";
			$bc = "success";
		} else {
			$bt = "접수종료";
			$disabled = " disabled";
			$bc = "secondary";
		}

		$file = get_file($bot_table, $field['wr_id']);

		$x++;
	
		$pconunt = sql_fetch("select count(*) pcount from {$write_table} where wr_link2 = '{$field['wr_id']}'");
		$img_url = $file[0]['path']."/".$file[0]['file'];
	
		$wr_dates = explode("~", $field['wr_2']);
		$wr_mans = explode("|", $field['wr_4']);
		$wr_money = explode("|", $field['wr_5']);	
	
	?>
	  <div class="row border-bottom mb-3 py-2">
			<div class="col-sm-5 col-md-4 mb-4">
				<img src='<?= $img_url ?>' class='card-img-top' style="height:240px">
			</div>
			<div class="col-sm-7 col-md-8">
				<ul class="list-group list-group-flush">
					  <li class="list-group-item d-flex justify-content-between align-items-start text-primary mb-3 px-0">
						  <div>
							  <span class="fs-5 fw-bold align-middle"><i class="bi bi-feather text-danger fs-4"></i> <?= $field['wr_subject'] ?></span>
							  <span class="badge bg-info-subtle border border-info-subtle text-info-emphasis rounded-pill ms-2">인기</span>
							  <span class="badge bg-danger-subtle border border-danger-subtle text-danger-emphasis rounded-pill ms-2">추천</span>
						  </div>
						  <a href="./board.php?bo_table=<?=$bo_table?>&k_num=<?=$field['wr_id']?>&type=2" class="btn btn-<?=$bc?> btn-sm<?= $disabled ?>"><?= $bt ?></a>
					  </li>
					  <li class="list-group-item border-0 py-1 text-danger"><strong>신청기간: <?= $field['wr_9'] ?></strong></li>
					  <li class="list-group-item border-0 py-1"><strong>체험일정:</strong> <?= $field['wr_2'] ?></li>
					  <li class="list-group-item border-0 py-1"><strong>체험시간:</strong> <?= $field['wr_3'] ?></li>
					  <li class="list-group-item border-0 py-1"><strong>참가인원:</strong> 최소 <?= $wr_mans[0] ?>명에서 최대 <?= $wr_mans[1] ?>명</li>
					  <li class="list-group-item border-0 py-1"><strong>체험비용:</strong> 성인 :  <?= number_format($wr_money[0]) ?>원, 어린이 : <?= number_format($wr_money[1]) ?>원</li>
					  <li class="list-group-item border-0 py-1"><strong>체험내용:</strong> <?= $field['wr_6'] ?></li>
				</ul>
			</div>
	  </div>
	<?php  }

		if ($x == 0) {
			echo '<div class="py-5">진행중인 프로그램이 없습니다.</div>';
		}
	?>

	<div class="d-flex justify-content-end mb-2 pe-3"><?= $write_pages ?></div>

</div>

<script>
	function delete_form(id) {
		var site_url ="<?= $board_skin_url ?>";

		if(confirm("신청을 취소 하시겠습니까?")) {
			$.ajax({
				url : site_url+"/ajax_delete.php",
				type: "POST",
				data: {
					id: id,
					bo_table: "<?=$bo_table?>",
				},
				dataType: 'json',
				async: false,
				success: function(data) {
					alert(data.msg);
					location.reload();
				},
				error: function (jqXHR, textStatus, errorThrown) {
					alert("삭제 도중 에러가 발생했습니다.");
				}
			});
		}
	}	
</script>