<?php
include_once('./_common.php');
include_once(G5_PATH.'/head.php');
$g5['title'] = '회원 목록';

if ($member[mb_level] < 8){ alert("접근 권한이 없습니다.", "$g5[path]"); } // 레벨 8미만은 접근권한 제한

$sql_common = " from {$g5['member_table']} ";

$sql_search = " where (1) ";
$sql_search .= " and mb_id != 'admin' and mb_id != 'aaa' and mb_id != 'bbb' and mb_id != 'ccc' "; // 특정아이디 admin, aaa, bbb, ccc 제외해서 출력

if ($stx) {
    $sql_search .= " and ( ";
    switch ($sfl) {
        case 'mb_point' :
            $sql_search .= " ({$sfl} >= '{$stx}') ";
            break;
        case 'mb_level' :
            $sql_search .= " ({$sfl} = '{$stx}') ";
            break;
        case 'mb_tel' :
        case 'mb_hp' :
            $sql_search .= " ({$sfl} like '%{$stx}') ";
            break;
        default :
            $sql_search .= " ({$sfl} like '{$stx}%') ";
            break;
    }
    $sql_search .= " ) ";
}

if ($is_admin != 'super')
    $sql_search .= " and mb_level <= '{$member['mb_level']}' ";

if (!$sst) {
    $sst = "mb_datetime"; //회원 목록 정렬기준. 현재는 최근 가입한 회원이 처음으로
    $sod = "desc";
}

$sql_order = " order by {$sst} {$sod} ";

$sql = " select count(*) as cnt {$sql_common} {$sql_search} {$sql_order} ";
$row = sql_fetch($sql);
$total_count = $row['cnt'];

$rows = 20; // 페이지당 목록수
$total_page  = ceil($total_count / $rows);  // 전체 페이지 계산
if ($page < 1) $page = 1; // 페이지가 없으면 첫 페이지 (1 페이지)
$from_record = ($page - 1) * $rows; // 시작 열을 구함

$listall = '<a href="'.$_SERVER['SCRIPT_NAME'].'" class="ov_listall">전체목록</a>';

$sql = " select * {$sql_common} {$sql_search} {$sql_order} limit {$from_record}, {$rows} ";
$result = sql_query($sql);

$colspan = '9';
?>

<style>
#total .member_total {margin:10pt 0;padding:15px 10px;margin:10px 0;border:1px solid #ccc;background:#fff;font-size:13pt;text-align: center;}
.btn_submit {width:60px;height:38px;border:0;background:#3a8afd;color:#fff;cursor:pointer;border-radius:3px}
.btn_submit:hover {background:#2375eb}
</style>

<div id="total">
    <div class="member_total">총회원수 : <strong><?php echo number_format($total_count) ?></strong>명 <? $today = date("Y-m-d"); ?>【 <? echo $today; ?> 현재 】
	</div>
</div>

<form id="fsearch" name="fsearch" class="local_sch01 local_sch" method="get">

<label for="sfl" class="sound_only">검색대상</label>
<select name="sfl" id="sfl" style="width:100px;height:38px;">
    <option value="mb_nick"<?php echo get_selected($_GET['sfl'], "mb_nick"); ?>>닉네임</option>
    <option value="mb_name"<?php echo get_selected($_GET['sfl'], "mb_name"); ?>>이름</option>
	<option value="mb_id"<?php echo get_selected($_GET['sfl'], "mb_id"); ?>>회원아이디</option>
    <option value="mb_email"<?php echo get_selected($_GET['sfl'], "mb_email"); ?>>E-MAIL</option>
    <option value="mb_tel"<?php echo get_selected($_GET['sfl'], "mb_tel"); ?>>전화번호</option>
    <option value="mb_hp"<?php echo get_selected($_GET['sfl'], "mb_hp"); ?>>휴대폰번호</option>
    <option value="mb_point"<?php echo get_selected($_GET['sfl'], "mb_point"); ?>>포인트</option>
    <option value="mb_datetime"<?php echo get_selected($_GET['sfl'], "mb_datetime"); ?>>가입일시</option>
    <option value="mb_ip"<?php echo get_selected($_GET['sfl'], "mb_ip"); ?>>IP</option>
    <option value="mb_recommend"<?php echo get_selected($_GET['sfl'], "mb_recommend"); ?>>추천인</option>
</select>
<label for="stx" class="sound_only">검색어<strong class="sound_only"> 필수</strong></label>
<input type="text" name="stx" value="<?php echo $stx ?>" id="stx" required class="required frm_input">
<input type="submit" class="btn_submit" value="검색">

</form>
<br />

<form name="fmemberlist" id="fmemberlist" action="./member_list_update.php" onsubmit="return fmemberlist_submit(this);" method="post">
<input type="hidden" name="sst" value="<?php echo $sst ?>">
<input type="hidden" name="sod" value="<?php echo $sod ?>">
<input type="hidden" name="sfl" value="<?php echo $sfl ?>">
<input type="hidden" name="stx" value="<?php echo $stx ?>">
<input type="hidden" name="page" value="<?php echo $page ?>">
<input type="hidden" name="token" value="">

<div class="tbl_head01 tbl_wrap">
    <table>
    <caption><?php echo $g5['title']; ?> 목록</caption>
    <thead>
    <tr>
        <th width="150"><?php echo subject_sort_link('mb_name') ?>이름</a></th>
        <th width="200"><?php echo subject_sort_link('mb_nick') ?>닉네임</a></th>
		<th width="150"><?php echo subject_sort_link('mb_id') ?>아이디</a></th>
        <th width="150">휴대폰</th>
        <th width="150">전화번호</th>
        <th width="150"><?php echo subject_sort_link('mb_datetime', '', 'desc') ?>가입일</a></th>
        <th width="150"><?php echo subject_sort_link('mb_today_login', '', 'desc') ?>최종접속</a></th>
        <th width="200"><?php echo subject_sort_link('mb_point', '', 'desc') ?> 포인트</a></th>
	</tr>
    </thead>
    <tbody>
    <?php
    for ($i=0; $row=sql_fetch_array($result); $i++) {
        $mb_nick = get_sideview($row['mb_id'], get_text($row['mb_nick']), $row['mb_email'], $row['mb_homepage']);
        $mb_id = $row['mb_id'];
        $address = $row['mb_zip1'] ? print_address($row['mb_addr1'], $row['mb_addr2'], $row['mb_addr3'], $row['mb_addr_jibeon']) : '';
       // $bg = 'bg'.($i%2);
		$bgcolor = ($i%2) ? "#FFFDF7" : "#FFFFFF";

		if ($row[mb_id] == $member[mb_id])
			$bgcolor = "#FFCC00";
    ?>

    <tr bgcolor='<?=$bgcolor?>' onmouseout=this.bgColor='<?=$bgcolor?>' onmouseover=this.bgColor='#FFF3E7'>
        <td width="150" align="center"><?php echo get_text($row['mb_name']); ?></td>
        <td width="200" align="center"><div><?php echo $mb_nick ?></div></td>
        <td width="150" align="center">
            <?php echo $mb_id ?>
            <?php
            //소셜계정이 있다면
            if(function_exists('social_login_link_account')){
                if( $my_social_accounts = social_login_link_account($row['mb_id'], false, 'get_data') ){
                    
                    echo '<div class="member_social_provider sns-wrap-over sns-wrap-32">';
                    foreach( (array) $my_social_accounts as $account){     //반복문
                        if( empty($account) || empty($account['provider']) ) continue;
                        
                        $provider = strtolower($account['provider']);
                        $provider_name = social_get_provider_service_name($provider);
                        
                        echo '<span class="sns-icon sns-'.$provider.'" title="'.$provider_name.'">';
                        echo '<span class="ico"></span>';
                        echo '<span class="txt">'.$provider_name.'</span>';
                        echo '</span>';
                    }
                    echo '</div>';
                }
            }
            ?>
        </td>
		<td width="150" align="center"><?php echo get_text($row['mb_hp']); ?></td>
        <td width="150" align="center"><?php echo get_text($row['mb_tel']); ?></td>
        <td width="150" align="center"><?php echo substr($row['mb_datetime'],2,8); ?></td>
		<td width="150" align="center"><?php echo substr($row['mb_today_login'],2,8); ?></td>
        <td width="200" align="center"><a href="point_list.php?sfl=mb_id&amp;stx=<?php echo $row['mb_id'] ?>"><?php echo number_format($row['mb_point']) ?></a></td>
	</tr>

    <?php
    }
    if ($i == 0)
        echo "<tr><td colspan=\"".$colspan."\" class=\"empty_table\">자료가 없습니다.</td></tr>";
    ?>
    </tbody>
    </table>
</div>

</form>

<?php echo get_paging(G5_IS_MOBILE ? $config['cf_mobile_pages'] : $config['cf_write_pages'], $page, $total_page, '?'.$qstr.'&amp;page='); ?>

<?php
include_once(G5_PATH.'/tail.php');
?>