<?php 
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

$file_path = G5_PATH."/plugin/PHPImageWorkshop"; 

require_once($file_path.'/GifFrameExtractor/GifFrameExtractor.php');
require_once($file_path.'/GifCreator/GifCreator.php');

require_once($file_path.'/Core/ImageWorkshopLayer.php');
require_once($file_path.'/Core/ImageWorkshopLib.php');
require_once($file_path.'/Exception/ImageWorkshopBaseException.php');
require_once($file_path.'/Exception/ImageWorkshopException.php');

require_once($file_path.'/ImageWorkshop.php');

use PHPImageWorkshop;

function thumbnail_gif($gifPath, $target_file, $width , $origin_width=0 ){
	$frame_size=2;
	if (GifFrameExtractor::isAnimatedGif($gifPath)) { // check this is an animated GIF
		// Extractions of the GIF frames and their durations
		$gfe = new GifFrameExtractor();
		$frames = $gfe->extract($gifPath);
		 
		// Initialization of the watermark layer
		//$watermarkLayer = ImageWorkshop::initFromPath('/folder/images/watermark.jpg');
		 
		$retouchedFrames = array();
	 
		// For each frame, we add a watermark and we resize it
		$i=0;
		foreach ($frames as $frame) {
			// Initialization of the frame as a layer
			if(! ($i%$frame_size) ){
				if($width == $origin_width){
					$retouchedFrames[] = $frame['image'];
				}
				else{
					$frameLayer = PHPImageWorkshop\ImageWorkshop::initFromResourceVar($frame['image']);
					$frameLayer->resizeInPixel($width, null, true); // Resizing
					$retouchedFrames[] = $frameLayer->getResult();
				}
			}
			$i++;
		}
		 
		// Then we re-generate the GIF
		$gc = new GifCreator();
		$gc->create($retouchedFrames, $gfe->getFrameDurations(), 0);
		 
		// And now save it !
		file_put_contents($target_file, $gc->getGif());

		return true;
	}
	return false;
}
?>