package com.dahamit.dahammall;

import android.Manifest;
import android.content.Intent;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Handler;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.dahamit.dahammall.util.Util;
import com.gun0912.tedpermission.PermissionListener;
import com.gun0912.tedpermission.TedPermission;

import java.util.ArrayList;

public class IntroActivity extends AppCompatActivity {

    public static Typeface mTypeface_hannna;
    public static Typeface mTypeface_jua;
    public static Typeface mTypeface_gothic ;

    TextView tvTitle, tvOwner;
    RelativeLayout introLayout;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        checkPermission();
        setContentView(R.layout.activity_intro);
        introLayout = (RelativeLayout)this.findViewById(R.id.activity_main);

    }

    public void checkPermission(){
        new TedPermission(this)
                .setPermissionListener(permissionlistener)
                .setDeniedMessage("If you reject permission,you can not use this service\n\nPlease turn on permissions at [Setting] > [Permission]")
                .setPermissions(Manifest.permission.INTERNET, Manifest.permission.ACCESS_NETWORK_STATE,  Manifest.permission.CHANGE_NETWORK_STATE)
                .setGotoSettingButton(true)
                .setGotoSettingButtonText("권한설정하기")
                .check();
    }
    PermissionListener permissionlistener = new PermissionListener() {
        @Override
        public void onPermissionGranted() {
         //   Toast.makeText(IntroActivity.this, "권한 허가", Toast.LENGTH_SHORT).show();
            // startMainActivity();
            // mHandler.sendEmptyMessage(0);
            goMain();


        }

        @Override
        public void onPermissionDenied(ArrayList<String> deniedPermissions) {
           // Toast.makeText(IntroActivity.this, "권한 거부\n" + deniedPermissions.toString(), Toast.LENGTH_SHORT).show();

        }
    };



    public void goMain() {

        if(Util.isNetWork(this)){
            introLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent newIntent = new Intent(IntroActivity.this, MainActivity.class);
                    startActivity(newIntent);
                }
            });
            Log.d("intro","isNetWork true");

            startMainActivity();

        }else{
            Log.d("intro","isNetWork false");
            Intent intent = new Intent(IntroActivity.this, NoWifiActivity.class);

            startActivity(intent);
            finish();

        }




    }
    public void startMainActivity() {
        Handler handler = new Handler();
        handler.postDelayed(new Runnable() {
            public void run() {
                Intent intent = new Intent(IntroActivity.this, MainActivity.class);
                //intent.putExtra("menuid", FragmentId.MAIN_FRAG);
                startActivity(intent);
                finish();
            }
        }, 2000);
    }
}
