package com.dahamit.dahammall.util;

/**
 * Created by macbookpro on 2018. 10. 7..
 */

public class UtilClass {
    public static String nvl(String str) {
        return str==null ? "" : str;
    }

    /**
     * baseStr 이 compareStr 보다 큰 문자열인지 여부. (baseStr > compareStr)
     * 날짜 문자열 비교 등. "20180301", "20180302" ==> false 반환.
     * @param baseStr
     * @param compareStr
     * @return
     */
    public static boolean isGreat(String baseStr, String compareStr) {
        baseStr = nvl(baseStr);
        compareStr = nvl(compareStr);

        int compare = baseStr.compareTo(compareStr);

        if( compare > 0 ){
            return true;
        } else {
            return false;
        }
    }

    /**
     * baseStr 이 compareStr 보다 크거나 같은 문자열인지 여부. (baseStr >= compareStr)
     * 날짜 문자열 비교 등. "20180301", "20180302" ==> false 반환.
     * @param baseStr
     * @param compareStr
     * @return
     */
    public static boolean isGreatOrEqual(String baseStr, String compareStr) {
        baseStr = nvl(baseStr);
        compareStr = nvl(compareStr);

        if( isGreat(baseStr, compareStr) || baseStr.equals(compareStr) ){
            return true;
        } else {
            return false;
        }
    }

    /**
     * baseStr 이 compareStr 보다 작은 문자열인지 여부. (baseStr < compareStr)
     * 날짜 문자열 비교 등. "20180301", "20180302" ==> true 반환.
     * @param baseStr
     * @param compareStr
     * @return
     */
    public static boolean isSmall(String baseStr, String compareStr) {
        return !isGreat(baseStr, compareStr) && !nvl(baseStr).equals(compareStr);
    }

    /**
     * baseStr 이 compareStr 보다 크거나 같은 문자열인지 여부. (baseStr <= compareStr)
     * 날짜 문자열 비교 등. "20180301", "20180302" ==> false 반환.
     * @param baseStr
     * @param compareStr
     * @return
     */
    public static boolean isSmallOrEqual(String baseStr, String compareStr) {
        baseStr = nvl(baseStr);
        compareStr = nvl(compareStr);

        if( isSmall(baseStr, compareStr) || baseStr.equals(compareStr) ){
            return true;
        } else {
            return false;
        }
    }

}
