<?php
$sub_menu = '300100';
include_once('./_common.php');

auth_check($auth[$sub_menu], "w");

$g5['title'] = '게시판 글 대량 등록';
include_once(G5_PATH.'/head.sub.php');

?>

<style>
    .new_win .post_reset_div {
        display: none;
    }

    .new_win .post_btn button {
        height:30px;
        border:0;
        border-radius:5px;
        padding:0 10px;
        font-weight:bold;
        font-size:1.09em;
        vertical-align:middle;
    }

    .new_win .post_btn button.on {
        background-color: #BDBDBD;
    }
</style>

<div class="new_win">
    <div class="post_btn">
        <button class="btn_add on">등록</button>
        <button class="btn_reset">초기화</button>
    </div>

    <h1><?php echo $g5['title']; ?></h1>

    <div class="post_add_div">
        <div class="local_desc01 local_desc">
            <p>
                게시판 테스트를 위한 게시글을 대량 등록 할수 있습니다.<br>
            </p>
        </div>

        <form name="boardwrite" method="post" action="./board_post_add_update.php" onsubmit="return bwrite_submit(this);" enctype="MULTIPART/FORM-DATA" autocomplete="off">
            <div id="excelfile_upload">

                <div>
                    <label for="board_list">게시판 선택 : </label>
                    <select name="board_list" id="board_list">
                        <option value="">선택</option>
                        <?php
                            $sql = "SELECT bo_table, bo_subject, bo_category_list FROM {$g5['board_table']} ORDER BY bo_table ";
                            $result = sql_query($sql);

                            for($i=0; $row=sql_fetch_array($result); $i++) {
                        ?>
                        <option value="<?php echo $row['bo_table']; ?>" data-catelist="<?php echo $row['bo_category_list']; ?>"><?php echo $row['bo_subject']; ?></option>
                        <?php }?>
                    </select>
                </div>


                <div class="board_category" style="display: none; ">
                    <label for="excelfile">분류 선택 : </label>
                    <select name="category_list" id="category_list">
                        <option value="">선택</option>
                    </select>
                </div>

                <div>
                    <label for="excelfile">추가할 게시글 수 : </label>
                    <input type="text" name="post_qty" class="frm_input">
                </div>
            </div>

            <div class="win_btn btn_confirm">
                <input type="submit" value="게시글 등록" class="btn_submit btn">
                <button type="button" onclick="window.close();" class="btn_close btn">닫기</button>
            </div>
        </form>
    </div>

    <div class="post_reset_div">
        <div class="local_desc01 local_desc">
            <p>
                게시판을 초기화 합니다.<br>
                첨부 파일이 모두 삭제 됩니다.<br>
            </p>
        </div>

        <form name="boarddelete" method="post" action="./board_post_reset.php" onsubmit="return bdelete_submit(this);" enctype="MULTIPART/FORM-DATA" autocomplete="off">
            <div id="excelfile_upload">
                <div>
                    <label for="board_list">게시판 선택 : </label>
                    <select name="board_list" id="board_list">
                        <option value="">선택</option>
                        <?php
                            $sql = "SELECT bo_table, bo_subject, bo_category_list FROM {$g5['board_table']} ORDER BY bo_table ";
                            $result = sql_query($sql);

                            for($i=0; $row=sql_fetch_array($result); $i++) {
                        ?>
                        <option value="<?php echo $row['bo_table']; ?>"><?php echo $row['bo_subject']; ?></option>
                        <?php }?>
                    </select>
                </div>
            </div>

            <div class="win_btn btn_confirm">
                <input type="submit" value="게시판 초기화" class="btn_submit btn">
                <button type="button" onclick="window.close();" class="btn_close btn">닫기</button>
            </div>
        </form>
    </div>

</div>

<script>
    function bwrite_submit(f) {
        // 숫자 정규식
        var regexp = /^[0-9]*$/;

        if(f.board_list.value == '') {
            alert("게시판을 선택해주세요.");
            f.board_list.focus();
            return false;
        }

        if(f.post_qty.value == '') {
            alert("추가할 숫자를 입력해주세요.");
            f.post_qty.focus();
            return false;
        }

        if(!regexp.test(f.post_qty.value)) {
            alert("숫자만 입력해주세요.");
            f.post_qty.focus();
            return false;
        }

        return true;
    }

    function bdelete_submit(f) {
        if(f.board_list.value == '') {
            alert("게시판을 선택해주세요.");
            f.board_list.focus();
            return false;
        }

        return true;
    }

    $('#board_list').change(function() {
        var board_list = $(this).val();

        // 변경시 초기화
        $('select#category_list option').remove();

        if(board_list == '') {
            $('.board_category').css('display', 'none');
        }else{
            var catelist = $(this).find(':selected').attr('data-catelist');
            var category = catelist.split('|');
            var select = '';

            if(category.length == '1') {
                $('.board_category').css('display', 'none');
            }else{
                $('.board_category').css('display', 'block');
                for(var i in category) {
                    select += '<option value="'+category[i]+'">'+category[i]+'</option>';
                }

                $('#category_list').append(select);
            }
        }
    });

    $('.post_btn button').on('click', function(){
        $(this).siblings().removeClass('on');
        $(this).addClass('on');
    });

    $('.new_win .post_btn .btn_add').on('click', function() {
        $('.new_win .post_add_div').css('display', 'block');
        $('.new_win .post_reset_div').css('display', 'none');
    });

    $('.new_win .post_btn .btn_reset').on('click', function() {
        $('.new_win .post_reset_div').css('display', 'block');
        $('.new_win .post_add_div').css('display', 'none');
    });
</script>

<?php
include_once(G5_PATH.'/tail.sub.php');
?>