<?php
require_once __DIR__ . '/vendor/autoload.php';
use Firebase\JWT\JWT;
use Firebase\JWT\Key;

include_once 'config.php';

function generateAppleClientSecret() {
    $privateKey = file_get_contents(APPLE_PRIVATE_KEY_PATH);
    $token = [
        'iss' => APPLE_TEAM_ID,
        'iat' => time(),
        'exp' => time() + 86400 * 180, // 6개월 유효
        'aud' => 'https://appleid.apple.com',
        'sub' => APPLE_CLIENT_ID,
    ];
    return JWT::encode($token, $privateKey, 'ES256', APPLE_KEY_ID);
}
?>