<?php
include_once 'config.php';
include_once 'apple_jwt.php';
include_once '../../../common.php'; // Gnuboard 공통 파일

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['code'])) {
    $code = $_POST['code'];

    $client_secret = generateAppleClientSecret();

    $post_fields = http_build_query([
        'grant_type' => 'authorization_code',
        'code' => $code,
        'redirect_uri' => APPLE_REDIRECT_URI,
        'client_id' => APPLE_CLIENT_ID,
        'client_secret' => $client_secret
    ]);

    $ch = curl_init('https://appleid.apple.com/auth/token');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/x-www-form-urlencoded']);

    $response = curl_exec($ch);
    $result = json_decode($response, true);
    curl_close($ch);

    if (isset($result['id_token'])) {
        $jwt_parts = explode('.', $result['id_token']);
        $payload = json_decode(base64_decode($jwt_parts[1]), true);

        $email = $payload['email'];
        $sub = $payload['sub']; // 고유 식별자

        $mb_id = 'apple_' . $sub;
        $mb_email = $email;

        // Gnuboard 회원 존재 확인
        $mb = sql_fetch("SELECT * FROM {$g5['member_table']} WHERE mb_id = '{$mb_id}'");

        if (!$mb['mb_id']) {
            // 자동 회원가입
            $sql = "INSERT INTO {$g5['member_table']} SET 
                    mb_id = '{$mb_id}', 
                    mb_email = '{$mb_email}', 
                    mb_name = 'AppleUser', 
                    mb_password = '', 
                    mb_level = 2,
                    mb_datetime = NOW()";
            sql_query($sql);
        }

        // 로그인 처리
        set_session('ss_mb_id', $mb_id);
        goto_url(G5_URL);
    } else {
        echo "Apple login failed.";
    }
} else {
    echo "Invalid request.";
}
?>