<?php
$sql = " SELECT table_name FROM information_schema.columns WHERE column_name = 'wr_content' AND table_schema = DATABASE() ";
$result = sql_query($sql);

$tables = [];
while ($row = sql_fetch_array($result)) {
    $tables[] = $row['table_name'];
}

if (empty($tables)) {
    echo "No tables found with 'wr_content' column.";
    exit;
}

// 2. 각 테이블의 wr_content 열에서 URL을 추출하는 동적 SQL 쿼리를 생성합니다.
$sqlPartsData = [];
$sqlPartsNoData = [];

foreach ($tables as $table) {
    // /data/가 포함된 URL 추출
    $sqlPartsData[] = "
        SELECT 
            '{$table}' AS table_name,
            CASE 
                WHEN wr_content REGEXP 'https?://[^ ]+/data/[^ \"]+' THEN SUBSTRING_INDEX(SUBSTRING_INDEX(wr_content, 'https://', -1), ' ', 1)
                WHEN wr_content REGEXP 'http?://[^ ]+/data/[^ \"]+' THEN SUBSTRING_INDEX(SUBSTRING_INDEX(wr_content, 'http://', -1), ' ', 1)
            END AS url,
            CASE 
                WHEN wr_content REGEXP 'https?://[^ ]+/data/[^ \"]+' THEN 'https://'
                WHEN wr_content REGEXP 'http?://[^ ]+/data/[^ \"]+' THEN 'http://'
            END AS protocol
        FROM {$table} 
        WHERE wr_content REGEXP 'https?://[^ ]+/data/[^ \"]+'
    ";

    // /data/가 포함되지 않은 URL 추출
    $sqlPartsNoData[] = "
        SELECT 
            '{$table}' AS table_name,
            CASE 
                WHEN wr_content REGEXP 'https?://[^ ]+[^/data/][^ \"]+' THEN SUBSTRING_INDEX(SUBSTRING_INDEX(wr_content, 'https://', -1), ' ', 1)
                WHEN wr_content REGEXP 'http?://[^ ]+[^/data/][^ \"]+' THEN SUBSTRING_INDEX(SUBSTRING_INDEX(wr_content, 'http://', -1), ' ', 1)
            END AS url,
            CASE 
                WHEN wr_content REGEXP 'https?://[^ ]+[^/data/][^ \"]+' THEN 'https://'
                WHEN wr_content REGEXP 'http?://[^ ]+[^/data/][^ \"]+' THEN 'http://'
            END AS protocol
        FROM {$table} 
        WHERE wr_content REGEXP 'https?://[^ ]+[^/data/][^ \"]+'
    ";
}

$sqlData = implode(' UNION ALL ', $sqlPartsData);
$sqlNoData = implode(' UNION ALL ', $sqlPartsNoData);

// 3. 추출한 URL을 결과로 표시합니다.
$resultsData = sql_query($sqlData);
$resultsNoData = sql_query($sqlNoData);

$G5_URL = G5_URL;  // G5_URL 문자열을 지정합니다.

echo "<h2 style='color:#fa0'>URLs containing /data/</h2>";
while ($row = sql_fetch_array($resultsData)) {
    $full_url = trim($row['protocol'] . $row['url'], '"');
    if (strpos($full_url, $G5_URL) === false) {  // G5_URL이 포함되지 않은 경우만 출력
        echo "<span style='color:#fa0'>" . htmlspecialchars($row['table_name']) . "</span> ";
        echo "<span style='color:#fff'>" . htmlspecialchars($full_url) . "</span><br><br>";
    } else {
        echo "<span style='color:#fa0'>" . htmlspecialchars($row['table_name']) . "</span> ";
        echo "<span style='color:#aaa'>" . htmlspecialchars($full_url) . "</span><br><br>";
    }
}

echo "<h2 style='color:#f00'>URLs not containing /data/</h2>";
while ($row = sql_fetch_array($resultsNoData)) {
    $full_url = trim($row['protocol'] . $row['url'], '"');
    // /data/가 포함된 URL은 제외
    if (strpos($full_url, '/data/') === false) {
        // 불필요한 문자열 제거 (예: ">adult</a>, ), ")
        $full_url = preg_replace('/[^a-zA-Z0-9:\/\.\-_?#=&]/', '', $full_url);
        if (strpos($full_url, $G5_URL) === false) {  // G5_URL이 포함되지 않은 경우만 출력
            echo "<span style='color:#fa0'>" . htmlspecialchars($row['table_name']) . "</span> ";
            echo "<span style='color:#fff'>" . htmlspecialchars($full_url) . "</span><br><br>";
        } else {
            echo "<span style='color:#fa0'>" . htmlspecialchars($row['table_name']) . "</span> ";
            echo "<span style='color:#aaa'>" . htmlspecialchars($full_url) . "</span><br><br>";
        }
    }
}

include_once(G5_ADMIN_PATH . '/admin.tail.php');
