<?php
$sql = " SELECT table_name FROM information_schema.columns WHERE column_name = 'wr_content' AND table_schema = DATABASE() ";
$result = sql_query($sql);

$tables = [];
while ($row = sql_fetch_array($result)) {
    $tables[] = $row['table_name'];
}

if (empty($tables)) {
    echo "No tables found with 'wr_content' column.";
    exit;
}

// 2. 각 테이블에서 URL 추출 쿼리 생성
$sqlPartsData = [];
$sqlPartsNoData = [];

foreach ($tables as $table) {
    $sqlPartsData[] = "
        SELECT 
            '$table' AS table_name,
            CASE 
                WHEN wr_content REGEXP 'https://[^ ]+/data/' THEN SUBSTRING_INDEX(SUBSTRING_INDEX(wr_content, 'https://', -1), ' ', 1)
                WHEN wr_content REGEXP 'http://[^ ]+/data/' THEN SUBSTRING_INDEX(SUBSTRING_INDEX(wr_content, 'http://', -1), ' ', 1)
            END AS url,
            CASE 
                WHEN wr_content REGEXP 'https://[^ ]+/data/' THEN 'https://'
                WHEN wr_content REGEXP 'http://[^ ]+/data/' THEN 'http://'
            END AS protocol
        FROM `$table`
        WHERE wr_content REGEXP 'https?://[a-zA-Z0-9./?=_-]+/data/'
    ";

    $sqlPartsNoData[] = "
        SELECT 
            '$table' AS table_name,
            CASE 
                WHEN wr_content REGEXP 'https://' THEN SUBSTRING_INDEX(SUBSTRING_INDEX(wr_content, 'https://', -1), ' ', 1)
                WHEN wr_content REGEXP 'http://' THEN SUBSTRING_INDEX(SUBSTRING_INDEX(wr_content, 'http://', -1), ' ', 1)
            END AS url,
            CASE 
                WHEN wr_content REGEXP 'https://' THEN 'https://'
                WHEN wr_content REGEXP 'http://' THEN 'http://'
            END AS protocol
        FROM `$table`
        WHERE wr_content REGEXP 'https?://[a-zA-Z0-9./?=_-]+' AND wr_content NOT REGEXP '/data/'
    ";
}

$sqlData = implode(' UNION ALL ', $sqlPartsData);
$sqlNoData = implode(' UNION ALL ', $sqlPartsNoData);

// 3. 추출한 URL을 결과로 표시
$resultData = sql_query($sqlData);
$resultsData = [];
while ($row = sql_fetch_array($resultData)) {
    $resultsData[] = $row;
}

$resultNoData = sql_query($sqlNoData);
$resultsNoData = [];
while ($row = sql_fetch_array($resultNoData)) {
    $resultsNoData[] = $row;
}

$G5_URL = G5_URL;
if ($resultsData) {
    foreach ($resultsData as $row) {
        $full_url = $row['protocol'] . $row['url'];
        if (strpos($full_url, $G5_URL) === false) {
           $string = htmlspecialchars($full_url);
           $pattern = '/(https?:\/\/.*?)\/data/';
           preg_match($pattern, $string, $matches);

           if (isset($matches[1])) {
               $url = $matches[1];
               echo $url;
               break;
           }
        }
    }
}