<?php 
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가


// 관리자 메뉴 hook
if (!function_exists('admim_menu_mb_excel_export')) {
	add_replace('admin_menu', 'admim_menu_mb_excel_export', G5_HOOK_DEFAULT_PRIORITY, 1);
	function admim_menu_mb_excel_export($menu)
	{
		$menu['menu200'][] = array('200110', '회원목록저장', G5_ADMIN_URL.'/view.php?call=mb_excel_export', 'mb_excel_export');
		return $menu;
	}
}

// 회원 목록 엑셀 저장
if (!function_exists('array_to_excel')) {
	// 엑셀 다운로드 함수
	function array_to_excel($data, $filename){
	    header('Content-Type: application/vnd.ms-excel; charset=utf-8');
	    header('Content-Disposition: attachment; filename="' . $filename . '.csv"'); // 확장자를 .csv로 변경
	    header('Cache-Control: max-age=0');
	    $out = fopen('php://output', 'w');
	    fputs($out, "\xEF\xBB\xBF"); // UTF-8 with BOM
	    fputcsv($out, array_keys($data[0]), ","); // 콤마 구분자 사용
	    foreach ($data as $row) {
	        fputcsv($out, $row, ","); // 콤마 구분자 사용
	    }
	    fclose($out);
	}
}
if (!function_exists('mb_excel_export_func')) {
	add_event('admin_get_page_mb_excel_export', 'mb_excel_export_func', G5_HOOK_DEFAULT_PRIORITY, 2);
	function mb_excel_export_func($arr_query, $token)
	{
		global $g5;
				
		$sql_common = " from {$g5['member_table']} ";
		
		$sql_search = " where (1) ";
		if ($stx) {
		    $sql_search .= " and ( ";
		    switch ($sfl) {
		        case 'mb_point' :
		            $sql_search .= " ({$sfl} >= '{$stx}') ";
		            break;
		        case 'mb_level' :
		            $sql_search .= " ({$sfl} = '{$stx}') ";
		            break;
		        case 'mb_tel' :
		        case 'mb_hp' :
		            $sql_search .= " ({$sfl} like '%{$stx}') ";
		            break;
		        default :
		            $sql_search .= " ({$sfl} like '{$stx}%') ";
		            break;
		    }
		    $sql_search .= " ) ";
		}
		
		if ($is_admin != 'super')
		    $sql_search .= " and mb_level <= '{$member['mb_level']}' ";
		
		if (!$sst) {
		    $sst = "mb_datetime";
		    $sod = "desc";
		}
		
		$sql_order = " order by {$sst} {$sod} ";
		
		$sql = " select * {$sql_common} {$sql_search} {$sql_order} ";
		$result = sql_query($sql);
		
		$data = array(); // Initialize the data array
		$i = 0; // $i 변수를 여기서 초기화
		
		while ($row = sql_fetch_array($result)) {
		    $i++; // 각 회원 데이터마다 번호 증가
		    // 데이터 가공
		    $mb_gender = '';
		    if ($row['mb_gender'] == 'M') {
		        $mb_gender = '남성';
		    } else if ($row['mb_gender'] == 'F') {
		        $mb_gender = '여성';
		    }
		
		    $data[] = array(
		        '번호' => $i,
		        '아이디' => $row['mb_id'],
		        '이름' => $row['mb_name'],
		        '닉네임' => $row['mb_nick'],
		        'E-MAIL' => $row['mb_email'],
		        '전화번호' => $row['mb_tel'],
		        '휴대폰번호' => hyphen_hp_number($row['mb_hp']),
		        '성별' => $mb_gender,
		        '생년월일' => $row['mb_birth'],
		        '가입일' => $row['mb_datetime'],
		        '최종접속일' => $row['mb_today_login'],
		        '권한' => $row['mb_level']
		    );
		}
		
		// HTML 테이블 출력 대신 엑셀 파일로만 출력하도록 수정
		array_to_excel($data, '회원리스트');		
	}
}


