<?php
// 데이터베이스 연결 설정
$dbHost = 'localhost'; // 데이터베이스 호스트
$dbUser = ''; // 데이터베이스 사용자
$dbPass = ''; // 데이터베이스 비밀번호
$dbName = ''; // 그누보드 데이터베이스 이름

// 데이터베이스 연결
$conn = new mysqli($dbHost, $dbUser, $dbPass, $dbName);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$members = []; // 회원 정보를 저장할 배열

// 그누보드 회원 정보 가져오기
$sql = "SELECT mb_name, mb_hp FROM g5_member WHERE mb_hp != ''";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $members[] = $row;
    }
} else {
    echo "No members found with phone numbers.";
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Traccar SMS Gateway 설정
    $traccarUrl = 'http://'; // 실제 Traccar SMS Gateway URL로 교체
    $apiToken = ''; // 실제 API 키 (토큰)로 교체

    // 폼으로부터 데이터 받기
    $message = $_POST['message'];
    $selectedMembers = $_POST['members'];

    // 선택한 회원 각각에게 SMS 발송
    foreach ($selectedMembers as $phoneNumber) {
        // SMS 데이터 구성
        $data = json_encode(array(
            "to" => $phoneNumber,
            "message" => $message
        ));

        // cURL을 사용하여 HTTP POST 요청
        $ch = curl_init($traccarUrl);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Authorization: ' . $apiToken
        ));
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            // 오류 발생 시 출력
            echo 'Error:' . curl_error($ch) . '<br>';
        } else {
            // 결과 출력
            echo '문자전송완료: ' . $phoneNumber . '<br>';
        }

        curl_close($ch);

        // 시간차를 두고 SMS 발송 (예: 1초 지연)
        sleep(1);
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Send SMS</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 80%;
            margin: auto;
            overflow: hidden;
        }
        #main {
            background: #fff;
            padding: 20px;
            margin-top: 30px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h1 {
            text-align: center;
            color: #333;
        }
        form {
            display: flex;
            flex-direction: column;
        }
        label {
            margin-top: 10px;
            font-weight: bold;
        }
        textarea {
            margin-top: 5px;
            padding: 10px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 5px;
            height: 100px;
        }
        input[type="submit"] {
            margin-top: 20px;
            padding: 10px;
            background-color: #28a745;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 18px;
        }
        input[type="submit"]:hover {
            background-color: #218838;
        }
        .member-list {
            margin-top: 20px;
        }
        .member-list ul {
            list-style-type: none;
            padding: 0;
        }
        .member-list li {
            background: #e9ecef;
            margin: 5px 0;
            padding: 10px;
            border-radius: 5px;
            display: flex;
            align-items: center;
        }
        .member-list li label {
            margin-left: 10px;
            flex-grow: 1;
        }
        #charCount {
            margin-top: 10px;
            font-size: 14px;
            color: #666;
        }
    </style>
    <script>
        function updateCharCount() {
            const message = document.getElementById('message').value;
            const charCount = new TextEncoder().encode(message).length;
            const charCountDisplay = document.getElementById('charCount');
            charCountDisplay.textContent = '현재 ' + charCount + ' 바이트 입력됨 (최대 166 바이트)';

            if (charCount > 166) {
                document.getElementById('message').value = message.substring(0, 166);
                charCountDisplay.textContent = '현재 166 바이트 입력됨 (최대 166 바이트)';
            }
        }
    </script>
</head>
<body>
    <div class="container">
        <div id="main">
            <h1>SMS 전송</h1>
            <form method="post" action="">
                <label for="message">메시지:</label>
                <textarea id="message" name="message" onkeyup="updateCharCount()" onkeydown="updateCharCount()"></textarea>
                <div id="charCount">현재 0 바이트 입력됨 (최대 166 바이트)</div><br>
                <h3>가져온 회원 정보 (이름 및 전화번호):</h3>
                <div class="member-list">
                    <ul>
                        <?php foreach ($members as $member): ?>
                            <li>
                                <input type="checkbox" name="members[]" value="<?php echo htmlspecialchars($member['mb_hp']); ?>">
                                <label><?php echo htmlspecialchars($member['mb_name'] . ' - ' . $member['mb_hp']); ?></label>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <input type="submit" value="Send SMS">
            </form>
        </div>
    </div>
</body>
</html>
