<?php
include_once('../common.php');

$bo_table = 'influencer';

$interval = 359; // 실행 간격(분)
$currentTimestamp = time(); // 현재 타임스탬프
$filename = G5_AI_DATA_PATH."/{$bo_table}.txt"; // 마지막 실행 날짜를 저장할 파일 경로

// 마지막 실행 시간을 파일에서 읽기
$lastRunTimestamp = 0;
if (file_exists($filename)) {
    $lastRunTimestamp = (int)file_get_contents($filename);
}

// 설정한 초가 지나면 실행
if ($currentTimestamp - $lastRunTimestamp >= $interval * 60) {
    // 마지막 실행 시간을 현재 시간으로 업데이트
    file_put_contents($filename, $currentTimestamp);
} else {
    echo "아직 {$interval}분이 지나지 않았습니다.";
    exit;
}

$apiKey = OPENAI_API_KEY;
$endpoint = 'https://api.openai.com/v1/images/generations';

$imageQty = 1;
$imageWidth = 1024; // 1024, 1792
$imageHeight = 1024; // 1024, 1792

include_once('./influencer.options.php');

$title = "{$hair}, {$hairColor}, {$eye}, {$action}, {$wear}, {$shoe}, {$look}, {$background}, {$situation}, {$element}, {$view}";

$prompt = "Generate a photorealistic image of a fashion influencer. She is a {$country} young woman in her mid-20s with long, {$hair} {$hairColor} hair and {$eye} eyes. She is {$action}, {$wear} {$jacket} and {$shoe}. She has a {$look} and is posing in front of a {$background}. She {$situation}. The background includes {$element}, with a {$view}. 2K";

// die($prompt);

// 이미지 생성 요청에 대한 데이터
$data = [
    'model' => 'dall-e-3',
    "prompt" => $prompt,
    'n' => $imageQty,
    'size' => "{$imageWidth}x{$imageHeight}"
];


// cURL 세션 초기화
$ch = curl_init($endpoint);

// cURL 옵션 설정
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Authorization: Bearer ' . $apiKey
]);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

// 요청 실행 및 응답 받기
$response = curl_exec($ch);

// cURL 세션 닫기
curl_close($ch);

// 응답 출력
$responseData = json_decode($response, true);
if (isset($responseData['data'][0]['url'])) {
    $imageUrl = $responseData['data'][0]['url'];
    $imageContent = file_get_contents($imageUrl);

    if ($imageContent !== false) {
        // Define the path and filename to save the image
        $microtime = microtime(true);
        $milliseconds = round($microtime * 1000);
        $ymdhis = date('ymdHis');
        $imageName = "{$ymdhis}_{$milliseconds}.png";
        $imagePath = G5_DATA_PATH."/file/{$bo_table}/{$imageName}";
        $imageUrl = G5_DATA_URL."/file/{$bo_table}/{$imageName}";
        
        // Save the image to the defined path
        file_put_contents($imagePath, $imageContent);
        
        echo "Image has been downloaded and saved to " . $imagePath;
    } else {
        echo $prompt;
        echo "<p>Error: Unable to download the image from the URL.";
        exit;
    }
} else {
    echo "Error: " . $response;
    exit;
}

echo "<img src='{$imageUrl}' alt='{$title}'>";

$write_table = $g5['write_prefix'].$bo_table;

$html = 'html1';
$wr_subject = $title;
$wr_content = addslashes($prompt);
$wr_seo_title = exist_seo_title_recursive('bbs', generate_seo_title($wr_subject), $write_table);

$random_ip = rand(0, 255).'.'.rand(0, 255).'.'.rand(0, 255).'.'.rand(0, 255);
// $random_hit = rand(50, 150);
$random_hit = 0;
$author = 'AI';

$sql = " insert into $write_table
set wr_num = (SELECT IFNULL(MIN(wr_num) - 1, -1) FROM $write_table as sq),
     wr_reply = '',
     wr_comment = 0,
     ca_name = '',
     wr_option = '{$html}',
     wr_subject = '$wr_subject',
     wr_content = '$wr_content',
     wr_seo_title = '$wr_seo_title',
     wr_link1 = '',
     wr_link2 = '',
     wr_link1_hit = 0,
     wr_link2_hit = 0,
     wr_hit = {$random_hit},
     wr_good = 0,
     wr_nogood = 0,
     mb_id = '{$config['cf_admin']}',
     wr_password = '',
     wr_name = '{$author}',
     wr_email = '',
     wr_homepage = '',
     wr_datetime = '".G5_TIME_YMDHIS."',
     wr_file = 1,
     wr_last = '".G5_TIME_YMDHIS."',
     wr_ip = '{$random_ip}',
     wr_1 = '',
     wr_2 = '',
     wr_3 = '',
     wr_4 = '',
     wr_5 = '',
     wr_6 = '',
     wr_7 = '',
     wr_8 = '',
     wr_9 = '',
     wr_10 = '' ";
sql_query($sql, true);

$wr_id = sql_insert_id();

// 부모 아이디에 UPDATE
sql_query(" update $write_table set wr_parent = '$wr_id' where wr_id = '$wr_id' ");

echo "<h3>{$write_table}에 게시물이 작성 되었습니다.</h3>";

// 게시글 1 증가
sql_query("update {$g5['board_table']} set bo_count_write = bo_count_write + 1 where bo_table = '{$bo_table}'");

$sql = "insert into {$g5['board_file_table']}
    set bo_table = '{$bo_table}',
        wr_id = '$wr_id',
        bf_no = 1,
        bf_source = '$imageName',
        bf_file = '$imageName',
        bf_download = 0,
        bf_content = '',
        bf_filesize = '".filesize($imagePath)."',
        bf_width = {$imageWidth},
        bf_height = {$imageHeight},
        bf_type = 3,
        bf_datetime = '".G5_TIME_YMDHIS."' ";
sql_query($sql, true);

echo "<h3>{$g5['board_file_table']}에 첨부파일이 등록 되었습니다.</h3>";