<?php
include_once('./_common.php');
?>

<div id="start" style="position:fixed;width:100% !important;height:100%;left:0;z-index:-1;bottom:0;opacity:0.1">
    <div id="you01" data-vbg-autoplay="true" data-vbg="https://www.youtube.com/watch?v=yoa08FUE768"></div>
</div>
<div id="opacityDisplay" class="opacityDisplay" title="Right click : Function on/off
Opacity : Drag up down">0.1</div>
<style>
.opacityDisplay {position:fixed;left:0;top:70%;transform:translateY(-50%);background-color:rgb(43, 65, 255);color:white;padding:10px;border-radius:5px;font-size:20px;cursor:grab;user-select:none}
.hidden { display:none }
.noselect {user-select:none;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;}
#chrome_websiteIP { display:none }
</style>

<script src="https://unpkg.com/youtube-background/jquery.youtube-background.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', () => {
    const video = document.getElementById("you01");
    const background = document.getElementById('start');
    const opacityDisplay = document.getElementById('opacityDisplay');
    const allElements = document.querySelectorAll('*');
    const images = document.querySelectorAll("#wrapper, img");
    let isDragging = false;
    let startY;
    let functionalityEnabled = localStorage.getItem('functionalityEnabled') === 'false' ? false : true;
    let backgroundEnabled = localStorage.getItem('backgroundEnabled') === 'false' ? false : true;
    let lastReverseOpacity = 1;
    let savedOpacity = parseFloat(localStorage.getItem('backgroundOpacity')) || .1;

    $('[data-vbg]').youtube_background();

    function adjustOpacity(deltaY, clientY) {
        let newOpacity = parseFloat(background.style.opacity) + deltaY / window.innerHeight;
        newOpacity = Math.max(0, Math.min(1, newOpacity));
        background.style.opacity = newOpacity;
        opacityDisplay.style.opacity = newOpacity;
        startY = clientY;
        showOpacityValue(newOpacity.toFixed(1));
        localStorage.setItem('backgroundOpacity', newOpacity);

        let reverseOpacity = 1 - newOpacity;
        images.forEach(img => {
            img.style.opacity = reverseOpacity;
        });

        lastReverseOpacity = reverseOpacity;
    }

    function showOpacityValue(value) {
        opacityDisplay.textContent = value;
    }

    function initializeState() {
        if (!functionalityEnabled) {
            opacityDisplay.style.opacity = .1;
            opacityDisplay.style.background = "#888";
            background.style.opacity = 1;
            images.forEach(img => {
                img.style.opacity = 1;
            });
        } else {
            opacityDisplay.style.background = "rgb(43, 65, 255)";
            opacityDisplay.style.opacity = savedOpacity;
            background.style.opacity = savedOpacity;
            showOpacityValue(savedOpacity.toFixed(1));

            let reverseOpacity = 1 - savedOpacity;
            images.forEach(img => {
                img.style.opacity = reverseOpacity;
            });
        }

        video.style.display = backgroundEnabled ? "block" : "none";
        updateNoSelectClass();
    }

    function applySavedOpacity() {
        const storedOpacity = parseFloat(localStorage.getItem('backgroundOpacity')) || 0.1;
        background.style.opacity = storedOpacity;
        opacityDisplay.style.opacity = storedOpacity;
        images.forEach(img => {
            img.style.opacity = 1 - storedOpacity;
        });
        showOpacityValue(storedOpacity.toFixed(1));
    }

    document.addEventListener('mousedown', (e) => {
        if (functionalityEnabled) {
            startY = e.clientY;
            isDragging = true;
            document.addEventListener('mousemove', onMouseMove);
            document.addEventListener('mouseup', onMouseUp);
        }
    });

    function onMouseMove(e) {
        if (isDragging) {
            const deltaY = (startY - e.clientY) * 1.5;
            adjustOpacity(deltaY, e.clientY);
            opacityDisplay.style.top = e.clientY + 'px';
        }
    }

    function onMouseUp(e) {
        isDragging = false;
        document.removeEventListener('mousemove', onMouseMove);
        document.removeEventListener('mouseup', onMouseUp);
    }

    document.addEventListener('touchstart', (e) => {
        if (functionalityEnabled) {
            startY = e.touches[0].clientY;
            isDragging = true;
            document.addEventListener('touchmove', onTouchMove);
            document.addEventListener('touchend', onTouchEnd);
        }
    });

    function onTouchMove(e) {
        if (isDragging) {
            const deltaY = (startY - e.touches[0].clientY) * 1.5;
            adjustOpacity(deltaY, e.touches[0].clientY);
        }
    }

    function onTouchEnd(e) {
        isDragging = false;
        document.removeEventListener('touchmove', onTouchMove);
        document.removeEventListener('touchend', onTouchEnd);
    }

    document.addEventListener('contextmenu', (event) => {
        event.preventDefault();
        functionalityEnabled = !functionalityEnabled;
        backgroundEnabled = !backgroundEnabled;

        localStorage.setItem('functionalityEnabled', functionalityEnabled);
        localStorage.setItem('backgroundEnabled', backgroundEnabled);

        if (!functionalityEnabled) {
            opacityDisplay.style.background = "#888";
            background.style.opacity = 1;
            images.forEach(img => {
                img.style.opacity = 1;
            });
        } else {
            let storedOpacity = parseFloat(localStorage.getItem('backgroundOpacity')) || .1;
            opacityDisplay.style.background = "rgb(43, 65, 255)";
            opacityDisplay.style.opacity = storedOpacity;
            background.style.opacity = storedOpacity;
            images.forEach(img => {
                img.style.opacity = 1 - storedOpacity;
            });
            showOpacityValue(storedOpacity.toFixed(1));
        }

        video.style.display = backgroundEnabled ? "block" : "none";
        updateNoSelectClass();
    });

    function updateNoSelectClass() {
        if (functionalityEnabled) {
            allElements.forEach(element => {
                element.classList.add('noselect');
            });
        } else {
            allElements.forEach(element => {
                element.classList.remove('noselect');
            });
        }
    }

    updateNoSelectClass();
    initializeState();

    const observer = new MutationObserver((mutations) => {
        mutations.forEach((mutation) => {
            if (mutation.attributeName === 'style') {
                const opacity = parseFloat(window.getComputedStyle(background).opacity).toFixed(1);
                showOpacityValue(opacity);
                updateNoSelectClass();
            }
        });
    });

    observer.observe(background, { attributes: true });
});
</script>
