<?php
$currentFilePath = __FILE__;
$_Path = preg_match('/\/theme\/[^\/]+/', $currentFilePath, $matches) ? $matches[0] : '';

function find_common_php() {
    $current_dir = dirname(__FILE__);
    $count = 0;

    while (!file_exists("$current_dir/common.php") && $current_dir !== '/' && $current_dir !== '.') {
        $current_dir = dirname($current_dir);
        $count++;
    }

    return $count;
}

$up_count = find_common_php();
$include_path = str_repeat('../', $up_count) . 'common.php';
include_once($include_path);

$currentDirPath = dirname(__FILE__);
$relativeDirPath = str_replace($_SERVER['DOCUMENT_ROOT'], '', $currentDirPath);

$sql = "SELECT * FROM {$g5['board_table']} WHERE bo_read_level = 1";
$query = sql_query($sql);

$board = [];
while ($row = sql_fetch_array($query)) {
    $board[] = $row;
}

$sitemapFilePath = $currentDirPath . '/sitemap.xml';
$sitemap = fopen($sitemapFilePath, 'w');
if (!$sitemap) {
    error_log('Unable to open sitemap file: ' . $sitemapFilePath);
    die('Failed to create sitemap.');
}

fwrite($sitemap, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
fwrite($sitemap, '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">');

$unique_links = [];

function addUrlToSitemap($sitemap, $loc, $lastmod, $priority) {
    $url = "\n<url>\n";
    $url .= "  <loc>" . $loc . "</loc>\n";
    $url .= "  <lastmod>" . htmlspecialchars($lastmod) . "</lastmod>\n";
    $url .= "  <priority>" . htmlspecialchars($priority) . "</priority>\n";
    $url .= "</url>";
    fwrite($sitemap, $url);
}

foreach ($board as $key => $val) {
    $sql = "SELECT * FROM {$g5['write_prefix']}{$val['bo_table']} WHERE wr_id = wr_parent AND wr_is_comment = 0 ORDER BY wr_datetime DESC LIMIT 0, 1";
    $query = sql_fetch($sql);

    $query['wr_datetime'] = empty($query['wr_datetime']) ? date('Y-m-d\TH:i:s') . "+00:00" : preg_replace("/\s/im", "T", $query['wr_datetime']) . "+00:00";

    $loc = $config['cf_bbs_rewrite'] == 0 ? G5_BBS_URL . "/board.php?bo_table={$val['bo_table']}" : G5_URL . "/{$val['bo_table']}";

    if (!in_array($loc, $unique_links)) {
        $unique_links[] = $loc;
        addUrlToSitemap($sitemap, $loc, $query['wr_datetime'], '0.9');
    }

    $sql = "SELECT * FROM {$g5['write_prefix']}{$val['bo_table']} WHERE wr_id = wr_parent AND wr_is_comment = 0 ORDER BY wr_datetime DESC";
    $query = sql_query($sql);

    while ($row = sql_fetch_array($query)) {
        $row['wr_datetime'] = empty($row['wr_datetime']) ? date('Y-m-d\TH:i:s') . "+00:00" : preg_replace("/\s/im", "T", $row['wr_datetime']) . "+00:00";
        $loc = $config['cf_bbs_rewrite'] == 0 ? G5_BBS_URL . "/board.php?bo_table={$val['bo_table']}&wr_id={$row['wr_id']}" : G5_URL . "/{$val['bo_table']}?wr_id={$row['wr_id']}";

        if (!in_array($loc, $unique_links)) {
            $unique_links[] = $loc;
            addUrlToSitemap($sitemap, $loc, $row['wr_datetime'], '0.5');
        }
    }
}

$sql = "SELECT * FROM {$g5['menu_table']} WHERE CHAR_LENGTH(me_code) < 48";
$result = sql_query($sql);

$boards = [];
while ($row = sql_fetch_array($result)) {
    $boards[] = $row;
}

foreach ($boards as $board) {
    $loc = $board['me_link'];
    if (strpos($loc, '/') === 0) {
        $loc = G5_URL . $loc;
    }

    if (!in_array($loc, $unique_links)) {
        $unique_links[] = $loc;
        addUrlToSitemap($sitemap, $loc, date('Y-m-d\TH:i:s') . "+00:00", '1.0');
    }
}

fwrite($sitemap, "\n".'</urlset>');
fclose($sitemap);

echo '<script type="text/javascript">';
echo 'alert("Sitemap has been successfully '.$relativeDirPath.' folder saved!");';
echo 'location.href="/";';
echo '</script>';