<?php
include_once('../common.php'); //경로에 따라 변경 필요
$sw = isset($_REQUEST['sw']) ? clean_xss_tags($_REQUEST['sw'], 1, 1) : '';

if (!$sw){
	alert('sw 값이 제대로 넘어오지 않았습니다.');
}
$act = '일괄변경';

// 게시판 관리자 이상 복사, 이동 가능
if ($is_admin != 'board' && $is_admin != 'group' && $is_admin != 'super')
    alert_close("게시판 관리자 이상 접근이 가능합니다.");

$g5['title'] = '게시물 ' . $act;

$wr_id_list = isset($_POST['wr_id_list']) ? preg_replace('/[^0-9\,]/', '', $_POST['wr_id_list']) : '';
$update_success = false; // 업데이트 여부 확인 변수

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $update_fields = [];

    // 최대 3개의 컬럼 업데이트 가능 (필요하면 확장 가능)
    for ($i = 1; $i <= 3; $i++) {
        if (!empty($_POST["column_$i"]) && !empty($_POST["value_$i"])) {
            $column = preg_replace('/[^a-zA-Z0-9_]/', '', $_POST["column_$i"]); // SQL Injection 방지
            $value = addslashes($_POST["value_$i"]);
            $update_fields[] = "$column = '$value'";
        }
    }

    // 업데이트할 값이 없으면 실행하지 않음
    if (!empty($update_fields)) {
        // 실제 존재하는 wr_id 조회
        $sql_check = "SELECT wr_id FROM $write_table WHERE wr_id IN ({$wr_id_list})";
        $result_check = sql_query($sql_check);

        $existing_wr_ids = [];
        while ($row = sql_fetch_array($result_check)) {
            $existing_wr_ids[] = $row['wr_id'];
        }

        if (!empty($existing_wr_ids)) {
            $wr_id_list_filtered = implode(",", $existing_wr_ids);

            $sql = "SELECT DISTINCT wr_num FROM $write_table WHERE wr_id IN ({$wr_id_list_filtered}) ORDER BY wr_id";
            $result = sql_query($sql);

            while ($row = sql_fetch_array($result)) {
                $wr_num = $row['wr_num'];

                // 선택한 컬럼과 값으로 동적 UPDATE 쿼리 구성
                $sql_update = "UPDATE $write_table SET " . implode(", ", $update_fields) . " WHERE wr_num = '{$wr_num}'";
                sql_query($sql_update);

				$update_success = true; // 업데이트 성공

                // 변경 확인 로그 출력
                //echo "Updated: " . implode(", ", $update_fields) . " for wr_num: $wr_num <br>";
            }
        } else {
            echo "No matching wr_id found. Skipping update.<br>";
        }
    } else {
        echo "No column-value pairs entered for update.<br>";
    }
}

?>

<script>
    <?php if ($update_success): ?>
        alert("변경이 완료되었습니다.");
        window.close();
    <?php else: ?>
        alert("업데이트할 데이터가 없습니다.");
        window.close();
    <?php endif; ?>
</script>
