<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
// 데이타베이스 연결 
include_once("../db/connect.php");

// AJAX 요청 처리
if (isset($_GET['depth'])) {
    header('Content-Type: application/json');
    $depth = intval($_GET['depth']);
    // 빈 문자열이면 NULL로 처리
    $parent_id = (isset($_GET['parent_id']) && $_GET['parent_id'] !== '') ? intval($_GET['parent_id']) : null;

    $sql = "SELECT id, name FROM k_industry WHERE depth = ?";
    $params = [$depth];

    if ($parent_id !== null) {
        $sql .= " AND parent_id = ?";
        $params[] = $parent_id;
    } else {
        $sql .= " AND parent_id IS NULL";
    }

    $stmt = $conn->prepare($sql);
    $stmt->execute($params);
    echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
    exit;
}
?>

<!DOCTYPE html>
<html lang="ko">
<head>
  <meta charset="UTF-8">
  <title>산업 분류 선택</title>
</head>
<body>
  <h2>산업분류 선택</h2>

  <form method="post" action="submit.php"> <!-- 추후 데이터 저장 -->
    <label>대분류:
      <select id="depth1" name="depth1">
        <option value="">선택</option>
      </select>
    </label>
    <br><br>

    <label>중분류:
      <select id="depth2" name="depth2">
        <option value="">선택</option>
      </select>
    </label>
    <br><br>

    <label>소분류:
      <select id="depth3" name="depth3">
        <option value="">선택</option>
      </select>
    </label>
    <br><br>

    <label>세분류:
      <select id="depth4" name="depth4">
        <option value="">선택</option>
      </select>
    </label>
    <br><br>

    <button type="submit">제출</button>
  </form>

  <script>
    // 공통 함수: 분류 불러오기
    function fetchCategories(depth, parentId, targetId) {
      const target = document.getElementById(targetId);
      target.innerHTML = '<option value="">선택</option>';

      let url = `industry_select.php?depth=${depth}`;
      if (parentId !== null && parentId !== '') {
        url += `&parent_id=${parentId}`;
      }
      fetch(url)
        .then(res => res.json())
        .then(data => {
          data.forEach(row => {
            const option = document.createElement('option');
            option.value = row.id;
            option.textContent = row.name;
            target.appendChild(option);
          });
        })
        .catch(error => console.error('Error fetching data:', error));
    }

    // 대분류 로딩: parentId를 null로 전달
    window.onload = function () {
      fetchCategories(1, null, 'depth1');
    };

    // 중분류: 대분류 선택 시
    document.getElementById('depth1').addEventListener('change', function () {
      const parentId = this.value;
      fetchCategories(2, parentId, 'depth2');
      document.getElementById('depth3').innerHTML = '<option value="">선택</option>';
      document.getElementById('depth4').innerHTML = '<option value="">선택</option>';
    });

    // 소분류: 중분류 선택 시
    document.getElementById('depth2').addEventListener('change', function () {
      const parentId = this.value;
      fetchCategories(3, parentId, 'depth3');
      document.getElementById('depth4').innerHTML = '<option value="">선택</option>';
    });

    // 세분류: 소분류 선택 시
    document.getElementById('depth3').addEventListener('change', function () {
      const parentId = this.value;
      fetchCategories(4, parentId, 'depth4');
    });
  </script>
</body>
</html>
