<?php
$files = [
    __DIR__ . '/theme/basic/head.php',
    __DIR__ . '/theme/basic/mobile/head.php'
];

$beforeGnbCode = "@include_once(G5_LIB_PATH.'/menu_class.php')";
$endCode = "@include_once(G5_LIB_PATH.'/category.php');";

foreach ($files as $targetFile) {
    if (!file_exists($targetFile)) {
        echo "파일을 찾을 수 없습니다: $targetFile<br>";
        continue;
    }

    $content = file_get_contents($targetFile);
    $originalContent = $content;

    // gnb 위에 삽입 (들여쓰기 포함)
    if (strpos($content, $beforeGnbCode) === false) {
        // 공백을 포함한 라인을 찾고, 해당 공백을 보존하며 삽입
        $content = preg_replace_callback(
            '/^([ \t]*)<[^>]*id\s*=\s*[\'"]gnb[\'"][^>]*>/mi',
            function ($matches) use ($beforeGnbCode) {
                $indent = $matches[1]; // 들여쓰기 공백
                return $indent . "<?php $beforeGnbCode; ?>" . "\n" . $matches[0];
            },
            $content,
            1
        );
    }

    // 마지막에 category.php 삽입
    if (strpos($content, $endCode) === false) {
        $content = rtrim($content);
        $content .= " ".$endCode;
    }

    if ($content !== $originalContent) {
        file_put_contents($targetFile, $content);
//        echo "코드가 삽입되었습니다: $targetFile<br>";
    } else {
//        echo "변경 사항 없음: $targetFile<br>";
        error_log("파일 업데이트 안됨: $targetFile");
    }
}