<?php
$sub_menu = "200815";
include_once('./_common.php');

if (isset($auth[$sub_menu])) {
  auth_check($auth[$sub_menu], "r");
}

$g5['title'] = "외부 유입 검색어";
include_once(G5_ADMIN_PATH.'/admin.head.php');
include_once(G5_PLUGIN_PATH.'/jquery-ui/datepicker.php');

$colspan = 6;

$day=1; //기간 - 기본검색설정된 기간입니다. 필요에따라 수정해서 사용가능합니다.

if (empty($fr_date) || ! preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $fr_date) ) $fr_date = date("Y-m-d", strtotime($day . " days ago"));
if (empty($to_date) || ! preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $to_date) ) $to_date = G5_TIME_YMD;

$qstr = "fr_date=".$fr_date."&amp;to_date=".$to_date;
$query_string = $qstr ? '?'.$qstr : '';

$days=(strtotime($to_date)-strtotime($fr_date))/(24*60*60)+1;

// 주사 지랄 방지
$site = '';
$site = substr($site, 0, 10);
$site_ori = $site;

// 검색사이트들
$site_arr = array("Naver", "Google", "Nate", "Yahoo", "Daum", "Bing");
$surl_arr = array("Naver" => "%naver.com%", "Google" => "http://www.google.%", "Nate" => "%nate.com%", "Yahoo" => "%search.yahoo.com%", "Daum" => "%search.daum.net%", "Bing" => "http://www.bing.com%");
$svar_arr = array("Naver" => "query", "Google" => "q", "Nate" => "q", "Yahoo" => "p", "Daum" => "q", "Bing" => "q");

$listall = '<a href="'.$_SERVER['SCRIPT_NAME'].'" class="ov_listall">전체목록</a>';

// total count
$sql_common = " from {$g5['visit_table']} ";

$sql_search = " where vi_date between '{$fr_date}' and '{$to_date}' ";

if($stx) {
	str_replace(array("\"", "\'"), "", $stx); // 주사지랄방지
	$sql_search = " where vi_ip = '{$stx}'";
}

$st = '';
if ($st && trim($sv))
    $sql_search = " where vi_ip like '%$sv%' ";

if (isset($site)) {
    // vi_referer에서 사이트 찾고, vi_date로 범위 정하기, 정렬은 vi_id 역순 (속도 개선 필요)
    if(in_array($site_ori, $site_arr)) {
        $sql_search .= " and vi_referer LIKE '{$surl_arr[$site_ori]}' ";
    }else{ // 5개 사이트 모두 포함
        $sql_search .= " and ( ";
        foreach($surl_arr as $site => $surl) {
            $sql_search .= " vi_referer LIKE '$surl' OR ";
        }
        $sql_search .= " 0 )";
	}	
}

$sql = " select *
            {$sql_common}
            {$sql_search}
            order by vi_id desc";
$result = sql_query($sql);

$total_count = 0;
$cnt2 = array();
for ($i=0; $row=sql_fetch_array($result); $i++) {

	// 어느 사이트인지 찾기
	foreach($surl_arr as $site => $surl) {
		if(strstr($row['vi_referer'], str_replace("%", "", $surl))) {
			$engine = $site;
			break;
		}
	}
$querystr = ''; // 변수 선언 및 초기화
// 검색문자열 찾기
if (array_key_exists($engine, $svar_arr)) {
    $regex = "/(\?|&){$svar_arr[$engine]}\=([^&]*)/i";
}
preg_match($regex, $row['vi_referer'], $matches);
if (isset($matches[2])) {
    $querystr = $matches[2];
}
	// 보통 검색어 사이를 +로 넘긴다
	$querystr = str_replace("+", " ", $querystr);
	// %ab 이런 식으로 된 걸 바꿔주기
	$querystr = urldecode($querystr);
	// 네이버는 unicode로 된 경우도 있어서
	if($engine=="Naver") $querystr = utf8_urldecode($querystr);
	// 캐릭터셋이 utf-8인 경우는 euc-kr 고치기 (utf-8 유저는 euc-KR과 utf-8을 서로 바꿔주면 될 듯)
	$charset = mb_detect_encoding($querystr, "ASCII, euc-KR, utf-8"); 
	if($charset=="euc-kr") $querystr = iconv("euc-kr", "utf-8", $querystr);
	//$charset = mb_detect_encoding($querystr, "ASCII, utf-8, euc-kr");
	//if($charset=="utf-8") $querystr = iconv("utf-8", "euc-kr", $querystr);
	// 자잘한 처리들
	$querystr = trim($querystr);
	$querystr = htmlspecialchars($querystr);
	// 가끔 빈 것들도 있다 -_-
	if(!strlen($querystr)) continue;
	
	$rows[$i]['vi_date'] = $row['vi_date'];
	$rows[$i]['vi_time'] = $row['vi_time'];
	$rows[$i]['engine'] = $engine;
	$rows[$i]['vi_referer'] = $row['vi_referer'];
	$rows[$i]['querystr'] = $querystr;
	$rows[$i]['vi_device'] = $row['vi_device'];
	$rows[$i]['vi_ip'] = $row['vi_ip'];
	
	// 카운트용 변수
	$total_count++;

$cnt2 = array(
  'Naver' => 0,
  'Google' => 0,
  'Nate' => 0,
  'Yahoo' => 0,
  'Daum' => 0,
  'Bing' => 0,
);

foreach ($rows as $r) {
  $engine = $r['engine'];
  if (array_key_exists($engine, $cnt2)) {
    $cnt2[$engine]++;
  }
}
}
//ksort($cnt2);

// 베짱이님 제공 함수
function utf8_urldecode($str, $chr_set='CP949') {
	//$callback_function = create_function('$matches, $chr_set="'.$chr_set.'"', 'return iconv("UTF-16BE", $chr_set, pack("n*", hexdec($matches[1])));');
	$callback_function = function ($matches) use ($chr_set) {
    return iconv("UTF-16BE", $chr_set, pack("n*", hexdec($matches[1])));
};
	return rawurldecode(preg_replace_callback('/%u([[:alnum:]]{4})/', $callback_function, $str));
} 
?>

<div class="local_ov01 local_ov">
    <?php echo $listall ?>
    <span class="btn_ov01"><span class="ov_txt">전체 </span><span class="ov_num"> <?php echo number_format($total_count) ?> 건 </span></span>
    &nbsp;<span class="btn_ov01"><span class="ov_txt">1일 평균</span><span class="ov_num"><?php echo sprintf("%.1f",$total_count / $days)?> 건 </span></span>
	<?php 
	if(!$site_ori) { // 모든 사이트의 경우 비율 분석
		foreach($cnt2 as $engine => $count) {
			echo '&nbsp;<span class="btn_ov01"><span class="ov_txt">'.$engine.'</span><span class="ov_num">'.$count.' 건 ('.sprintf("%.1f",$count/$total_count*100).'%) </span></span>';
		}
	}
	?>	
</div>

<form name="fvisit" id="fvisit" class="local_sch03 local_sch" method="get">
<div class="sch_last">
    <strong>기간별검색</strong>
    <input type="text" name="fr_date" value="<?php echo $fr_date ?>" id="fr_date" class="frm_input" size="11" maxlength="10">
    <label for="fr_date" class="sound_only">시작일</label>
    ~
    <input type="text" name="to_date" value="<?php echo $to_date ?>" id="to_date" class="frm_input" size="11" maxlength="10">
    <label for="to_date" class="sound_only">종료일</label>
    <input type="submit" value="검색" class="btn_submit">
</div>
</form>

<form name="search_form" id="search_form" action=<?php echo $_SERVER['SCRIPT_NAME'];?> class="local_sch01 local_sch" method="get">
<?php $sv = ""; ?>
<label for="st" class="sound_only">검색대상</label>
<input type="hidden" name="st" id="st" value="vi_ip" >
<label for="sv" class="sound_only">검색어<strong class="sound_only"> 필수</strong></label>
<input type="text" name="sv" value="<?php echo $sv ?>" id="sv" required class="required frm_input" placeholder="IP 검색">
<input type="submit" value="검색" class="btn_submit">

</form>

<ul class="anchor">
    <li><a href="<?php echo $PHP_SELF;?><?php echo $query_string ?>">All</a></li>
	<?php foreach($site_arr as $site) { ?>
	<li><a href="<?php echo $PHP_SELF;?><?php echo $query_string ?>&site=<?php echo $site;?>"><?php echo $site;?></a></li>
	<?php } ?>	
</ul>

<?php if($stx) {?>
<div class="btn_list03 btn_list">
	<a href="<?php echo $_SERVER['PHP_SELF']?><?php echo $query_string ?>">IP 필터 풀기</a>
</div>
<?php }?>

<script>
$(function(){
    $("#fr_date, #to_date").datepicker({ changeMonth: true, changeYear: true, dateFormat: "yy-mm-dd", showButtonPanel: true, yearRange: "c-99:c+99", maxDate: "+0d" });
});

function fvisit_submit(act)
{
    var f = document.fvisit;
    f.action = act;
    f.submit();
}
</script>

<div class="tbl_head01 tbl_wrap">
    <table>
    <caption><?php echo $g5['title']; ?> 목록</caption>
    <thead>
    <tr>
        <th scope="col">날짜</th>
        <th scope="col">시간</th>
        <th scope="col">사이트</th>
        <th scope="col">검색어</th>
        <th scope="col">접속기기</th>
        <th scope="col">IP</th>
    </tr>
    </thead>
    <tbody>
	<?php if (!empty($rows)) { ?>
		<?php
		$i = 0;
		foreach ($rows as $r) {
			$bg = 'bg'.($i%2);
		?>
			<tr class="<?php echo $bg; ?>">
				<td class="td_datetime"><?php echo $r['vi_date']?></td>
				<td class="td_datetime"><?php echo $r['vi_time']?></td>
				<td class="td_category"><img src="./status/img/<?php echo strtolower($r['engine'])?>.jpg" /></td>
				<td><a href="<?php echo $r['vi_referer']?>" target="_blank"><?php echo $r['querystr']?></a></td>
				<td class="td_category td_category2"><?php echo $r['vi_device']; ?></td>
				<td class="td_category td_category2"><a href="<?=$_SERVER['PHP_SELF']?><?php echo $query_string ?>&stx=<?php echo $r['vi_ip']?>"><?php echo $r['vi_ip']; ?></a></td>
			</tr>
			<?php $i++; ?>
		<?php } ?>
	<?php } else { ?>
		<tr><td colspan="6" class="empty_table">검색 결과가 없습니다.</td></tr>
	<?php } ?>		
    </tbody>
    </table>
</div>

<?php
include_once G5_ADMIN_PATH."/admin.tail.php";
?>