<?php
include_once ('../config.php');
gLoadLanguage(); // Added by EVENING 다중언어지원
include_once('../lib/json.lib.php');
include_once('../lib/common.lib.php');    // 공통 라이브러리
include_once('./install.function.php');    // 인스톨 과정 함수 모음

include_once('../lib/hook.lib.php');    // hook 함수 파일
include_once('../lib/get_data.lib.php');    // 데이타 가져오는 함수 모음

$data_path = '../'.G5_DATA_DIR;

// 파일이 존재한다면 설치할 수 없다.
$dbconfig_file = $data_path.'/'.G5_DBCONFIG_FILE;
if (file_exists($dbconfig_file)) {
    die(install_json_msg(gText('install_22')));
}

if (preg_match("/[^0-9a-z_]+/i", $_POST['table_prefix']) ) {
    die(install_json_msg(gText('install_23')));
}

$mysql_host  = safe_install_string_check($_POST['mysql_host'], 'json');
$mysql_user  = safe_install_string_check($_POST['mysql_user'], 'json');
$mysql_pass  = safe_install_string_check($_POST['mysql_pass'], 'json');
$mysql_db    = safe_install_string_check($_POST['mysql_db'], 'json');
$table_prefix= safe_install_string_check(preg_replace('/[^a-zA-Z0-9_]/', '_', $_POST['table_prefix']));

$tmp_str = isset($_SERVER['SERVER_SOFTWARE']) ? $_SERVER['SERVER_SOFTWARE'] : '';
$ajax_token = md5($tmp_str.$_SERVER['REMOTE_ADDR'].dirname(dirname(__FILE__).'/'));

$bool_ajax_token = ($ajax_token == $_POST['ajax_token']) ? true : false;

if( !($mysql_host && $mysql_user  && $mysql_db && $table_prefix && $bool_ajax_token) ){
    die(install_json_msg(gText('install_24')));
}

try {
    $dblink = sql_connect($mysql_host, $mysql_user, $mysql_pass, $mysql_db);
} catch (Exception $e) {
}

if (!$dblink) {
    die(install_json_msg(gText('install_25')));
}

try {
    $select_db = sql_select_db($mysql_db, $dblink);
} catch (Exception $e) {
}

if (!$select_db) {
    die(install_json_msg(gText('install_26')));
}

if(sql_query("DESCRIBE `{$table_prefix}config`", G5_DISPLAY_SQL_ERROR, $dblink)) {
    die(install_json_msg(gText('install_27'), 'exists'));
}

die(install_json_msg('ok', 'success'));