<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
$data_path = '../'.G5_DATA_DIR;

if (!$title) $title = gText('install_38', array('gnu_version'=>G5_VERSION));
?>
<!doctype html>
<html lang="ko">
<head>
<meta charset="utf-8">
<title><?php echo $title; ?></title>
<link rel="stylesheet" href="install.css">
</head>
<body>

<div id="ins_bar">
    <span id="bar_img">GNUBOARD5</span>
    <!-- Added by EVENING -->
    <select id="bar_lang" style="margin-left: 50px;" onchange="setLanguage()">
        <option value="ko" <?php echo $_SESSION['gLanguage']=='ko'? 'selected' : ''?>>한국어</option>
        <option value="en" <?php echo $_SESSION['gLanguage']=='en'? 'selected' : ''?>>English</option>
    </select>

    <script>
        function setLanguage() {
            var lang = document.getElementById('bar_lang').value;
            var target = window.location.href;
            window.location.href = target + (target.indexOf('?')>-1? '&gLanguage=' : '?gLanguage=') + lang;
        }
    </script>
    <!-- End adding -->
    <span id="bar_txt">INSTALLATION</span>
</div>

<?php
// 파일이 존재한다면 설치할 수 없다.
$dbconfig_file = $data_path.'/'.G5_DBCONFIG_FILE;
if (file_exists($dbconfig_file)) {
?>
<h1><?php gTextE('install_39', array('gnu_version'=>G5_VERSION));?></h1>

<div class="ins_inner">
    <p><?php gTextE('install_40');?></p>
    <ul>
        <li><?php echo $dbconfig_file ?></li>
    </ul>
</div>
<?php
    exit;
}
?>

<?php
$exists_data_dir = true;
// data 디렉토리가 있는가?
if (!is_dir($data_path))
{
?>
<h1><?php gTextE('install_41', array('gnu_version'=>G5_VERSION));?></h1>

<div class="ins_inner">
    <p>
        <?php gTextE('install_42', array('gnu_data_dir'=>G5_DATA_DIR));?>
    </p>
</div>
<?php
    $exists_data_dir = false;
}
?>

<?php
$write_data_dir = true;
// data 디렉토리에 파일 생성 가능한지 검사.
if (strtoupper(substr(PHP_OS, 0, 3)) !== 'WIN') {
    $sapi_type = php_sapi_name();
    if (substr($sapi_type, 0, 3) == 'cgi') {
        if (!(is_readable($data_path) && is_executable($data_path)))
        {
        ?>
        <div class="ins_inner">
            <p>
                <?php gTextE('install_43', array('gnu_data_dir'=>G5_DATA_DIR));?>
            </p>
        </div>
        <?php
            $write_data_dir = false;
        }
    } else {
        if (!(is_readable($data_path) && is_writeable($data_path) && is_executable($data_path)))
        {
        ?>
        <div class="ins_inner">
            <p>
                <?php gTextE('install_44', array('gnu_data_dir'=>G5_DATA_DIR));?>
            </p>
        </div>
        <?php
            $write_data_dir = false;
        }
    }
}