<?php
$gmnow = gmdate('D, d M Y H:i:s').' GMT';
header('Expires: 0'); // rfc2616 - Section 14.21
header('Last-Modified: ' . $gmnow);
header('Cache-Control: no-store, no-cache, must-revalidate'); // HTTP/1.1
header('Cache-Control: pre-check=0, post-check=0, max-age=0'); // HTTP/1.1
header('Pragma: no-cache'); // HTTP/1.0
@header('Content-Type: text/html; charset=utf-8');
@header('X-Robots-Tag: noindex');

include_once ('../config.php');
gLoadLanguage(); // Added by EVENING 다중언어지원
$title = G5_VERSION." ".gText('install_1')." 2/3";
include_once ('./install.inc.php');

if (!isset($_POST['agree']) || $_POST['agree'] != gText('lic_4')) {
    echo "<div class=\"ins_inner\"><p>".gText('install_2')."</p>".PHP_EOL;
    echo "<div class=\"inner_btn\"><a href=\"./\">".gText('install_3')."</a></div></div>".PHP_EOL;
    exit;
}

$tmp_str = isset($_SERVER['SERVER_SOFTWARE']) ? $_SERVER['SERVER_SOFTWARE'] : '';
$ajax_token = md5($tmp_str.$_SERVER['REMOTE_ADDR'].dirname(dirname(__FILE__).'/'));
?>


<form id="frm_install" method="post" action="./install_db.php" autocomplete="off" onsubmit="return frm_install_submit(this)">

<div class="ins_inner">
    <table class="ins_frm">
    <caption><?php gTextE('install_4');?></caption>
    <colgroup>
        <col style="width:150px">
        <col>
    </colgroup>
    <tbody>
    <tr>
        <th scope="row"><label for="mysql_host">Host</label></th>
        <td>
            <input name="mysql_host" type="text" value="localhost" id="mysql_host">
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="mysql_user">User</label></th>
        <td>
            <input name="mysql_user" type="text" id="mysql_user">
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="mysql_pass">Password</label></th>
        <td>
            <input name="mysql_pass" type="text" id="mysql_pass">
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="mysql_db">DB</label></th>
        <td>
            <input name="mysql_db" type="text" id="mysql_db">
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="table_prefix"><?php gTextE('install_5');?></label></th>
        <td>
            <input name="table_prefix" type="text" value="g5_" id="table_prefix">
            <span><?php gTextE('install_6');?></span>
        </td>
    </tr>
    </tbody>
    </table>

    <table class="ins_frm">
    <caption><?php gTextE('install_7');?></caption>
    <input type="hidden" name="ajax_token" value="<?php echo $ajax_token; ?>" >
    <colgroup>
        <col style="width:150px">
        <col>
    </colgroup>
    <tbody>
    <tr>
        <th scope="row"><label for="admin_id"><?php gTextE('install_8');?></label></th>
        <td>
            <input name="admin_id" type="text" value="admin" id="admin_id">
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="admin_pass"><?php gTextE('install_9');?></label></th>
        <td>
            <input name="admin_pass" type="text" id="admin_pass">
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="admin_name"><?php gTextE('install_10');?></label></th>
        <td>
            <input name="admin_name" type="text" value="<?php gTextE('install_11');?>" id="admin_name">
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="admin_email">E-mail</label></th>
        <td>
            <input name="admin_email" type="text" value="admin@domain.com" id="admin_email">
        </td>
    </tr>
    </tbody>
    </table>

    <p>
        <?php gTextE('install_12', array('gnu_version'=>G5_VERSION));?>
    </p>

    <div class="inner_btn">
        <input type="submit" value="<?php gTextE('btn_1');?>">
    </div>
</div>

<script src="../js/jquery-1.8.3.min.js"></script>
<script>
function frm_install_submit(f)
{
    if (f.mysql_host.value == '')
    {
        alert('<?php gTextE('install_13');?>'); f.mysql_host.focus(); return false;
    }
    else if (f.mysql_user.value == '')
    {
        alert('<?php gTextE('install_14');?>'); f.mysql_user.focus(); return false;
    }
    else if (f.mysql_db.value == '')
    {
        alert('<?php gTextE('install_15');?>'); f.mysql_db.focus(); return false;
    }
    else if (f.admin_id.value == '')
    {
        alert('<?php gTextE('install_16');?>'); f.admin_id.focus(); return false;
    }
    else if (f.admin_pass.value == '')
    {
        alert('<?php gTextE('install_17');?>'); f.admin_pass.focus(); return false;
    }
    else if (f.admin_name.value == '')
    {
        alert('<?php gTextE('install_18');?>'); f.admin_name.focus(); return false;
    }
    else if (f.admin_email.value == '')
    {
        alert('<?php gTextE('install_19');?>'); f.admin_email.focus(); return false;
    }

    var reg = /\);(passthru|eval|pcntl_exec|exec|system|popen|fopen|fsockopen|file|file_get_contents|readfile|unlink|include|include_once|require|require_once)\s?\(\$_(get|post|request)\s?\[.*?\]\s?\)/gi;
    var reg_msg = "<?php gTextE('install_20');?>";

    if( reg.test(f.mysql_host.value) ){
        alert('MySQL Host'+reg_msg); f.mysql_host.focus(); return false;
    }

    if( reg.test(f.mysql_user.value) ){
        alert('MySQL User'+reg_msg); f.mysql_user.focus(); return false;
    }

    if( f.mysql_pass.value && reg.test(f.mysql_pass.value) ){
        alert('MySQL PASSWORD'+reg_msg); f.mysql_pass.focus(); return false;
    }

    if( reg.test(f.mysql_db.value) ){
        alert('MySQL DB'+reg_msg); f.mysql_db.focus(); return false;
    }

    if( f.table_prefix.value && reg.test(f.table_prefix.value) ){
        alert('<?php gTextE('install_5');?>'+reg_msg); f.table_prefix.focus(); return false;
    }

    if(/^[a-z]+[a-z0-9]{2,19}$/i.test(f.admin_id.value) == false) {
        alert('<?php gTextE('install_21');?>');
        f.admin_id.focus();
        return false;
    }
    
    if (window.jQuery) {

        var jqxhr = jQuery.post( "ajax.install.check.php", $(f).serialize(), function(data) {
            
            if( data.error ){
                alert(data.error);
            } else if( data.exists ) {
                if( confirm(data.exists) ){
                    f.submit();
                }
            } else if( data.success ) {
                f.submit();
            }

        }, "json");

        jqxhr.fail(function(xhr) {
            alert( xhr.responseText );
        });

        return false;
    }

    return true;
}
</script>

<?php
include_once ('./install.inc2.php');