<?php
/**
 * 어종별 문자열 처리를 위한 전역 함수들을 정의한다.
 * 전역함수라는 의미에서 함수명은 모두 영문자 'g' 로 시작한다.
 */

defined('DS') OR define ('DS', DIRECTORY_SEPARATOR); // 경로기호 '\', '/' 등을 플랫폼별로 맞추기 위한것
defined('DOC_ROOT') OR define ('DOC_ROOT', dirname(__FILE__)); // 그누보드 루트폴더 절대경로 정의
defined('LANG_ROOT') OR define ('LANG_ROOT', DOC_ROOT.DS.'language'); // 그누보드 어종파일폴더 절대경로


/**
 * 동적으로 어종파일 설정
 * GET 파라미터 gLanguage 값을 세션 gLanguage에 저장한다.
 * 세션 gLanguage 값이 존재하면 그 어종파일을 로드한다.
 * 아무 설정도 없으면 기정으로 한국어 파일 즉, ko.php를 로드한다.
 */
function gLoadLanguage() {
    if(!isset($_SESSION)) {
        @session_start();
    }
    if(isset($_GET['gLanguage'])) {
        $_SESSION['gLanguage'] = $_GET['gLanguage'];
    }
    if(!isset($_SESSION['gLanguage'])) {
        $_SESSION['gLanguage'] = 'ko'; // 기정으로 한국어 로드
    }

    gImportLanguage($_SESSION['gLanguage']); // 해당 어종파일 로드
}


/**
 * 어종파일 로드
 * 기정어종은 한국어이다.
 * LANG_ROOT 에 지정된 경로에 ko.php, en.php 등 어종파일들을 저장한다.
 * @param string $lang
 */
function gImportLanguage($lang='ko')
{
    $user_lang = trim($lang, " \t\n\r\0\x0B\x8\x1A/\\");
    $path = LANG_ROOT.DS.$user_lang.'.php';
    if(file_exists($path)) {
        require_once $path;
    } else {
        die('어종파일을 찾을수 없습니다: '.$path);
    }
}

/**
 * 어종별 문자열 리턴
 * @param $index
 * @param null $data
 * @return mixed|string
 */
function gText($index, $data=null)
{
    $lang = $GLOBALS['gLang'];
    if(!isset($lang[$index])) {
        return '';
    }
    else {
        $text = $lang[$index];
        if(empty($data)) {
            return $text;
        }
        else {
            return gTextR($text, $data);
        }
    }
}

/**
 * 어종별 문자열 직접 출력
 * @param $index
 * @param null $data
 */
function gTextE($index, $data=null)
{
    echo gText($index, $data);
}

/**
 * 어종별 문자열에서 동적으로 내용 변경
 * 예:
 * 어종파일내용: 'visit_calc'=>'##user_id##님 출석 ##count##회'
 * $text = gText('visit_calc', array('user_id'=>'jina', 'count'=>'66');
 * $text 내용: 'jina님 출석 66회'
 *
 * @param $text
 * @param $data array e.g. ['search'=>'replace'] '##search##' in $text replace to 'replace'
 * @return mixed
 */
function gTextR($text, $data)
{
    foreach ($data as $key=>$val) {
        $text = str_replace('##'.$key.'##', $val, $text);
    }
    return $text;
}