<?php
function loadMo($filename) {
    $translations = false;
    
    // @codingStandardsIgnoreStart
    // Binary files extracted makes non-standard local variables
    if ($data = file_get_contents($filename)) {
        $translations = array();
        $header = substr($data, 0, 20);
        $header = unpack("L1magic/L1version/L1count/L1o_msg/L1o_trn", $header);
        extract($header);
        
        if ((dechex($magic) == '950412de' || dechex($magic) == 'ffffffff950412de') && $version == 0) {
            for ($n = 0; $n < $count; $n++) {
                $r = unpack("L1len/L1offs", substr($data, $o_msg + $n * 8, 8));
                $msgid = substr($data, $r["offs"], $r["len"]);
                unset($msgid_plural);
                
                if (strpos($msgid, "\000")) {
                    list($msgid, $msgid_plural) = explode("\000", $msgid);
                }
                $r = unpack("L1len/L1offs", substr($data, $o_trn + $n * 8, 8));
                $msgstr = substr($data, $r["offs"], $r["len"]);
                
                if (strpos($msgstr, "\000")) {
                    $msgstr = explode("\000", $msgstr);
                }
                $translations[$msgid] = $msgstr;
                
                if (isset($msgid_plural)) {
                    $translations[$msgid_plural] =& $translations[$msgid];
                }
            }
        }
    }
    // @codingStandardsIgnoreEnd
    
    return $translations;
}

function translate($singular, $language = null, $domain = null) {
    
    $directory = G5_PATH.'/'."language/"; // your path to language folder
    if (strpos($singular, "\r\n") !== false) {
        $singular = str_replace("\r\n", "\n", $singular);
    }
    
    if (is_null($language) ) { // default el
        //$language = "el";
        return $singular;
    }
    
    if (is_null($domain)) {
        $domain = "default";
    }
    
    $localeDef = $directory . $language;
    $file = $localeDef."/".$domain;
    $translations = null;
    
    if (is_file($file . '.mo')) {
        $translations = loadMo($file . '.mo');
    }
    
    if (!empty($translations[$singular])) {
        
        $trans = $translations[$singular];
        
        if (strlen($trans)) {
            return $trans;
        }
    }
    
    return $singular;
    
}

function __($singular) {
    
//     $filename = "/Applications/MAMP/htdocs/convert/target.txt";
//     $fh = fopen($filename, "a");
//     fwrite($fh, 'msgid "'.$singular.'"'.PHP_EOL);
// //     fclose($fh);
    
    
    if (!$singular) {
        return;
    }

    $lang =  getenv("lang") ;
    $basedir =  getenv("basedir") ;
    $domain =  getenv("domain") ;
    
    
    $translated = translate($singular,$lang,$domain);
    
    
// //     if ( $singular == $translated ) {
// //         fwrite($fh, 'msgid "'.$singular.'"'.PHP_EOL);
// //     }
//     fwrite($fh, 'msgstr "'.$translated.'"'.PHP_EOL);
    
//     fclose($fh);
    
    return $translated;
}

?>