<?php
$sub_menu = '765000';
include_once('./_common.php');

if ($is_admin != 'super')
    alert('최고관리자만 접근 가능합니다.', G5_URL);

$g5['title'] = 'DHTML 이미지 정리';
include_once('./admin.head.php');
?>

<div class="local_desc02 local_desc">
    <p>
        완료 메세지가 나오기 전에 프로그램의 실행을 중지하지 마십시오.
    </p>
</div>

<?php
$directory = array();

// editor 아래의 날짜 디렉토리들 수집
if($handle = opendir(G5_DATA_PATH.'/editor')) {
	while(false !== ($entry = readdir($handle))) {
		if($entry == '.' || $entry == '..') continue;

		$path = G5_DATA_PATH.'/editor/'.$entry;
		if(is_dir($path)) $directory[] = $path;
    }
}

flush();

if (empty($directory)) {
    echo '<p>디렉토리를 열지 못했습니다.</p>';
}

echo '<ul>'.PHP_EOL;

// 검토 테이블들
$tables = array($g5['new_win_table'], $g5['board_table'], $g5['qa_config_table'], $g5['qa_content_table'], $g5['content_table'], $g5['faq_master_table'], $g5['faq_table']);

// 각 테이블별 필드(들)
$fields[$g5['new_win_table']] = array('nw_content'); // 팝업
$fields[$g5['board_table']] = array('bo_content_head', 'bo_content_tail', 'bo_mobile_content_head', 'bo_mobile_content_tail'); // 게시판 설정
$fields[$g5['qa_config_table']] = array('qa_content_head', 'qa_content_tail', 'qa_mobile_content_head', 'qa_mobile_content_tail'); // 1대1 문의설정
$fields[$g5['qa_content_table']] = array('qa_content'); // 1대1 문의
$fields[$g5['content_table']] = array('co_content', 'co_mobile_content'); // 내용관리
$fields[$g5['faq_master_table']] = array('fm_head_html', 'fm_tail_html', 'fm_mobile_head_html', 'fm_mobile_tail_html'); // FAQ master
$fields[$g5['faq_table']] = array('fa_subject', 'fa_content'); // FAQ

// 게시판 테이블들
$result = sql_query("select bo_table from {$g5['board_table']} order by bo_table");
while($row = sql_fetch_array($result))
{
	$write_table = $g5['write_prefix'] . $row['bo_table'];
	$tables[] = $write_table;
	$fields[$write_table] = array('wr_content');
}

// 쇼핑몰일 경우
if(defined('G5_USE_SHOP') && G5_USE_SHOP)
{
	array_push($tables, $g5['g5_shop_default_table'], $g5['g5_shop_category_table'], $g5['g5_shop_item_table'], $g5['g5_shop_item_qa_table'], $g5['g5_shop_item_use_table'], $g5['g5_shop_event_table']);

	$fields[$g5['g5_shop_default_table']] = array('de_baesong_content', 'de_change_content', 'de_guest_privacy'); // 쇼핑몰 설정
	$fields[$g5['g5_shop_category_table']] = array('ca_head_html', 'ca_tail_html', 'ca_mobile_head_html', 'ca_mobile_tail_html'); // 상품분류
	$fields[$g5['g5_shop_item_table']] = array('it_explan', 'it_mobile_explan', 'it_head_html', 'it_tail_html', 'it_mobile_head_html', 'it_mobile_tail_html'); // 상품
	$fields[$g5['g5_shop_item_qa_table']] = array('iq_question', 'iq_answer'); // 상품 질문답변
	$fields[$g5['g5_shop_item_use_table']] = array('is_content'); // 상품 후기
	$fields[$g5['g5_shop_event_table']] = array('ev_head_html', 'ev_tail_html'); // 이벤트
}

$cnt = 0;
$tot_cnt = 0;
$tot_size = 0;
foreach($directory as $dir) // 디렉토리별로 돌림
{
	$files = array();
	$files = scandir($dir);

	foreach($files as $file)
	{
		if($file == '.' or $file == '..') continue;

		if(is_file($dir.'/'.$file))
		{
			$tot_cnt++;
			$is_del = true;
			// editor가 있는 테이블의 필드들에서 존재 하는지 검사
			for($i=0; $i<count($tables); $i++)
			{
				$sql = '';
				for($j=0; $j<count($fields[$tables[$i]]); $j++)
				{
					if($sql) $sql .= ' or ';
					$sql .= 'INSTR('.$fields[$tables[$i]][$j].", '$file')";
				}
				$sql = "select count(*) as cnt from {$tables[$i]} where ".$sql;
				$row = sql_fetch($sql);

				if($row['cnt'] > 0) $is_del = false;
			}

			// 존재하지 않는다면 삭제
			if($is_del)
			{
				$size = filesize($dir.'/'.$file);
				$filesize = get_filesize($size);
				@unlink($dir.'/'.$file);
				echo '<li>'.$dir.'/'.$file.' :: '.$filesize.'</li>'.PHP_EOL;
				$cnt++;
				$tot_size += $size;
			}
		}
	}
}

echo '<li>완료됨</li></ul>'.PHP_EOL;
echo '<div class="local_desc01 local_desc"><p><strong>이미지 전체 '.$tot_cnt.'건 중 '.$cnt.'건 삭제 완료하였습니다. ('.get_filesize($tot_size).')</strong><br>프로그램의 실행을 끝마치셔도 좋습니다.</p></div>'.PHP_EOL;
?>

<?php
include_once('./admin.tail.php');
?>