<?php
/**
 * Author k9400275@gmail.com
 * License : 원 제작자 표시 삭제 금지, 소스 수정후 무단배포 금지.
 * Date: 18. 1. 12
 * Time: 오후 3:01
 */

namespace Delivery;
use \Exception;
use GuzzleHttp\Client;
use Symfony\Component\DomCrawler\Crawler;

/**
 * cj는 배송조회 하는 웹페이지가 여러개 있습니다.
 *
 * 1. https://www.doortodoor.co.kr/parcel/doortodoor.do?fsp_action=PARC_ACT_002&fsp_cmd=retrieveInvNoACT&invc_no={12자리숫자}
 *
 * Class CJParser
 * @package Delivery
 */
class CJParser
{
    protected $company_name = "우체국택"; //택배 업체명
    protected $company_code = ""; //택배 업체코드
    protected $url = ""; //배송조회 url
    protected $url_pattern = "https://www.doortodoor.co.kr/parcel/doortodoor.do?fsp_action=PARC_ACT_002&fsp_cmd=retrieveInvNoACT&invc_no=%s";

    protected $referer = ""; //레퍼러정보
    protected $user_agent = ""; //user-agent 정보

    protected $is_debug = false;
    protected $debug_info = array();
    protected $client = null;
    protected $ssl_options = null;

    protected $status = null;

    protected $delivery_info = array(); //배송기본정보
    protected $delivery_product_info = array(); //배송물품정보
    protected $delivery_history = array(); //배송상세정보

    public function __construct($invoice_no = null)
    {
        if($invoice_no) {
            $this->url =  sprintf($this->url_pattern, $invoice_no) ;
        }

        $this->delivery_info['complete_yn'] = "N";
    }

    public function getDeliveryInfo($tracking_no = null) {
        if($tracking_no) {
            $this->url =  sprintf($this->url_pattern, $tracking_no) ;
        }

        try {
            $this->parsingDeliverInfo($this->url);
        } catch(Exception $e) {
            //echo $e->getMessage();
            //todo 송장정보 오류를 로깅
        }

        $result = array(
            "delivery_info" => $this->delivery_info
           , "delivery_product_info" => $this->delivery_product_info
           , "delivery_history" => $this->delivery_history
        );

        return $result;
    }

    private function parsingDeliverInfo($url) {

        $ssl_options = null;
        $url_info = parse_url($url);

        //https 접속시 ssl 오류가 발생하면, ['verify' => false] 옵션을 추가한다.
        if(strtolower($url_info['scheme']) == "https") {
            $ssl_options  = ['verify' => false];
        }

        $client = new Client();

        $request = $client->request('GET', $url, $ssl_options);
        $html = $request->getBody()->getContents();

        preg_match_all('/<table.*?>(.*?)<\/table>/sxi', $html, $matches);

        //echo "<xmp>";
        //print_r($matches);
        //echo "</xmp>";

        //유효한 배송정보인지 체크
        if($this->isPendingOrInvalidInvoice($matches[0][1])) {
            $this->delivery_info['step'] = "-1";
            throw new Exception("배송 정보가 아직 입력되지 않았거나 처리 중입니다.", 500);
        }

        $crawler = new Crawler($matches[0][0]); //기본 태그들이 깨져서, 테이블 태그만 쪼개서 생성

        $rows = $crawler->filter("table tr")->eq(1)->filter("td")->each(function($node, $i) {
            return str_replace("<br>", "\n", trim($node->html()));
        });

        if(count($rows) == 5) {
            $this->delivery_info['invoice_no'] = $rows[0];

            $this->delivery_info['sender'] = $rows[1];
            $this->delivery_info['send_datetime'] = "";

            $this->delivery_info['receiver'] = $rows[2];
            $this->delivery_info['receive_datetime'] = "";

            $this->delivery_info['gubun'] = "";
            $this->delivery_info['status'] = "";

            $this->delivery_product_info['item_name'] = $rows[3];
            $this->delivery_product_info['item_qty'] = $rows[4];

            if($this->delivery_info['status'] == "") { //기본정보에서 배송상태를 확인하지 못한다면, 다른 정보에서 조회
                $this->delivery_info['status']  = $this->parsingDeliverStatus($matches[0][1]);
            }

            //배송완료여부를 판단함.
            if($this->delivery_info['status'] == "배달완료"
                || $this->delivery_info['status'] == "배송완료"
                || $this->delivery_info['status'] == "완료") {
                $this->delivery_info['complete_yn'] = "Y";
            } else {
                $this->delivery_info['complete_yn'] = "N";
            }

            //배송업체별로 상태정보가 다름으로, 공통으로 사용할수 있는 배송 단계정보로 보정처리한다.
            switch($this->delivery_info['status']) {
                case "상품인수" :
                    $this->delivery_info['step'] = "2";
                    break;

                case "상품이동중" :
                    $this->delivery_info['step'] = "3";
                    break;

                case "배달지도착" :
                    $this->delivery_info['step'] = "4";
                    break;

                case "배달준비" :
                    $this->delivery_info['step'] = "5";
                    break;

                case "배달출발" :
                    $this->delivery_info['step'] = "5";
                    break;

                case "배달완료" :
                    $this->delivery_info['step'] = "6";
                    break;

                default :
                    $this->delivery_info['step']  = "1";
                    break;
            }

            try {
                $this->parsingDeliverDetail($matches[0][1]);
            } catch(Exception $e) {
                echo $e->getMessage();
            }

        } else {

            throw new Exception("배송정보 오류");
        }
    }

    /**
     * 마지막 배송상태를 파싱한다.
     * @param $html
     * @return string
     */
    private function parsingDeliverStatus($html) {
        $crawler = new Crawler($html);
        try {
            $last_status = $crawler->filter("table tr")->last()->filter("td")->eq(0)->text();
            $last_status = trim(html_entity_decode($last_status), " \t\n\r\0\x0B\xC2\xA0");
        } catch(Exception $e) {
            echo $e->getMessage();
        }
        return $last_status;
    }

    /**
     * @param $html
     *  * part3 배송 상세 delivery_detail (array)
     * 날짜/시간    d_datetime
     * 현재위치     d_location
     * 처리현황     d_status
     * 담당자명     d_person
     * 담당자 연락처 d_person_telno
     * 수령인정보  d_recipient
     * 비고  : d_etc
     */
    private function parsingDeliverDetail($html) {

        $crawler = new Crawler($html); //기본 태그들이 깨져서, 테이블 태그만 쪼개서 생성
        $rows = $crawler->filter("table tr")->each(function($node, $i) {
            if($i == 0) return; //첫 row는 제목이라서 제외함.
            $row = array();
            $status = $node->filter("td")->eq(0)->text();
            $datetime = $node->filter("td")->eq(1)->text();

            $row['d_status'] = trim($status);
            $row['d_datetime'] = trim($datetime);

            $row['d_location'] = trim($node->filter("td")->eq(3)->text());
            $row['d_etc'] = trim($node->filter("td")->eq(2)->text());
            $temp = explode("<br>", trim($node->filter("td")->eq(2)->html()));

            $row['d_etc'] = $temp[0];
            $pattern = '/\((배달예정|배달출발|배달담당|담당사원):(.*)\s+([0-9-]+)\)$/';

            if($temp[1]) {
                preg_match($pattern, $temp[1], $matches, PREG_OFFSET_CAPTURE);
                $row['d_person'] = $matches[2] ? $matches[2][0] : "";
                $row['d_person_telno'] = $matches[3] ? $matches[3][0] : "";
            }

            return $row;
        });

        $this->delivery_history = array_merge(array_filter($rows), array());
    }

    /**
     * 배송 송장이 접수되지 않거나, 잘못된 배송 송장 인지 체크
     * @param $html
     * @return bool  true : 잘못된 배송송장 정보, false : 정상
     */
    protected function isPendingOrInvalidInvoice($html) {
        //cj경우 잘못된 정보인경우 아래 메세지가 들어감.
        //조회된 데이터가 없습니다.
        //운송장이 등록되지 않았거나 업체에서 상품을 준비중이니 업체로 문의해주시기 바랍니다.

        if(!$html) return true;

        if(strpos($html, "조회된 데이터가 없습니다") > 0) {
            return true;
        }

        return false;
    }

    protected function isDeliveryComplete() {

    }

}