<?php

require_once '../vendor/autoload.php';

use Delivery\CJParser;


set_time_limit(120); //최대 실행시간은 2분으로
ini_set('display_errors', 'On');
error_reporting(E_ALL & ~E_NOTICE);


//파싱된 데이타 구조
/**
 * 배송 관련
 * part1 배송 기본정보 delivery_info
 * 택배사     company_name
 * 택배사 코드 comapny_id
 * 운송장번호  invoice_no
 * 주문번호    order_no
 * 발송인      sender
 * 발송전화번호 sender_telno
 * 주소        receiver_addr
 * 수취인      receiver
 * 수취전화번호   receiver_telno
 * 상태      status
 * 배송 진행상태   step 1: 배송준비중, 2:집하완료, 3:배송중, 4: 지점도착, 5: 배송출발, 6:배송완료
 *  STEP1 접수 STEP2 상품이동중 STEP3 배달지도착 STEP4 배달준비 STEP5 배달완료
 * 배송 완료여부  complete_yn
 * 배송예정 시간 estimate_time
 *
 * part2 delivery_product 배송 품목정보
 * 품명   item_name
 * 수량   item_qty
 * 브랜드  item_brand
 *
 * part3 배송 상세 delivery_history (array)
 * 날짜/시간    d_datetime
 * 현재위치     d_location
 * 처리현황     d_status
 * 담당자명     d_person
 * 담당자 연락처 d_person_telno
 * 수령인      d_recipient
 * 비고        d_etc
 */

//todo 주문서에 해당하는 배송정보를 가져와 배송상태를 확인한다.
//배송이 완료된건이면, 배송정보를 파싱하지 않는다.


$delivery = new CJParser();
$invoice_no = "123456789012"; //cj대한통운 운송장번호


$result = $delivery->getDeliveryInfo($invoice_no);

if($result['delivery_info']['step'] == "-1") { //배송정보 오류
    echo "운송장이 등록되지 않았거나 업체에서 상품을 준비중입니다.";
}

//todo 파싱된 배송정보를 db에 insert/update 처리한다.
//마지막 파싱 시간을 기록하여, 파싱이 너무 자주 실행되지 않도록 한다.
//너무 자주 실행하면 IP 차단 당할수 있음으로 realtime 파싱보다는 배치 처리하도록 한다.

echo "<xmp>";
print_r($result);
echo "</xmp>";

?>
