<?php

/*
===========================================================

  프로젝트 이름 : Piree WON Program

  만든사람 : 피리

  홈페이지 : http://www.piree.co.kr

  작성날짜 :

  저 작 권 : Copyright ⓒ 2014 투스포츠 (원병철) All right reserved
				      그누보드 외에 추가된 소스는~
				      만든사람의 허락없이 무단으로 사용할수 없습니다.
				      사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
				      http://www.piree.co.kr 에 문의해 주세요.

===========================================================
 관리자 > 피리 > 피리 레벨 도우미 FREE G5 > 처음
===========================================================


*/


  #########################################################
  # 시작 => 선_처리__메뉴_지정__관리자_확인
  #########################################################

  //=======================================================
  // 메뉴_번호__지정____레벨_도우미
  $sub_menu = "760002";


  //=======================================================
  // 기본처리_화일__첨부
  include_once("./_common.php");


  //=======================================================
  // 관리자_확인
  auth_check($auth[$sub_menu], "r");

  #########################################################
  # 끝 => 선_처리
  #########################################################



  #########################################################
  # 시작 => 레벨__설정_정보_화일__첨부
  #########################################################

  //=======================================================
  // 기본_설정_첨부__여부
  // 0 - 안해
  $is_get__piree_config = 0;


  //=======================================================
  // 레벨__설정_정보__가져오기
  $is_get__level_helper = 1;


  //=======================================================
  // 레벨__설정_정보_화일__경로
  $piree_dir_path = PIREE_CONFIG_PATH ."/p__".$sub_menu."/pi__config.php";


  //=======================================================
  // 레벨__설정_정보_화일__경로
  include_once($piree_dir_path);

  #########################################################
  # 끝 => 레벨__설정_정보_화일__첨부
  #########################################################



  #########################################################
  # 시작 => 상수__변수
  #########################################################

  //=======================================================
  // 레벨__설정_정보__건수
  $level_config_t = 0;


  //=======================================================
  // 레벨__설정_정보__배열
  $level_config_arr = array();

  #########################################################
  # 끝 => 상수__변수
  #########################################################



  #########################################################
  # 시작 => 레벨__설정_정보__가져오기
  #########################################################

  //=======================================================
  // 레벨__설정_정보__가져오는__쿼리문
  $sql   = "SELECT COUNT(*) FROM `".$piree_table['level_config']."`";
  $exist = sql_efv($sql);


  //=======================================================
  // 시작 => 레벨__설정_정보__없으면
  IF (!$exist || $exist < 1)
  {

    // 에러
    alert ("회원 정보 레벨을 입력하지 못했습니다.", "./index.php");
    EXIT;

  }
  // 끝 => 레벨__설정_정보__없으면
  //=======================================================

  #########################################################
  # 끝 => 레벨__설정_정보__가져오기
  #########################################################



  #########################################################
  # 시작 => 레벨__설정_정보__불러오기
  #########################################################

  //=======================================================
  // 레벨__설정_정보__불러오기
  $sql    = "SELECT * FROM `".$piree_table['level_config']."` ORDER BY level_n ASC";
  $result = sql_query($sql);


  //=======================================================
  // 시작 => 반복문__돌리기
  FOR ($i=0; $row=sql_fetch_array($result); $i++)
  {

    //=====================================================
    // 배열_복사
    $level_config_arr[] = $row;


    //=====================================================
    // 레벨__설정_정보__건수
    $level_config_t++;

  }
  // 끝 => 반복문__돌리기
  //=======================================================

  #########################################################
  # 끝 => 레벨__설정_정보__불러오기
  #########################################################



  #########################################################
  # 시작 => 마무리__페이지_ECHO_관련
  #########################################################

  //=======================================================
  // 타이틀
  $g5["title"] = "피리 레벨 도우미 FREE G5";


  //=======================================================
  // HEAD_첨부
  include_once ("../admin.head.php");

  #########################################################
  # 끝 => 마무리__페이지_ECHO_관련
  #########################################################


?>

<section>
    <h2>레벨 정보 수정하기</h2>

    <form name="level_list" id="level_list" action="./pi__level.update.php" onsubmit="return level_list_submit(this);" method="post">

    <div class="tbl_head01 tbl_wrap">
				<table>
				<caption>☞ 피리 피리 레벨 도우미 FREE G5</caption>
				<thead>
				<tr>
				    <th scope="col">
				      <label for="chkall" class="sound_only">레벨 전체</label>
				      <input type="checkbox" name="chkall" value="1" id="chkall" onclick="check_all(this.form)">
				    </th>
				    <th scope="col">레벨 번호</th>
				    <th scope="col">레벨 이름</th>
				    <th scope="col">즉시등업</th>
				    <th scope="col">포인트 점수</th>
				    <th scope="col">게시글 건수</th>
				    <th scope="col">댓글 건수</th>
				    <th scope="col">로그인 회수</th>
				    <th scope="col">가입후 일수</th>
				    <th scope="col">전 레벨 일수</th>
				    <th scope="col">등록일시</th>
				</tr>
				</thead>
				<tbody>

<?php

    //=====================================================
    // 시작 => 레벨__설정_정보__유무
    IF ($level_config_t > 0)
    {

      #####################################################
      # 시작 => 레벨__설정_정보__있으면
      #####################################################

      //===================================================
      // 시작 => 반복문__돌리기
      WHILE (list($key, $val) = each($level_config_arr))
      {

				//=================================================
				// 레벨_번호
				$level_n = $val["level_n"];


				//=================================================
				// 포인트_점수
				$point_fm = number_format($val["point_n"]);


				//=================================================
				// 즉시등업__가능_여부
				$use_auto_s = $val["use_auto_n"] == 1 ? "가능" : "불가";


				//=================================================
				// 등록일시
				$regdate_s = date("y.m.d", $val["regi_time_n"]);

?>
				<tr>
				    <td class="td_chk">
				      <label for="chk_<?php echo $level_n; ?>" class="sound_only"><?php echo get_text($val["level_s"]) ?></label>
				      <input type="checkbox" name="chk[]" value="<?php echo $level_n ?>" id="chk_<?php echo $level_n ?>">
				    </td>
				    <td align="center"><strong><?php echo $level_n ?></strong></td>
				    <td align="center">
				      <label for="level_s_<?php echo $level_n; ?>" class="sound_only">회원 레벨 이름</label>
				      <input type="text" name="level_s[<?php echo $level_n ?>]" value="<?php echo $val["level_s"] ?>" id="level_s_<?php echo $level_n; ?>" class="frm_input" size="15"> 점
				    </td>
				    <td align="center"><?php echo $use_auto_s; ?></td>
<?php

				  //===============================================
				  // 시작 => 관리자__여부
				  IF ($val["is_admin_n"] == 1)
				  {

				    ###############################################
				    # 시작 => 관리자__이면
				    ###############################################

?>
				    <td class="no_use">×</td>
<?php
				  }
				  ELSE
				  {

				    ###############################################
				    # 시작 => 관리자__아니면
				    ###############################################

?>
				    <td align="center">
				      <label for="point_n_<?php echo $level_n; ?>" class="sound_only">기준 포인트 점수</label>
				      <input type="text" name="point_n[<?php echo $level_n ?>]" value="<?php echo $point_fm ?>" id="point_n_<?php echo $level_n; ?>" class="frm_input" size="10"> 점
				    </td>
<?php
				  }
				  // 끝 => 관리자__여부
				  //===============================================

?>
				    <td class="no_use">×</td>
				    <td class="no_use">×</td>
				    <td class="no_use">×</td>
				    <td class="no_use">×</td>
				    <td class="no_use">×</td>
				    <td class="td_date"><?php echo $regdate_s ?></td>
				</tr>

<?php
      }
      // 끝 => 반복문__돌리기
      //===================================================

      #####################################################
      # 끝 => 레벨__설정_정보__있으면
      #####################################################

    }
    ELSE
    {

      #####################################################
      # 시작 => 레벨__설정_정보__없으면
      #####################################################

?>
				<tr>
				  <td colspan="9">
				    <strong>현재 레벨 정보가 없습니다.</strong>
				  </td>
				</tr>

<?php

      #####################################################
      # 끝 => 레벨__설정_정보__없으면
      #####################################################

    }
    // 끝 => 레벨__설정_정보__유무
    //=====================================================

?>

				</tbody>
				</table>
    </div>

    <div class="btn_list01 btn_list">
      <input type="submit" name="act_button" value="선택수정" onclick="document.pressed=this.value">
    </div>

    </form>


    <div class="btn_confirm">
      <input type="button" class="btn_cancel" value=" 설정 정보 수정하기 " onClick="PageUrl('./pi__config.form.php')"> 
    </div>

</section>


<script>

function level_list_submit(f)
{

    if (!is_checked("chk[]"))
    {
      alert(document.pressed+" 하실 항목을 하나 이상 선택하세요.");
      return false;
    }

    if(document.pressed == "선택삭제")
    {
      if(!confirm("선택한 자료를 정말 삭제하시겠습니까?"))
      {
				return false;
      }
    }

    return true;
}
</script>


<?php

  //=======================================================
  // ADMIN_TAIL__첨부
  include_once ('../admin.tail.php');

?>