# XLOG — 회원 활동 모니터링 플러그인 (GnuBoard 5)

회원의 로그인/실패/로그아웃/회원정보수정, 게시글·댓글 CRUD, 페이지 접속을 기록하고, 관리자에서 열람·삭제하며 감사 이력까지 남깁니다.

## 설치 (간단)

1. **파일 업로드**

   * `/extend/xlog.extend.php` 업로드
   * `/adm/xlog_login.php`, `/adm/xlog_content.php`, `/adm/xlog_page.php`, `/adm/xlog_settings.php`, `/adm/xlog_audit.php` 업로드
   * `/adm/admin.menu700.php`에 **메뉴 항목**이 포함되어 있어야 합니다. (동봉 파일 사용 권장)

2. **최초 실행 (자동 DB 스키마 생성)**

   * 관리자에 접속 후, 좌측 **활동 로그** 메뉴 중 아무 페이지나 1번 열면 테이블이 자동 생성됩니다.
     (생성 테이블: `g5_activity_log`, `g5_activity_audit`, `g5_activity_conf`)

3. **권한 부여**

   * 관리자 > **메뉴 권한설정**에서 다음 키에 권한을 주세요.

     * `700900` 로그인/회원
     * `700901` 게시글/댓글
     * `700902` 페이지 접속
     * `700903` 보관/제한 설정
     * `700990` 감사(열람·삭제 이력)
   * **읽기(r)**: 목록 열람, **쓰기(w)**: 설정 변경, **삭제(d)**: 선택 삭제 버튼 표시/실행
   * 감사 페이지(`700990`)는 **최고관리자만 접근** 가능 + 권한 체크 동시 적용.

4. **환경설정**

   * **활동 로그 > 보관/제한 설정**에서

     * 보관기간(일), 최대 행수(회전), 관리자페이지 접속도 기록, **로그 타입별 ON/OFF** 를 설정하세요.

---

## 주의/팁

* **관리자 CSS가 깨지는 경우**
  `xlog_*` 관리자 파일은 **반드시 `/adm/_common.php`** 를 include 해야 합니다. (동봉 파일은 이미 그렇게 되어 있습니다.)

* **메뉴가 안 뜰 때**
  `admin.menu700.php`에서 `array('700000','활동 로그', **링크**, 'xlog_login')`처럼 **3번째 인자(링크)가 비어 있으면 안 됩니다.**
  또한 각 하위 메뉴도 링크가 비어 있으면 노출되지 않습니다.

* **중간관리자에게 ‘선택삭제’ 버튼이 안 보일 때**
  해당 메뉴키의 **삭제(d) 권한**이 실제로 부여되어 있는지 확인하세요.
  버튼 노출 로직은 `super`이거나, `auth_check_menu(...,'d', true)`가 true이거나, `$auth[$sub_menu]`에 `d`가 포함되면 표시됩니다.

* **DB/엔진 호환**

  * 지원: **MySQL/MariaDB 계열** (그누보드5 기본 가정)
  * 테이블 생성은 **기본 스토리지 엔진**을 따르며, `JSON` 타입 대신 **LONGTEXT**를 사용해 **구버전 호환**됩니다.
  * 다른 DBMS(PostgreSQL 등)는 지원하지 않습니다.

* **개인정보 주의**

  * 저장 항목: 시각, 회원ID, 유형, 게시판/글ID, URI, IP, User-Agent, referer(페이지뷰), 최소한의 추가 힌트.
  * **원문 본문/댓글 내용, 수정 전후 값**은 기본 저장하지 않습니다.
  * 필요한 경우 보관기간/최대행수로 회전 설정을 적용하세요.

* **회원정보 수정 로그**

  * 회원 테이블(`$g5['member_table']`)에 대한 **UPDATE가 발생하면 1회** `member_update` 로그가 남습니다.
  * 로그인 시 자동 갱신되는 일부 컬럼만 바뀌었을 때 제외하고 싶다면 옵션화를 지원할 수 있으니 이슈로 알려주세요.

* **감사 이력**

  * 각 관리자 페이지 **접속 시 `view`**, 선택삭제 시 **`delete`** 이력이 `g5_activity_audit`에 기록됩니다.
  * 실패 시 `data/xlog_audit_error.log`에 기록합니다(서버 쓰기 권한 필요).

* **OPcache 사용 시**

  * 새 파일 업로드 후 관리자 페이지에 재접속하면 보통 갱신되지만, 환경에 따라 **OPcache 리셋**이 필요할 수 있습니다.

---

## 호환성 / 업그레이드 / 제거

* **호환성**: GnuBoard 5.6.x 환경에서 확인. (그 외 버전도 대체로 호환되지만, 커스텀 테마/훅에 따라 조정이 필요할 수 있음)
* **업그레이드**: 파일 **덮어쓰기**만 하면 됩니다. 스키마는 자동 보정(누락 컬럼/인덱스 추가).
* **제거**: `/extend/xlog.extend.php`, `/adm/xlog_*.php`, 메뉴 등록을 삭제하세요.
  데이터까지 지우려면 테이블 `g5_activity_log`, `g5_activity_audit`, `g5_activity_conf`를 삭제하세요.

---

## 포함 관리자 메뉴

* **활동 로그(로그인/회원)**: `xlog_login.php`
* **게시글/댓글 로그**: `xlog_content.php` (제목·바로가기·CSV 내보내기, 선택삭제)
* **페이지 접속 로그**: `xlog_page.php`
* **보관/제한 설정**: `xlog_settings.php`
* **로그 열람·삭제 이력(감사)**: `xlog_audit.php` (최고관리자 전용)

---
