<?php
include_once('./_common.php');

$sub_menu = '700901';
auth_check_menu($auth, $sub_menu, 'r');

$g5['title'] = '활동 로그 - 게시글/댓글';
include_once(G5_ADMIN_PATH.'/admin.head.php');

$__ip_hex = bin2hex(@inet_pton($_SERVER['REMOTE_ADDR'] ?? '0.0.0.0'));
xlog_audit('view', 'xlog_content', $_GET ?? null, 0);

$can_delete = ($is_admin === 'super') || auth_check_menu($auth, $sub_menu, 'd', true) ||
              (isset($auth[$sub_menu]) && (
                   (is_array($auth[$sub_menu]) && !empty($auth[$sub_menu]['d'])) ||
                   (is_string($auth[$sub_menu]) && strpos($auth[$sub_menu], 'd') !== false)
              ));

if ($_SERVER['REQUEST_METHOD']==='POST' && (($_POST['act'] ?? '')==='bulk_delete')) {
  auth_check_menu($auth, $sub_menu, 'd');
  check_admin_token();
  $ids = array_map('intval', $_POST['ids'] ?? array());
  $cnt = 0;
  if ($ids) {
    $in = implode(',', $ids);
    $cnt = (int)sql_fetch("SELECT COUNT(*) AS c FROM g5_activity_log WHERE id IN ({$in})")['c'];

    xlog_audit('delete', 'xlog_content', array('ids'=>$ids), (int)$cnt);

    sql_query("DELETE FROM g5_activity_log WHERE id IN ({$in})");
  }
  alert('삭제되었습니다.', G5_ADMIN_URL.'/xlog_content.php');
}

$mb_id    = trim($_GET['mb_id'] ?? '');
$bo_table = trim($_GET['bo_table'] ?? '');
$types    = $_GET['types'] ?? array();
$sdate    = trim($_GET['sdate'] ?? '');
$edate    = trim($_GET['edate'] ?? '');

$where = "act_type IN ('post_write','post_edit','post_delete','comment_write','comment_edit','comment_delete')";
if ($mb_id)    $where .= " AND mb_id = '".sql_real_escape_string($mb_id)."'";
if ($bo_table) $where .= " AND bo_table = '".sql_real_escape_string($bo_table)."'";
if ($types && is_array($types)) {
  $safe = array();
  foreach ($types as $t) $safe[] = "'".sql_real_escape_string($t)."'";
  if ($safe) $where .= " AND act_type IN (".implode(',', $safe).")";
}
if ($sdate) $where .= " AND created_at >= '".sql_real_escape_string($sdate)." 00:00:00'";
if ($edate) $where .= " AND created_at <= '".sql_real_escape_string($edate)." 23:59:59'";

if (isset($_GET['export']) && $_GET['export']==='csv') {
  header('Content-Type: text/csv; charset=UTF-8');
  header('Content-Disposition: attachment; filename="xlog_content_'.date('Ymd_His').'.csv"');
  echo "\xEF\xBB\xBF";
  $out = fopen('php://output', 'w');
  fputcsv($out, array('id','created_at','mb_id','act_type','bo_table','wr_id','cm_id','ip','ua'));
  $q = sql_query("SELECT * FROM g5_activity_log WHERE {$where} ORDER BY id DESC");
  while($r = sql_fetch_array($q)) {
    $ip = xlog_ip_text($r['ip']);
    fputcsv($out, array($r['id'],$r['created_at'],$r['mb_id'],$r['act_type'],$r['bo_table'],$r['wr_id'],$r['cm_id'],$ip,$r['user_agent']));
  }
  fclose($out);
  exit;
}

$page = max(1, (int)($_GET['page'] ?? 1)); $rows=50; $from=($page-1)*$rows;
$total = sql_fetch("SELECT COUNT(*) AS cnt FROM g5_activity_log WHERE {$where}")['cnt'];
$q = sql_query("SELECT * FROM g5_activity_log WHERE {$where} ORDER BY id DESC LIMIT {$from}, {$rows}");

$all_types = array('post_write','post_edit','post_delete','comment_write','comment_edit','comment_delete');
?>
<div class="local_ov01 local_ov">
  <form method="get">
    <label>회원</label>
    <input type="text" name="mb_id" value="<?php echo get_sanitize_input($mb_id); ?>" class="frm_input">
    <label>게시판</label>
    <input type="text" name="bo_table" value="<?php echo get_sanitize_input($bo_table); ?>" class="frm_input">
    <label>기간</label>
    <input type="date" name="sdate" value="<?php echo get_sanitize_input($sdate); ?>">
    ~
    <input type="date" name="edate" value="<?php echo get_sanitize_input($edate); ?>">
    <label>유형</label>
    <?php foreach ($all_types as $t): $ck = in_array($t, (array)$types) ? 'checked' : ''; ?>
      <label style="margin-left:6px"><input type="checkbox" name="types[]" value="<?php echo $t; ?>" <?php echo $ck; ?>> <?php echo $t; ?></label>
    <?php endforeach; ?>
    <button class="btn btn_02">검색</button>
    <a class="btn btn_01" href="<?php echo G5_ADMIN_URL.'/xlog_content.php?'.http_build_query(array_merge($_GET,array('export'=>'csv'))); ?>">CSV</a>
  </form>
</div>

<form method="post">
<input type="hidden" name="act" value="bulk_delete">
<input type="hidden" name="token" value="<?php echo get_admin_token(); ?>">
<div class="tbl_head01 tbl_wrap">
  <table>
    <thead>
      <tr>
        <th><input type="checkbox" onclick="var c=document.querySelectorAll('.xchk'); for(var i=0;i<c.length;i++) c[i].checked=this.checked;"></th>
        <th>시각</th><th>회원</th><th>유형</th><th>게시판</th><th>WR</th><th>제목</th><th>바로가기</th><th>IP</th>
      </tr>
    </thead>
    <tbody>
      <?php for($i=0; $r=sql_fetch_array($q); $i++): ?>
      <?php
        $subject = '-'; $url = ''; $exists = false;
        if ($r['bo_table']) {
          $write_table = $g5['write_prefix'].$r['bo_table'];
          if (in_array($r['act_type'], array('post_write','post_edit','post_delete'))) {
            $wr = sql_fetch("SELECT wr_subject FROM {$write_table} WHERE wr_id=".(int)$r['wr_id']);
            if ($wr && isset($wr['wr_subject'])) { $exists=true; $subject = cut_str(get_text($wr['wr_subject']),60); }
            $url = G5_BBS_URL.'/board.php?bo_table='.urlencode($r['bo_table']).'&wr_id='.(int)$r['wr_id'];
          } else {
            $parent = sql_fetch("SELECT wr_subject FROM {$write_table} WHERE wr_id=".(int)$r['wr_id']);
            if ($parent && isset($parent['wr_subject'])) { $exists=true; $subject = cut_str(get_text($parent['wr_subject']),60); }
            $anchor = $r['cm_id'] ? ('#c_'.(int)$r['cm_id']) : '';
            $url = G5_BBS_URL.'/board.php?bo_table='.urlencode($r['bo_table']).'&wr_id='.(int)$r['wr_id'].$anchor;
          }
        }
      ?>
      <tr>
        <td><input type="checkbox" class="xchk" name="ids[]" value="<?php echo (int)$r['id']; ?>"></td>
        <td><?php echo $r['created_at']; ?></td>
        <td><?php echo get_text($r['mb_id']); ?></td>
        <td><?php echo $r['act_type']; ?></td>
        <td><?php echo get_text($r['bo_table']); ?></td>
        <td><?php echo (int)$r['wr_id']; ?></td>
        <td class="td_ellips">
          <?php echo $exists ? '<a target="_blank" href="'.$url.'">'.$subject.'</a>' : $subject; ?>
        </td>
        <td>
          <?php if($url && $exists): ?>
            <a class="btn btn_03" target="_blank" href="<?php echo $url; ?>">열기</a>
          <?php else: ?>
            <span class="btn btn_02 disabled">없음</span>
          <?php endif; ?>
        </td>
        <td><?php echo xlog_ip_text($r['ip']); ?></td>
      </tr>
      <?php endfor; if(!$i): ?>
      <tr><td colspan="9" class="empty_table">자료가 없습니다.</td></tr>
      <?php endif; ?>
    </tbody>
  </table>
</div>
<div class="btn_fixed_top">
  <?php if ($can_delete) : ?>
    <button class="btn btn_02" onclick="return confirm('선택 항목을 삭제할까요?')">선택삭제</button>
  <?php endif; ?>
</div>
</form>

<?php
echo get_paging(10, $page, ceil($total/$rows), G5_ADMIN_URL.'/xlog_content.php?'.http_build_query($_GET).'&amp;page=');
include_once(G5_ADMIN_PATH.'/admin.tail.php');
