<?php
include_once('./_common.php');

$sub_menu = '700900';
auth_check_menu($auth, $sub_menu, 'r');

$g5['title'] = '활동 로그 - 로그인/회원';
include_once(G5_ADMIN_PATH.'/admin.head.php');

$__ip_hex = bin2hex(@inet_pton($_SERVER['REMOTE_ADDR'] ?? '0.0.0.0'));
xlog_audit('view', 'xlog_login', $_GET ?? null, 0);

$mb_id = trim($_GET['mb_id'] ?? '');
$where = "act_type IN ('login','login_fail','logout','member_update')";
if ($mb_id) $where .= " AND mb_id = '".sql_real_escape_string($mb_id)."'";

$page = max(1, (int)($_GET['page'] ?? 1));
$rows = 50; $from = ($page-1)*$rows;

$total = sql_fetch("SELECT COUNT(*) AS cnt FROM g5_activity_log WHERE {$where}")['cnt'];
$qry = sql_query("SELECT * FROM g5_activity_log WHERE {$where} ORDER BY id DESC LIMIT {$from}, {$rows}");
?>
<div class="local_ov01 local_ov">
  <form method="get" class="xlog-filter">
    <label>회원아이디</label>
    <input type="text" name="mb_id" value="<?php echo get_sanitize_input($mb_id); ?>" class="frm_input">
    <button class="btn btn_02">검색</button>
  </form>
</div>

<div class="tbl_head01 tbl_wrap">
  <table>
    <thead>
      <tr>
        <th>시각</th><th>회원</th><th>유형</th><th>IP</th><th>UA</th><th>비고</th>
      </tr>
    </thead>
    <tbody>
      <?php for($i=0; $row=sql_fetch_array($qry); $i++): ?>
      <tr>
        <td><?php echo $row['created_at']; ?></td>
        <td><?php echo get_text($row['mb_id']); ?></td>
        <td><?php echo $row['act_type']; ?></td>
        <td><?php echo xlog_ip_text($row['ip']); ?></td>
        <td class="td_ellips"><?php echo get_text($row['user_agent']); ?></td>
        <td><?php echo get_text($row['result']); ?></td>
      </tr>
      <?php endfor; if(!$i): ?>
      <tr><td colspan="6" class="empty_table">자료가 없습니다.</td></tr>
      <?php endif; ?>
    </tbody>
  </table>
</div>
<?php
echo get_paging(G5_IS_MOBILE ? 3 : 10, $page, ceil($total/$rows), G5_ADMIN_URL.'/xlog_login.php?mb_id='.urlencode($mb_id).'&amp;page=');
include_once(G5_ADMIN_PATH.'/admin.tail.php');
