<?php
include_once('./_common.php');

$sub_menu = '700903';
auth_check_menu($auth, $sub_menu, 'w');

$g5['title'] = '활동 로그 - 보관/제한 설정';
include_once(G5_ADMIN_PATH.'/admin.head.php');

$__ip_hex = bin2hex(@inet_pton($_SERVER['REMOTE_ADDR'] ?? '0.0.0.0'));
xlog_audit('view', 'xlog_settings', $_GET ?? null, 0);

if ($_SERVER['REQUEST_METHOD']==='POST') {
    check_admin_token();
    xlog_opt_set('retain_days', max(0, (int)$_POST['retain_days']));
    xlog_opt_set('max_rows',   max(0, (int)$_POST['max_rows']));
    xlog_opt_set('log_admin_pages', isset($_POST['log_admin_pages']) ? 1 : 0);
    $types = array('login','login_fail','logout','member_update','post_write','post_edit','post_delete','comment_write','comment_edit','comment_delete','page_view');
    foreach ($types as $t) xlog_opt_set('enable_'.$t, isset($_POST['enable'][$t]) ? 1 : 0);

    sql_query("INSERT INTO g5_activity_audit (created_at,admin_id,action,target_menu_key,filter,affected_count,ip,user_agent)
    VALUES (NOW(), '".sql_real_escape_string($member['mb_id'])."', 'view', 'xlog_settings',
    '".sql_real_escape_string(json_encode($_POST, JSON_UNESCAPED_UNICODE))."', 0,
    UNHEX('{$__ip_hex}'), '".sql_real_escape_string(substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 255))."'))");

    alert('저장되었습니다.', G5_ADMIN_URL.'/xlog_settings.php');
}

$conf = xlog_conf();
?>
<form method="post">
<input type="hidden" name="token" value="<?php echo get_admin_token(); ?>">
<div class="tbl_frm01 tbl_wrap">
  <table>
    <tr>
      <th>보관 기간(일)</th>
      <td><input type="number" name="retain_days" value="<?php echo $conf['retain_days']; ?>" class="frm_input" min="0"> (0=무제한)</td>
    </tr>
    <tr>
      <th>최대 행수</th>
      <td><input type="number" name="max_rows" value="<?php echo $conf['max_rows']; ?>" class="frm_input" min="0"> (0=무제한)</td>
    </tr>
    <tr>
      <th>관리자페이지 접속도 기록</th>
      <td><label><input type="checkbox" name="log_admin_pages" value="1" <?php echo $conf['log_admin_pages']?'checked':''; ?>> 사용</label></td>
    </tr>
    <tr>
      <th>기록 활성화 (타입별)</th>
      <td>
        <?php
          $groups = array(
            '회원'   => array('login','login_fail','logout','member_update'),
            '게시글' => array('post_write','post_edit','post_delete'),
            '댓글'   => array('comment_write','comment_edit','comment_delete'),
            '기타'   => array('page_view')
          );
          foreach ($groups as $label=>$arr) {
            echo '<fieldset style="margin-bottom:8px"><legend>'.$label.'</legend>';
            foreach ($arr as $t) {
              $ck = !empty($conf['enable'][$t]) ? 'checked' : '';
              echo '<label style="margin-right:10px"><input type="checkbox" name="enable['.$t.']" value="1" '.$ck.'> '.$t.'</label>';
            }
            echo '</fieldset>';
          }
        ?>
      </td>
    </tr>
  </table>
</div>
<div class="btn_fixed_top">
  <button class="btn btn_submit">저장</button>
</div>
</form>
<?php include_once(G5_ADMIN_PATH.'/admin.tail.php'); ?>
