<?php
if (!defined('_GNUBOARD_')) exit;

/*
 * XLOG - 회원 활동 모니터링 플러그인
 * Version: 1.2.4 (engine-agnostic + robust member_update detection + centralized audit)
 */

if (!defined('XLOG_VERSION')) define('XLOG_VERSION','1.2.4');

/*--------------------------------------------------------------
  DB 헬퍼: 엔진/문자셋을 환경에 맞게 선택
--------------------------------------------------------------*/
if (!function_exists('xlog_db_engine_sql')) {
    function xlog_db_engine_sql() {
        $eng = '';
        $row = sql_fetch("SELECT @@default_storage_engine AS e", false);
        if ($row && !empty($row['e'])) $eng = $row['e'];
        if (!$eng) {
            $row = sql_fetch("SELECT @@storage_engine AS e", false);
            if ($row && !empty($row['e'])) $eng = $row['e'];
        }
        return $eng ? " ENGINE=".$eng : "";
    }
}
if (!function_exists('xlog_db_charset')) {
    function xlog_db_charset() {
        if (defined('G5_DB_CHARSET') && G5_DB_CHARSET) return G5_DB_CHARSET;
        $row = sql_fetch("SELECT @@character_set_server AS cs", false);
        return ($row && !empty($row['cs'])) ? $row['cs'] : 'utf8mb4';
    }
}

/*--------------------------------------------------------------
  설치/스키마 (엔진 강제 X, JSON -> LONGTEXT)
--------------------------------------------------------------*/
if (!function_exists('xlog_install')) {
    function xlog_install() {
        sql_query("CREATE TABLE IF NOT EXISTS g5_activity_log (
            id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            mb_id VARCHAR(20) NOT NULL,
            act_type VARCHAR(32) NOT NULL,
            bo_table VARCHAR(50) DEFAULT NULL,
            wr_id INT DEFAULT NULL,
            cm_id INT DEFAULT NULL,
            uri VARCHAR(255) DEFAULT NULL,
            method VARCHAR(10) DEFAULT NULL,
            ip VARBINARY(16) NOT NULL,
            user_agent VARCHAR(255) DEFAULT NULL,
            referer VARCHAR(255) DEFAULT NULL,
            result VARCHAR(50) DEFAULT NULL,
            extra LONGTEXT NULL
        ) DEFAULT CHARSET=".xlog_db_charset()."".xlog_db_engine_sql()."", false);

        sql_query("CREATE TABLE IF NOT EXISTS g5_activity_audit (
            id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            admin_id VARCHAR(20) NOT NULL,
            action VARCHAR(16) NOT NULL,
            target_menu_key VARCHAR(40) NOT NULL,
            filter LONGTEXT NULL,
            affected_count INT DEFAULT 0,
            ip VARBINARY(16) NOT NULL,
            user_agent VARCHAR(255) DEFAULT NULL
        ) DEFAULT CHARSET=".xlog_db_charset()."".xlog_db_engine_sql()."", false);

        sql_query("CREATE TABLE IF NOT EXISTS g5_activity_conf (
            k VARCHAR(64) PRIMARY KEY,
            v TEXT NOT NULL
        ) DEFAULT CHARSET=".xlog_db_charset()."".xlog_db_engine_sql()."", false);

        // 인덱스
        $idx = sql_fetch("SHOW INDEX FROM g5_activity_log WHERE Key_name='idx_act_created'");
        if (!$idx) sql_query("CREATE INDEX idx_act_created ON g5_activity_log (created_at)");
        $idx = sql_fetch("SHOW INDEX FROM g5_activity_log WHERE Key_name='idx_act_mb'");
        if (!$idx) sql_query("CREATE INDEX idx_act_mb ON g5_activity_log (mb_id, created_at)");
        $idx = sql_fetch("SHOW INDEX FROM g5_activity_log WHERE Key_name='idx_act_type'");
        if (!$idx) sql_query("CREATE INDEX idx_act_type ON g5_activity_log (act_type, created_at)");
        $idx = sql_fetch("SHOW INDEX FROM g5_activity_log WHERE Key_name='idx_act_target'");
        if (!$idx) sql_query("CREATE INDEX idx_act_target ON g5_activity_log (bo_table, wr_id)");

        // 컬럼 보정
        $cols = array();
        $res = sql_query("SHOW COLUMNS FROM g5_activity_log");
        while($c = sql_fetch_array($res)) $cols[$c['Field']] = 1;
        if (empty($cols['cm_id'])) sql_query("ALTER TABLE g5_activity_log ADD COLUMN cm_id INT DEFAULT NULL AFTER wr_id");

        // 기본값
        $defaults = array(
            'retain_days' => '90',
            'max_rows' => '500000',
            'log_admin_pages' => '0',
            'enable_login'=>'1','enable_login_fail'=>'1','enable_logout'=>'1','enable_member_update'=>'1',
            'enable_post_write'=>'1','enable_post_edit'=>'1','enable_post_delete'=>'1',
            'enable_comment_write'=>'1','enable_comment_edit'=>'1','enable_comment_delete'=>'1',
            'enable_page_view'=>'1',
            'installed_version' => XLOG_VERSION
        );
        foreach ($defaults as $k=>$v) {
            sql_query("INSERT IGNORE INTO g5_activity_conf (k,v) VALUES ('".sql_real_escape_string($k)."','".sql_real_escape_string($v)."')");
        }
    }
}
xlog_install();

/*--------------------------------------------------------------
  유틸
--------------------------------------------------------------*/
if (!function_exists('xlog_ip_bin')) {
    function xlog_ip_bin($ip=null) { $ip = $ip ?: ($_SERVER['REMOTE_ADDR'] ?? '0.0.0.0'); return @inet_pton($ip); }
}
if (!function_exists('xlog_ip_text')) {
    function xlog_ip_text($bin) { return $bin ? @inet_ntop($bin) : ''; }
}
if (!function_exists('xlog_now')) {
    function xlog_now() { return date('Y-m-d H:i:s'); }
}
if (!function_exists('xlog_insert')) {
    function xlog_insert($row) {
        $tbl = 'g5_activity_log'; $keys = array(); $vals = array();
        foreach ($row as $k=>$v) {
            $keys[] = $k;
            if (is_null($v)) $vals[] = 'NULL';
            else if ($k === 'ip') $vals[] = "UNHEX('".bin2hex($v)."')";
            else $vals[] = "'".sql_real_escape_string(is_array($v)? json_encode($v, JSON_UNESCAPED_UNICODE) : $v)."'";
        }
        sql_query("INSERT INTO {$tbl} (".implode(',',$keys).") VALUES (".implode(',',$vals).")", false);
    }
}
if (!function_exists('xlog_audit')) {
    function xlog_audit($action, $target_menu_key, $filter=null, $affected=0) {
        global $member;
        // 보장
        sql_query("CREATE TABLE IF NOT EXISTS g5_activity_audit (
            id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            admin_id VARCHAR(20) NOT NULL,
            action VARCHAR(16) NOT NULL,
            target_menu_key VARCHAR(40) NOT NULL,
            filter LONGTEXT NULL,
            affected_count INT DEFAULT 0,
            ip VARBINARY(16) NOT NULL,
            user_agent VARCHAR(255) DEFAULT NULL
        ) DEFAULT CHARSET=".xlog_db_charset()."".xlog_db_engine_sql()."", false);

        $ip_hex = bin2hex(@inet_pton($_SERVER['REMOTE_ADDR'] ?? '0.0.0.0'));
        $fjson = is_null($filter) ? 'NULL' : "'".sql_real_escape_string(is_array($filter) ? json_encode($filter, JSON_UNESCAPED_UNICODE) : (string)$filter)."'";
        $sql = "
            INSERT INTO g5_activity_audit
                (created_at, admin_id, action, target_menu_key, filter, affected_count, ip, user_agent)
            VALUES
                (NOW(), '".sql_real_escape_string($member['mb_id'] ?? '')."', '".sql_real_escape_string($action)."',
                 '".sql_real_escape_string($target_menu_key)."', {$fjson}, ".(int)$affected.",
                 UNHEX('{$ip_hex}'), '".sql_real_escape_string(substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 255))."')";
        $ok = sql_query($sql, false);
        if (!$ok && defined('G5_DATA_PATH')) {
            @file_put_contents(G5_DATA_PATH.'/xlog_audit_error.log', date('c')." FAIL SQL: ".$sql.PHP_EOL, FILE_APPEND);
        }
        return (bool)$ok;
    }
}

// conf helpers
if (!function_exists('xlog_opt_get')) {
    function xlog_opt_get($k, $default=null) {
        $row = sql_fetch("SELECT v FROM g5_activity_conf WHERE k='".sql_real_escape_string($k)."'");
        return ($row && isset($row['v'])) ? $row['v'] : $default;
    }
}
if (!function_exists('xlog_opt_set')) {
    function xlog_opt_set($k, $v) {
        sql_query("INSERT INTO g5_activity_conf (k,v) VALUES ('".sql_real_escape_string($k)."','".sql_real_escape_string($v)."') ON DUPLICATE KEY UPDATE v=VALUES(v)");
    }
}
if (!function_exists('xlog_conf')) {
    function xlog_conf() {
        $en = array('login'=>1,'login_fail'=>1,'logout'=>1,'member_update'=>1,'post_write'=>1,'post_edit'=>1,'post_delete'=>1,'comment_write'=>1,'comment_edit'=>1,'comment_delete'=>1,'page_view'=>1);
        foreach ($en as $k=>$v) $en[$k] = (int) xlog_opt_get('enable_'.$k, $v);
        return array(
            'retain_days' => (int) xlog_opt_get('retain_days', 90),
            'max_rows'    => (int) xlog_opt_get('max_rows', 500000),
            'log_admin_pages' => (int) xlog_opt_get('log_admin_pages', 0),
            'enable' => $en
        );
    }
}
if (!function_exists('xlog_can')) {
    function xlog_can($type) { $c = xlog_conf(); return !empty($c['enable'][$type]); }
}
if (!function_exists('xlog_rotate')) {
    function xlog_rotate() {
        static $done = false; if ($done) return; $done = true;
        $c = xlog_conf();
        if ($c['retain_days'] > 0) sql_query("DELETE FROM g5_activity_log WHERE created_at < DATE_SUB(NOW(), INTERVAL ".(int)$c['retain_days']." DAY)", false);
        if ($c['max_rows'] > 0) {
            $row = sql_fetch("SELECT COUNT(*) AS cnt FROM g5_activity_log");
            $over = (int)$row['cnt'] - (int)$c['max_rows'];
            if ($over > 0) sql_query("DELETE FROM g5_activity_log ORDER BY created_at ASC LIMIT ".(int)$over, false);
        }
    }
}

/*--------------------------------------------------------------
  페이지뷰 (회원만)
--------------------------------------------------------------*/
add_event('common_header', function() {
    global $member;
    xlog_rotate();
    if (!$member['mb_id']) return;
    $conf = xlog_conf();
    $uri = $_SERVER['REQUEST_URI'] ?? '';
    if (!$conf['log_admin_pages'] && strpos($uri, '/adm/') !== false) return;
    if (!xlog_can('page_view')) return;
    if (preg_match('~\.(css|js|png|jpg|jpeg|gif|svg|webp|ico|woff2?)($|\?)~i', $uri)) return;
    xlog_insert(array(
        'created_at' => xlog_now(),
        'mb_id' => $member['mb_id'],
        'act_type' => 'page_view',
        'uri' => substr($uri, 0, 255),
        'method' => $_SERVER['REQUEST_METHOD'] ?? 'GET',
        'ip' => xlog_ip_bin(),
        'user_agent' => substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 255),
        'referer' => substr($_SERVER['HTTP_REFERER'] ?? '', 0, 255),
    ));
});

/*--------------------------------------------------------------
  로그인/로그아웃/실패/회원수정
--------------------------------------------------------------*/
add_event('member_login_check', function($mb, $link, $is_social_login){
    if (!xlog_can('login')) return;
    xlog_insert(array(
        'created_at' => xlog_now(),
        'mb_id' => $mb['mb_id'],
        'act_type' => 'login',
        'result' => $is_social_login ? 'social' : 'local',
        'ip' => xlog_ip_bin(),
        'user_agent' => substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 255),
    ));
}, G5_HOOK_DEFAULT_PRIORITY, 3);

add_event('password_is_wrong', function($type, $data, $qstr=''){
    if (!xlog_can('login_fail')) return;
    $mb_id = '';
    if ($type === 'login' && is_array($data) && isset($data['mb_id'])) $mb_id = $data['mb_id'];
    xlog_insert(array(
        'created_at' => xlog_now(),
        'mb_id' => $mb_id ?: 'unknown',
        'act_type' => 'login_fail',
        'result' => $type,
        'ip' => xlog_ip_bin(),
        'user_agent' => substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 255),
        'extra' => array('qstr'=>$qstr),
    ));
}, G5_HOOK_DEFAULT_PRIORITY, 3);

add_event('member_logout', function($link){
    global $member;
    if (!xlog_can('logout')) return;
    if (!$member['mb_id']) return;
    xlog_insert(array(
        'created_at' => xlog_now(),
        'mb_id' => $member['mb_id'],
        'act_type' => 'logout',
        'ip' => xlog_ip_bin(),
        'user_agent' => substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 255),
    ));
}, G5_HOOK_DEFAULT_PRIORITY, 1);

/* robust member_update 감지 (접두사/백틱/개행/대소문자 대응) */
add_event('sql_query_after', function($result, $sql){
    static $logged_member_update = false;
    if ($logged_member_update) return;

    $member_table = $GLOBALS['g5']['member_table'] ?? 'g5_member';
    $re = '~^\s*update\s+`?'.preg_quote($member_table, '~').'`?\s+set~i';

    if (!preg_match($re, $sql)) return;

    $logged_member_update = true;
    if (!xlog_can('member_update')) return;
    xlog_insert(array(
        'created_at' => xlog_now(),
        'mb_id'      => $GLOBALS['member']['mb_id'] ?? '',
        'act_type'   => 'member_update',
        'ip'         => xlog_ip_bin(),
        'user_agent' => substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 255),
        'extra'      => array('sql_hint' => substr($sql, 0, 120))
    ));
}, G5_HOOK_DEFAULT_PRIORITY, 6);

/*--------------------------------------------------------------
  게시글/댓글 CRUD
--------------------------------------------------------------*/
add_event('write_update_after', function($board, $wr_id, $w, $qstr=null, $redirect_url=null){
    global $member;
    $type = (in_array($w, array('u','update','modify')) ? 'post_edit' : 'post_write');
    if (!xlog_can($type)) return;
    xlog_insert(array(
        'created_at' => xlog_now(),
        'mb_id' => $member['mb_id'] ?? '',
        'act_type' => $type,
        'bo_table' => $board['bo_table'] ?? '',
        'wr_id' => (int)$wr_id,
        'ip' => xlog_ip_bin(),
        'user_agent' => substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 255),
    ));
}, G5_HOOK_DEFAULT_PRIORITY, 5);

add_event('bbs_delete', function($write, $board){
    global $member;
    if (!xlog_can('post_delete')) return;
    xlog_insert(array(
        'created_at' => xlog_now(),
        'mb_id' => $member['mb_id'] ?? '',
        'act_type' => 'post_delete',
        'bo_table' => $board['bo_table'] ?? '',
        'wr_id' => (int)($write['wr_id'] ?? 0),
        'ip' => xlog_ip_bin(),
        'user_agent' => substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 255),
    ));
}, G5_HOOK_DEFAULT_PRIORITY, 2);

add_event('sql_query_after', function($result, $sql){
    if (!preg_match('~\bg5_write_([a-z0-9_]+)\b~i', $sql, $m)) return;
    $bo_table = $m[1];
    $is_comment = (stripos($sql,'wr_is_comment') !== false) || (stripos($sql,' where ') !== false && stripos($sql,'wr_parent') !== false);
    if (!$is_comment) return;

    $act = null;
    if (stripos($sql,'insert ')===0) $act='comment_write';
    elseif (stripos($sql,'update ')===0) $act='comment_edit';
    elseif (stripos($sql,'delete ')===0) $act='comment_delete';
    if (!$act || !xlog_can($act)) return;

    $wr_id = 0; $cm_id = 0;
    $write_table = $GLOBALS['g5']['write_prefix'].$bo_table;

    if (preg_match('~\bwr_id\s*=\s*([0-9]+)~i', $sql, $mm)) {
        $cm_id = (int)$mm[1];
        $parent = sql_fetch("SELECT wr_parent FROM {$write_table} WHERE wr_id={$cm_id}");
        if ($parent && $parent['wr_parent']) $wr_id = (int)$parent['wr_parent'];
    } else {
        global $member;
        $guess = sql_fetch("
          SELECT wr_id, wr_parent FROM {$write_table}
          WHERE wr_is_comment=1
            AND mb_id='".sql_real_escape_string($member['mb_id'] ?? '')."'
            AND wr_datetime >= DATE_SUB(NOW(), INTERVAL 3 SECOND)
          ORDER BY wr_id DESC LIMIT 1
        ");
        if ($guess) { $cm_id = (int)$guess['wr_id']; $wr_id = (int)$guess['wr_parent']; }
    }

    xlog_insert(array(
        'created_at' => xlog_now(),
        'mb_id'      => $GLOBALS['member']['mb_id'] ?? '',
        'act_type'   => $act,
        'bo_table'   => $bo_table,
        'wr_id'      => $wr_id ?: 0,
        'cm_id'      => $cm_id ?: 0,
        'ip'         => xlog_ip_bin(),
        'user_agent' => substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 255),
        'extra'      => array('sql_hint'=>substr($sql,0,120))
    ));
}, G5_HOOK_DEFAULT_PRIORITY, 6);
