<?php
namespace weaver;

class SlidePopup extends Plugin {

    private $data_table;
    private $admin_number = 100320;
    public $disable_hour = 24;

    protected function __construct() {

        $this->data_table = $this->table_prefix.'slide_popup';

        if(!sql_query(" DESC {$this->data_table}", false)) {

            sql_query("CREATE TABLE IF NOT EXISTS `{$this->data_table}` (
                  `nw_id` int(11) NOT NULL AUTO_INCREMENT,
                  `nw_division` varchar(10) NOT NULL DEFAULT 'both',
                  `nw_device` varchar(10) NOT NULL DEFAULT 'both',
                  `nw_begin_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
                  `nw_end_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
                  `nw_disable_hours` int(11) NOT NULL DEFAULT '0', 
                  `nw_subject` text NOT NULL,
                  `nw_content` text NOT NULL,
                  `nw_content_html` tinyint(4) NOT NULL DEFAULT '0',
                  `nw_order` tinyint(4) NOT NULL DEFAULT '0',
                  PRIMARY KEY (`nw_id`)
                ) ENGINE=MyISAM DEFAULT CHARSET=utf8;", true);

        }

        add_replace('admin_menu', array($this, 'add_admin_menu'), 1, 1);
        add_event('admin_get_page_slide_popup_list', array($this, 'slide_popup_list'), 1, 2);
        add_event('admin_get_page_slide_popup_form', array($this, 'slide_popup_form'), 1, 2);
        add_event('admin_request_handler_slide_popup_form', array($this, 'slide_popup_head'), 1, 2);
        add_event('admin_get_page_slide_popup_form_update', array($this, 'slide_popup_form_update'), 1, 2);

        add_event('wv_hook_before_header_wrapper',array($this,'wv_hook_before_header_wrapper'));
    }

    public function wv_hook_before_header_wrapper(){
        if(defined('_INDEX_')){
            echo wv('slide_popup')->displayPopup('modal');
        }
    }

    public function add_admin_menu($admin_menu){

        $admin_menu['menu100'][] = array(
            $this->admin_number, '슬라이드팝업관리', G5_ADMIN_URL.'/view.php?call=slide_popup_list', 'slide_popup_list',
        );
        $sorted_arr = array_column($admin_menu['menu100'], '0');
        array_multisort($sorted_arr, SORT_ASC, $admin_menu['menu100']);

        return $admin_menu;
    }

    public function slide_popup_head($arr_query, $token){
        global $is_admin, $auth, $config, $g5,$sub_menu;

        $sub_menu = admin_menu_find_by('slide_popup_list', 'sub_menu');
        $g5['title'] = admin_menu_find_by('slide_popup_list', 'title');


    }

    public function slide_popup_list($arr_query, $token){
        global $is_admin, $auth, $config, $g5;


        include_once($this->plugin_path . '/adm/popup_list.php');
    }

    public function slide_popup_form($arr_query, $token){
        global $is_admin, $auth, $config, $g5;

        @extract($_GET);
        @extract($_POST);
        include_once($this->plugin_path . '/adm/popup_form.php');
    }

    public function slide_popup_form_update($arr_query, $token){
        global $is_admin, $auth, $config, $g5;

        @extract($_GET);
        @extract($_POST);
        include_once($this->plugin_path . '/adm/popup_form_update.php');
    }

    public function displayPopup($skin){
        if (isset($_COOKIE["wv-slide-popup"])and $_COOKIE["wv-slide-popup"]==1)return false;

        $nw_device_sql = "( 'both', 'pc' ) ";
        if(is_mobile()){
            $nw_device_sql = "( 'both', 'mobile' ) ";
        }

        $sql = " select * from {$this->data_table}
          where '".G5_TIME_YMDHIS."' between nw_begin_time and nw_end_time
            and nw_device IN {$nw_device_sql}  
          order by nw_order asc, nw_id asc ";

        $result = sql_query($sql, 1);
        $data['arr'] = array();
        for ($i=0; $nw=sql_fetch_array($result); $i++) {
            // 이미 체크 되었다면 Continue
            if ($_COOKIE["wv_pops_{$nw['nw_id']}"])
                continue;
            $data['arr'][$i]=array(
                'content'=>str_replace('&nbsp;','',$nw['nw_content']),
                'title'=>str_replace('&nbsp;','',$nw['nw_subject']),
            );
        }
        if($i==0)return false;

        return $this->make_skin($skin,$data);

    }


}
SlidePopup::getInstance();