<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// 점검 화면 출력 함수
function display_inspection_page($inspection) {
    $title = htmlspecialchars($inspection['title']);
    $message = $inspection['message'];
    $start_time = strtotime($inspection['start_datetime']);
    $end_time = strtotime($inspection['end_datetime']);
    $current_time = time();
    
    // 진행률 계산
    $total_duration = $end_time - $start_time;
    $elapsed_time = $current_time - $start_time;
    $progress_percent = min(100, max(0, ($elapsed_time / $total_duration) * 100));
    
    // 남은 시간 계산
    $remaining_seconds = $end_time - $current_time;
    $remaining_hours = floor($remaining_seconds / 3600);
    $remaining_minutes = floor(($remaining_seconds % 3600) / 60);
    $remaining_secs = $remaining_seconds % 60;
    
    $end_time_formatted = date('Y년 m월 d일 H시 i분', $end_time);
    
    // 완전한 HTML 페이지 출력
    echo '<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="refresh" content="60">
    <title>'.$title.'</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: "Malgun Gothic", "Apple SD Gothic Neo", sans-serif;
            background: #6c757d;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #333;
            overflow: hidden;
        }
        .inspection-container {
            background: white;
            border-radius: 20px;
            padding: 60px 40px;
            max-width: 700px;
            width: 90%;
            text-align: center;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            animation: fadeIn 0.8s ease-out;
            position: relative;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .inspection-icon {
            font-size: 80px;
            color: #667eea;
            margin-bottom: 30px;
            animation: pulse 2s infinite;
        }
        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.1); }
        }
        .inspection-title {
            font-size: 32px;
            font-weight: bold;
            color: #333;
            margin-bottom: 20px;
        }
        .inspection-message {
            font-size: 18px;
            line-height: 1.6;
            color: #666;
            margin-bottom: 30px;
        }
        .time-info {
            margin-bottom: 30px;
        }
        .remaining-time {
            font-size: 24px;
            font-weight: bold;
            color: #667eea;
            margin-bottom: 15px;
        }
        .progress-container {
            background: #f0f0f0;
            border-radius: 25px;
            height: 20px;
            margin: 20px 0;
            overflow: hidden;
            position: relative;
        }
        .progress-bar {
            background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
            height: 100%;
            border-radius: 25px;
            transition: width 1s ease;
            position: relative;
            overflow: hidden;
        }
        .progress-bar::after {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            bottom: 0;
            right: 0;
            background: linear-gradient(
                90deg,
                transparent,
                rgba(255,255,255,0.3),
                transparent
            );
            animation: shimmer 2s infinite;
        }
        @keyframes shimmer {
            0% { transform: translateX(-100%); }
            100% { transform: translateX(100%); }
        }
        .progress-text {
            font-size: 14px;
            color: #666;
            margin-bottom: 10px;
            text-align: center;
        }
        .inspection-time {
            font-size: 16px;
            color: #999;
            background: #f8f9fa;
            padding: 15px;
            border-radius: 10px;
        }
        .inspection-time strong {
            color: #667eea;
        }
        .countdown-timer {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin: 20px 0;
        }
        .time-unit {
            background: #f8f9fa;
            padding: 15px 20px;
            border-radius: 10px;
            min-width: 80px;
        }
        .time-number {
            font-size: 28px;
            font-weight: bold;
            color: #667eea;
            display: block;
        }
        .time-label {
            font-size: 12px;
            color: #666;
            margin-top: 5px;
        }
        @media (max-width: 768px) {
            .inspection-container {
                padding: 40px 20px;
            }
            .inspection-title {
                font-size: 24px;
            }
            .remaining-time {
                font-size: 20px;
            }
            .countdown-timer {
                gap: 10px;
            }
            .time-unit {
                padding: 10px 15px;
                min-width: 60px;
            }
            .time-number {
                font-size: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="inspection-container">
        <div class="inspection-icon">⚙️</div>
        <h1 class="inspection-title">'.$title.'</h1>
        <div class="inspection-message">'.$message.'</div>
        
        <div class="time-info">
            <div class="remaining-time">남은 시간</div>
            <div class="countdown-timer">
                <div class="time-unit">
                    <span class="time-number" id="hours">'.sprintf('%02d', max(0, $remaining_hours)).'</span>
                    <div class="time-label">시간</div>
                </div>
                <div class="time-unit">
                    <span class="time-number" id="minutes">'.sprintf('%02d', max(0, $remaining_minutes)).'</span>
                    <div class="time-label">분</div>
                </div>
                <div class="time-unit">
                    <span class="time-number" id="seconds">'.sprintf('%02d', max(0, $remaining_secs)).'</span>
                    <div class="time-label">초</div>
                </div>
            </div>
        </div>
        
        <div class="progress-text">점검 진행률: '.number_format($progress_percent, 1).'%</div>
        <div class="progress-container">
            <div class="progress-bar" style="width: '.number_format($progress_percent, 1).'%"></div>
        </div>
        
        <div class="inspection-time">
            <strong>예상 완료 시간:</strong> '.$end_time_formatted.'
        </div>
    </div>

    <script>
        // 실시간 카운트다운
        let endTime = '.$end_time.' * 1000; // JavaScript는 밀리초 사용
        let startTime = '.$start_time.' * 1000;
        
        function updateCountdown() {
            let now = new Date().getTime();
            let remaining = endTime - now;
            
            if (remaining <= 0) {
                // 점검 완료 시 페이지 새로고침
                location.reload();
                return;
            }
            
            let hours = Math.floor(remaining / (1000 * 60 * 60));
            let minutes = Math.floor((remaining % (1000 * 60 * 60)) / (1000 * 60));
            let seconds = Math.floor((remaining % (1000 * 60)) / 1000);
            
            document.getElementById("hours").textContent = String(hours).padStart(2, "0");
            document.getElementById("minutes").textContent = String(minutes).padStart(2, "0");
            document.getElementById("seconds").textContent = String(seconds).padStart(2, "0");
            
            // 진행률 업데이트
            let totalDuration = endTime - startTime;
            let elapsed = now - startTime;
            let progress = Math.min(100, Math.max(0, (elapsed / totalDuration) * 100));
            
            document.querySelector(".progress-bar").style.width = progress.toFixed(1) + "%";
            document.querySelector(".progress-text").textContent = "점검 진행률: " + progress.toFixed(1) + "%";
        }
        
        // 1초마다 업데이트
        setInterval(updateCountdown, 1000);
        
        // 페이지 로드 시 즉시 실행
        updateCountdown();
    </script>
</body>
</html>';
}

// 점검 데이터가 전달되면 페이지 표시
if (isset($inspection_data)) {
    display_inspection_page($inspection_data);
}
?>
