<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

global $g5;

// 현재 설정 조회
$current_config = sql_fetch("SELECT * FROM `{$g5['homepage_inspection_table']}`");

$start_date = substr($current_config['start_datetime'], 0, 10);
$start_time = substr($current_config['start_datetime'], 11, 5);
$end_date = substr($current_config['end_datetime'], 0, 10);
$end_time = substr($current_config['end_datetime'], 11, 5);

$g5['title'] = '홈페이지 점검 설정';
?>

<div class="local_ov01 local_ov">
    <span class="btn_ov01">
        <span class="ov_txt">점검 상태 </span>
        <span class="ov_num">
            <?php if ($current_config['is_active']) { ?>
                <strong style="color: #28a745;">활성</strong>
            <?php } else { ?>
                <strong style="color: #6c757d;">비활성</strong>
            <?php } ?>
        </span>
    </span>
    <?php if ($current_config['is_active']) { ?>
    <span class="btn_ov01">
        <span class="ov_txt">점검 시간 </span>
        <span class="ov_num"><?php echo date('m/d H:i', strtotime($current_config['start_datetime'])); ?> ~ <?php echo date('m/d H:i', strtotime($current_config['end_datetime'])); ?></span>
    </span>
    <?php } ?>
</div>

<form name="inspection_form" id="inspection_form" action="<?php echo G5_PLUGIN_URL; ?>/homepage_inspection/setup_update.php" onsubmit="return inspection_submit(this);" method="post">
<input type="hidden" name="token" value="">

<div class="tbl_frm01 tbl_wrap">
    <table>
    <caption><?php echo $g5['title']; ?></caption>
    <colgroup>
        <col class="grid_4">
        <col>
    </colgroup>
    <tbody>
    <tr>
        <th scope="row"><label for="start_date">점검 시작 시간</label></th>
        <td>
            <input type="date" name="start_date" value="<?php echo $start_date; ?>" id="start_date" class="frm_input" required>
            <input type="time" name="start_time" value="<?php echo $start_time; ?>" id="start_time" class="frm_input" required style="margin-left: 10px;">
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="end_date">점검 종료 시간</label></th>
        <td>
            <input type="date" name="end_date" value="<?php echo $end_date; ?>" id="end_date" class="frm_input" required>
            <input type="time" name="end_time" value="<?php echo $end_time; ?>" id="end_time" class="frm_input" required style="margin-left: 10px;">
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="title">점검 제목</label></th>
        <td>
            <input type="text" name="title" value="<?php echo htmlspecialchars($current_config['title']); ?>" id="title" class="frm_input" required maxlength="255">
        </td>
    </tr>
    <tr>
        <th scope="row"><label for="message">점검 메시지</label></th>
        <td>
            <textarea name="message" id="message" required class="required frm_input" rows="5"><?php echo htmlspecialchars($current_config['message']); ?></textarea>
            <div class="help-block">미리보기:</div>
            <div id="message-preview" style="background: #f8f9fa; border: 1px solid #dee2e6; border-radius: 5px; padding: 15px; margin-top: 10px; min-height: 100px;">
                <?php echo $current_config['message']; ?>
            </div>
        </td>
    </tr>
    <tr>
        <th scope="row">점검 모드</th>
        <td>
            <input type="checkbox" name="is_active" value="1" id="is_active" <?php echo $current_config['is_active'] ? 'checked' : ''; ?>>
            <label for="is_active">점검 모드 활성화</label>
            <div class="help-block">체크하면 설정된 시간에 점검 페이지가 표시됩니다.</div>
        </td>
    </tr>
    </tbody>
    </table>
</div>

<div class="btn_confirm01 btn_confirm">
    <input type="submit" class="btn_submit" accesskey="s" value="설정 저장">
</div>
</form>

<script>
// 메시지 실시간 미리보기
document.getElementById('message').addEventListener('input', function() {
    document.getElementById('message-preview').innerHTML = this.value;
});

function inspection_submit(f) {
    var startDate = f.start_date.value;
    var startTime = f.start_time.value;
    var endDate = f.end_date.value;
    var endTime = f.end_time.value;
    
    var startDateTime = new Date(startDate + ' ' + startTime);
    var endDateTime = new Date(endDate + ' ' + endTime);
    
    if (startDateTime >= endDateTime) {
        alert('점검 시작 시간은 종료 시간보다 빨라야 합니다.');
        return false;
    }
    
    if (f.title.value.trim() === '') {
        alert('점검 제목을 입력하세요.');
        f.title.focus();
        return false;
    }
    
    if (f.message.value.trim() === '') {
        alert('점검 메시지를 입력하세요.');
        f.message.focus();
        return false;
    }
    
    f.token.value = get_ajax_token();
    return confirm('설정을 저장하시겠습니까?');
}
</script>