<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가;

$g5['homepage_inspection_table'] = G5_TABLE_PREFIX.'homepage_inspection';

homepage_inspection_add_hooks();

function homepage_inspection_add_hooks(){
    add_event('admin_common', 'homepage_inspection_dbsetup');
    add_replace('admin_menu', 'add_homepage_inspection_admin_menu', G5_HOOK_DEFAULT_PRIORITY, 1);
    add_event('admin_get_page_homepage_inspection_config', 'add_homepage_inspection_config_page', G5_HOOK_DEFAULT_PRIORITY, 2);
    add_event('tail_sub', 'homepage_inspection_check');
}

function add_homepage_inspection_admin_menu($admin_menu){
    $admin_menu['menu100'][] = array('100851', '홈페이지 점검 설정', G5_ADMIN_URL.'/view.php?call=homepage_inspection_config', 'homepage_inspection_config');
    return $admin_menu;
}
function add_homepage_inspection_config_page($arr_query, $token){
    include_once(G5_PLUGIN_PATH.'/homepage_inspection/setup.php');
}

function homepage_inspection_dbsetup(){
    global $g5, $is_admin;
    
    // 홈페이지 점검 설정 테이블
    if(!sql_query("DESCRIBE `{$g5['homepage_inspection_table']}`", false) && $is_admin) {
        sql_query("CREATE TABLE `{$g5['homepage_inspection_table']}` (
            `start_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '점검 시작 시간',
            `end_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '점검 종료 시간',
            `title` varchar(255) NOT NULL DEFAULT '' COMMENT '점검 제목',
            `message` text NOT NULL COMMENT '점검 메시지',
            `is_active` tinyint(1) NOT NULL DEFAULT '0' COMMENT '사용 여부 (0:비활성, 1:활성)',
            `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '생성일시',
            `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '수정일시'
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='홈페이지 점검 설정';", true);
        
        // 기본 설정 데이터 삽입
        sql_query("INSERT INTO `{$g5['homepage_inspection_table']}` SET 
            `start_datetime` = '2025-01-01 02:00:00',
            `end_datetime` = '2025-01-01 06:00:00',
            `title` = '정기 점검',
            `message` = '시스템 점검으로 인해 일시적으로 서비스를 이용하실 수 없습니다.<br>점검 완료 후 정상 서비스 제공 예정입니다.<br>이용에 불편을 드려 죄송합니다.',
            `is_active` = 0", true);
    }
}

// 홈페이지 점검 상태 체크 함수
function homepage_inspection_check() {
    global $g5, $is_admin;
    
    // 관리자는 점검 화면을 보지 않음
    if ($is_admin) {
        return;
    }
    
    // 로그인 관련 페이지는 점검 중에도 접근 허용
    $current_script = basename($_SERVER['SCRIPT_NAME']);
    $allowed_pages = array(
        'login.php',
        'login_check.php', 
        'logout.php'
    );
    
    if (in_array($current_script, $allowed_pages)) {
        return;
    }

    
    // 테이블이 존재하지 않으면 리턴
    if (!sql_query("DESCRIBE `{$g5['homepage_inspection_table']}`", false)) {
        return;
    }
    
    $now = date('Y-m-d H:i:s');
    
    // 활성화된 점검 설정 조회
    $sql = "SELECT * FROM `{$g5['homepage_inspection_table']}` 
            WHERE `is_active` = 1 
            AND `start_datetime` <= '{$now}' 
            AND `end_datetime` >= '{$now}'";
    
    $inspection = sql_fetch($sql);
    
    if ($inspection) {
        // 모든 출력 버퍼 정리
        while (ob_get_level()) {
            ob_end_clean();
        }
        
        // 점검 데이터를 변수로 설정
        $inspection_data = $inspection;
        
        // 점검 페이지 포함 및 출력
        include_once(G5_PATH.'/plugin/homepage_inspection/inspection_page.php');
        exit;
    }
}