<?php
$sub_menu = '750100';

include_once('./_common.php');
include_once(G5_LIB_PATH.'/pushmanager.lib.php');

auth_check_menu($auth, $sub_menu, "w");

$g5['title'] = '푸시매니저 API 설정';
include_once(G5_ADMIN_PATH.'/admin.head.php');

// 테이블 존재 확인
$table_exists = false;
$sql = "SHOW TABLES LIKE 'pushmanager_config'";
$result = sql_query($sql, false);
if ($result && sql_num_rows($result) > 0) {
    $table_exists = true;
}

if (!$table_exists) {
    alert('푸시매니저가 설치되지 않았습니다.', './install.php');
}

// 현재 설정 조회
$config = get_pushmanager_config();
$has_config = $config && $config['site_name'];
$has_api_key = $config && $config['api_key'];
$has_vapid_key = $config && $config['vapid_public_key'];
$has_push_icon = $config && $config['push_icon_url'];
$has_badge_icon = $config && $config['badge_icon_url'];

// 메시지 포맷 기본값 설정
$default_formats = array(
    'newpost_title' => '[{BOARD_NAME}] 새글 알림',
    'newpost_message' => '{SENDER_NICKNAME}님이 새글을 작성했습니다.\\n제목: {POST_TITLE}',
    'comment_title' => '댓글 알림',
    'comment_message' => '{SENDER_NICKNAME}님이 댓글을 남겼습니다.\\n원글: {POST_TITLE}\\n댓글: {COMMENT_CONTENT}',
    'memo_title' => '쪽지 알림',
    'memo_message' => '{SENDER_NICKNAME}님으로부터 쪽지가 도착했습니다.\\n내용: {MEMO_CONTENT}'
);

$pg_anchor = '<ul class="anchor">
    <li><a href="#anc_api1">사이트 기본 정보</a></li>
    <li><a href="#anc_api2">API 설정</a></li>
    <li><a href="#anc_api3">알림 포맷팅 설정</a></li>
    <li><a href="#anc_api4">아이콘 설정</a></li>
    <li><a href="#anc_api5">PWA 설정</a></li>
    <li><a href="#anc_api6">설정 상태</a></li>
</ul>';
?>

<div class="local_desc01 local_desc">
    <p>
        푸시매니저 API 서버와의 연동을 위한 설정을 관리합니다.<br>
        사이트 정보를 입력하고 API 키를 설정하여 푸시 서비스를 이용하세요.
    </p>
</div>

<!-- 설정 폼 -->
<form name="fconfig" method="post" action="./api_config_update.php" enctype="multipart/form-data">

<!-- 1. 사이트 기본 정보 -->

<h2 id="anc_api1" class="h2_frm">사이트 기본 정보</h2>
<?php echo $pg_anchor ?>

<div class="tbl_frm01 tbl_wrap">
    <table>
        <caption>사이트 기본 정보</caption>
        <colgroup>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
            <tr>
                <th scope="row"><label for="site_name">사이트명<strong class="sound_only">필수</strong></label></th>
                <td>
                    <input type="text" name="site_name" id="site_name" value="<?php echo isset($config['site_name']) ? $config['site_name'] : '' ?>" required class="frm_input required" size="30" maxlength="100">
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="site_url">사이트 URL<strong class="sound_only">필수</strong></label></th>
                <td>
                    <input type="url" name="site_url" id="site_url" value="<?php echo isset($config['site_url']) ? $config['site_url'] : '' ?>" required class="frm_input required" size="50" maxlength="255" placeholder="https://example.com">
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="admin_email">관리자 이메일<strong class="sound_only">필수</strong></label></th>
                <td>
                    <input type="email" name="admin_email" id="admin_email" value="<?php echo isset($config['admin_email']) ? $config['admin_email'] : '' ?>" required class="frm_input required" size="30" maxlength="100">
                </td>
            </tr>
        </tbody>
    </table>
</div>

<!-- 2. API 서버 연동 설정 -->
 
<h2 id="anc_api2" class="h2_frm">API 설정</h2>
<?php echo $pg_anchor ?>

<div class="tbl_frm01 tbl_wrap" style="margin-top: 20px;">
    <table>
        <caption>API 서버 연동 설정</caption>
        <colgroup>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
            <tr>
                <th scope="row"><label for="api_server_url">API 서버 URL<strong class="sound_only">필수</strong></label></th>
                <td>
                    <input type="url" name="api_server_url" id="api_server_url" value="<?php echo isset($config['api_server_url']) ? $config['api_server_url'] : '' ?>" required class="frm_input required" size="50" maxlength="255" placeholder="https://push-api.example.com">
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="api_key">API 키</label></th>
                <td>
                    <input type="text" name="api_key" id="api_key" value="<?php echo isset($config['api_key']) ? $config['api_key'] : '' ?>" class="frm_input" size="60" maxlength="255" placeholder="API 관리자 프론트에서 발급받은 API 키">
                    <div class="frm_info">API 관리자 프론트에서 발급받은 API 키를 입력하세요.</div>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="vapid_public_key">VAPID 공개키</label></th>
                <td>
                    <textarea name="vapid_public_key" id="vapid_public_key" class="frm_input" style="width:100%; height:80px;" placeholder="VAPID 공개키를 입력하세요 (예: BNXxxx...)"><?php echo isset($config['vapid_public_key']) ? $config['vapid_public_key'] : '' ?></textarea>
                    <div class="frm_info">푸시 서버에서 생성한 VAPID 공개키를 입력하세요. Base64 URL Safe 형식이어야 합니다.</div>
                </td>
            </tr>
        </tbody>
    </table>
</div>

<!-- 3. 푸시 메시지 포맷 설정 -->

<h2 id="anc_api3" class="h2_frm">알림 포맷팅 설정</h2>
<?php echo $pg_anchor ?>

<div class="tbl_frm01 tbl_wrap" style="margin-top: 20px;">
    <table>
        <caption>푸시 메시지 포맷 설정</caption>
        <colgroup>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
            <tr>
                <th scope="row" style="vertical-align: top; padding-top: 15px;">새글 알림 포맷</th>
                <td>
                    <div style="margin-bottom: 10px;">
                        <label for="newpost_title" style="font-weight: bold;">타이틀:</label>
                        <input type="text" name="newpost_title" id="newpost_title" value="<?php echo isset($config['newpost_title']) ? $config['newpost_title'] : $default_formats['newpost_title'] ?>" class="frm_input" style="width: 100%; margin-top: 5px;" maxlength="100">
                    </div>
                    <div style="margin-bottom: 10px;">
                        <label for="newpost_message" style="font-weight: bold;">메시지:</label>
                        <textarea name="newpost_message" id="newpost_message" class="frm_input" style="width:100%; height:80px; margin-top: 5px;" maxlength="500"><?php echo isset($config['newpost_message']) ? str_replace('\\n', "\n", $config['newpost_message']) : str_replace('\\n', "\n", $default_formats['newpost_message']) ?></textarea>
                    </div>
                    <div class="frm_info">
                        <strong>사용 가능한 변수:</strong><br>
                        • {BOARD_NAME} = 게시판명<br>
                        • {SENDER_ID} = 작성자 아이디<br>
                        • {SENDER_NICKNAME} = 작성자 닉네임<br>
                        • {POST_TITLE} = 글 제목<br>
                        • {POST_CONTENT} = 글 내용 (100자 제한)<br>
                        • {SITE_NAME} = 사이트명
                    </div>
                </td>
            </tr>
            <tr>
                <th scope="row" style="vertical-align: top; padding-top: 15px;">댓글 알림 포맷</th>
                <td>
                    <div style="margin-bottom: 10px;">
                        <label for="comment_title" style="font-weight: bold;">타이틀:</label>
                        <input type="text" name="comment_title" id="comment_title" value="<?php echo isset($config['comment_title']) ? $config['comment_title'] : $default_formats['comment_title'] ?>" class="frm_input" style="width: 100%; margin-top: 5px;" maxlength="100">
                    </div>
                    <div style="margin-bottom: 10px;">
                        <label for="comment_message" style="font-weight: bold;">메시지:</label>
                        <textarea name="comment_message" id="comment_message" class="frm_input" style="width:100%; height:80px; margin-top: 5px;" maxlength="500"><?php echo isset($config['comment_message']) ? str_replace('\\n', "\n", $config['comment_message']) : str_replace('\\n', "\n", $default_formats['comment_message']) ?></textarea>
                    </div>
                    <div class="frm_info">
                        <strong>사용 가능한 변수:</strong><br>
                        • {BOARD_NAME} = 게시판명<br>
                        • {SENDER_ID} = 댓글 작성자 아이디<br>
                        • {SENDER_NICKNAME} = 댓글 작성자 닉네임<br>
                        • {POST_TITLE} = 원글 제목<br>
                        • {POST_AUTHOR} = 원글 작성자 닉네임<br>
                        • {COMMENT_CONTENT} = 댓글 내용 (100자 제한)<br>
                        • {SITE_NAME} = 사이트명
                    </div>
                </td>
            </tr>
            <tr>
                <th scope="row" style="vertical-align: top; padding-top: 15px;">쪽지 알림 포맷</th>
                <td>
                    <div style="margin-bottom: 10px;">
                        <label for="memo_title" style="font-weight: bold;">타이틀:</label>
                        <input type="text" name="memo_title" id="memo_title" value="<?php echo isset($config['memo_title']) ? $config['memo_title'] : $default_formats['memo_title'] ?>" class="frm_input" style="width: 100%; margin-top: 5px;" maxlength="100">
                    </div>
                    <div style="margin-bottom: 10px;">
                        <label for="memo_message" style="font-weight: bold;">메시지:</label>
                        <textarea name="memo_message" id="memo_message" class="frm_input" style="width:100%; height:80px; margin-top: 5px;" maxlength="500"><?php echo isset($config['memo_message']) ? str_replace('\\n', "\n", $config['memo_message']) : str_replace('\\n', "\n", $default_formats['memo_message']) ?></textarea>
                    </div>
                    <div class="frm_info">
                        <strong>사용 가능한 변수:</strong><br>
                        • {SENDER_ID} = 발신자 아이디<br>
                        • {SENDER_NICKNAME} = 발신자 닉네임<br>
                        • {RECEIVER_ID} = 수신자 아이디<br>
                        • {RECEIVER_NICKNAME} = 수신자 닉네임<br>
                        • {MEMO_SUBJECT} = 쪽지 제목<br>
                        • {MEMO_CONTENT} = 쪽지 내용 (100자 제한)<br>
                        • {SITE_NAME} = 사이트명
                    </div>
                </td>
            </tr>
            <tr>
                <th scope="row">포맷 미리보기</th>
                <td>
                    <button type="button" onclick="previewMessageFormat()" class="btn_frmline btn">미리보기</button>
                    <div id="preview_result" style="margin-top: 10px; padding: 10px; background: #f8f9fa; border: 1px solid #dee2e6; border-radius: 4px; display: none;">
                        <div id="preview_content"></div>
                    </div>
                    <div class="frm_info">현재 설정된 포맷으로 샘플 데이터를 이용해 미리보기를 확인할 수 있습니다.</div>
                </td>
            </tr>
        </tbody>
    </table>
</div>

<!-- 4. 푸시 아이콘 설정 -->

<h2 id="anc_api4" class="h2_frm">아이콘 설정</h2>
<?php echo $pg_anchor ?>

<div class="tbl_frm01 tbl_wrap" style="margin-top: 20px;">
    <table>
        <caption>푸시 아이콘 설정</caption>
        <colgroup>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
            <tr>
                <th scope="row"><label for="push_icon">푸시 아이콘</label></th>
                <td>
                    <?php if ($has_push_icon): ?>
                        <div style="margin-bottom: 10px;">
                            <img src="<?php echo $config['push_icon_url'] ?>" alt="푸시 아이콘" style="max-width: 64px; max-height: 64px; border: 1px solid #ddd; padding: 5px;">
                            <div class="frm_info">현재 아이콘 (클릭하면 새 창에서 열립니다): <a href="<?php echo $config['push_icon_url'] ?>" target="_blank"><?php echo basename($config['push_icon_url']) ?></a></div>
                        </div>
                    <?php endif; ?>
                    <input type="file" name="push_icon" id="push_icon" class="frm_input" accept="image/*">
                    <div class="frm_info">푸시 알림에 표시될 아이콘을 업로드하세요. (PNG, JPG, GIF, WebP 형식, 최대 2MB)</div>
                    <?php if ($has_push_icon): ?>
                        <button type="submit" name="delete_push_icon" value="1" class="btn_frmline btn" style="margin-top: 5px;" onclick="return confirm('푸시 아이콘을 삭제하시겠습니까?');">현재 아이콘 삭제</button>
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="badge_icon">뱃지 아이콘</label></th>
                <td>
                    <?php if ($has_badge_icon): ?>
                        <div style="margin-bottom: 10px;">
                            <img src="<?php echo $config['badge_icon_url'] ?>" alt="뱃지 아이콘" style="max-width: 64px; max-height: 64px; border: 1px solid #ddd; padding: 5px;">
                            <div class="frm_info">현재 아이콘 (클릭하면 새 창에서 열립니다): <a href="<?php echo $config['badge_icon_url'] ?>" target="_blank"><?php echo basename($config['badge_icon_url']) ?></a></div>
                        </div>
                    <?php endif; ?>
                    <input type="file" name="badge_icon" id="badge_icon" class="frm_input" accept="image/*">
                    <div class="frm_info">푸시 알림의 뱃지에 표시될 아이콘을 업로드하세요. (PNG, JPG, GIF, WebP 형식, 최대 2MB)</div>
                    <?php if ($has_badge_icon): ?>
                        <button type="submit" name="delete_badge_icon" value="1" class="btn_frmline btn" style="margin-top: 5px;" onclick="return confirm('뱃지 아이콘을 삭제하시겠습니까?');">현재 아이콘 삭제</button>
                    <?php endif; ?>
                </td>
            </tr>
        </tbody>
    </table>
</div>

<!-- 5. PWA 설정 -->
 
<?php
// 사용 가능한 스킨 목록 스캔
function get_available_skins() {
    $skins = array();
    $popup_dir = G5_PATH . '/plugin/pushmanager/js/popup/';
    
    if (is_dir($popup_dir)) {
        $dirs = scandir($popup_dir);
        foreach ($dirs as $dir) {
            if ($dir === '.' || $dir === '..') continue;
            
            $skin_path = $popup_dir . $dir;
            if (is_dir($skin_path)) {
                $html_file = $skin_path . '/popup.html';
                $css_file = $skin_path . '/popup.css';
                
                // 필수 파일이 존재하는지 확인
                if (file_exists($html_file) && file_exists($css_file)) {
                    $skins[] = array(
                        'name' => $dir,
                        'title' => ucfirst($dir),
                        'description' => get_skin_description($dir)
                    );
                }
            }
        }
    }
    
    return $skins;
}

function get_skin_description($skin_name) {
    $descriptions = array(
        'default' => '기본 하단 고정형 - 모든 환경에서 안정적으로 작동',
        'minimal' => '미니멀 중앙 모달 - 깔끔하고 현대적인 디자인',
        'modern' => '모던 글래스 스타일 - 트렌디한 글래스모피즘과 그라디언트',
        'bottom' => '컴팩트 하단형 - 모바일 최적화, 컨텐츠 방해 최소화'
    );
    
    return isset($descriptions[$skin_name]) ? $descriptions[$skin_name] : '커스텀 스킨';
}

$available_skins = get_available_skins();
$current_skin = isset($config['pwa_popup_skin']) ? $config['pwa_popup_skin'] : 'default';
?>

<h2 id="anc_api5" class="h2_frm">PWA 설정</h2>
<?php echo $pg_anchor ?>

<div class="tbl_frm01 tbl_wrap" style="margin-top: 20px;">
    <table>
        <caption>PWA 설치 팝업 설정</caption>
        <colgroup>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
            <tr>
                <th scope="row"><label for="pwa_popup_skin">팝업 스킨</label></th>
                <td>
                    <select name="pwa_popup_skin" id="pwa_popup_skin" class="frm_input" onchange="previewSkin(this.value)">
                        <?php foreach ($available_skins as $skin): ?>
                            <option value="<?php echo $skin['name'] ?>" <?php echo ($current_skin === $skin['name']) ? 'selected' : '' ?>>
                                <?php echo $skin['title'] ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    
                    <div id="skin_description" style="margin-top: 8px; padding: 8px; background: #f8f9fa; border-radius: 4px; font-size: 12px;">
                        <?php 
                        foreach ($available_skins as $skin) {
                            if ($skin['name'] === $current_skin) {
                                echo $skin['description'];
                                break;
                            }
                        }
                        ?>
                    </div>
                    
                    <div style="margin-top: 10px;">
                        <button type="button" onclick="testPWAPopup()" class="btn_frmline btn">팝업 테스트</button>
                        <button type="button" onclick="openSkinManager()" class="btn_frmline btn">스킨 관리</button>
                    </div>
                    
                    <div class="frm_info">
                        PWA 설치 유도 팝업의 디자인 스킨을 선택하세요. 각 스킨은 서로 다른 스타일과 위치를 가집니다.
                    </div>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="pwa_popup_title">PWA 팝업 타이틀</label></th>
                <td>
                    <input type="text" name="pwa_popup_title" id="pwa_popup_title" value="<?php echo isset($config['pwa_popup_title']) ? $config['pwa_popup_title'] : '앱 설치 안내' ?>" class="frm_input" size="50" maxlength="100" placeholder="앱 설치 안내">
                    <div class="frm_info">PWA 설치 유도 팝업에 표시될 타이틀을 입력하세요.</div>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="pwa_popup_description">PWA 팝업 설명</label></th>
                <td>
                    <textarea name="pwa_popup_description" id="pwa_popup_description" class="frm_input" style="width:100%; height:60px;" placeholder="홈 화면에 추가하여 앱처럼 편리하게 이용하세요!"><?php echo isset($config['pwa_popup_description']) ? $config['pwa_popup_description'] : '홈 화면에 추가하여 앱처럼 편리하게 이용하세요!' ?></textarea>
                    <div class="frm_info">PWA 설치 유도 팝업에 표시될 설명 문구를 입력하세요.</div>
                </td>
            </tr>
            <tr>
                <th scope="row">스킨 프리뷰</th>
                <td>
                    <div id="skin_preview" style="border: 1px solid #ddd; border-radius: 4px; overflow: hidden; background: #f5f5f5;">
                        <div style="padding: 15px; text-align: center; background: white; border-bottom: 1px solid #ddd;">
                            <strong>스킨 프리뷰</strong>
                        </div>
                        <div id="preview_iframe_container" style="height: 200px; position: relative; background: linear-gradient(45deg, #f0f0f0 25%, transparent 25%), linear-gradient(-45deg, #f0f0f0 25%, transparent 25%), linear-gradient(45deg, transparent 75%, #f0f0f0 75%), linear-gradient(-45deg, transparent 75%, #f0f0f0 75%); background-size: 20px 20px; background-position: 0 0, 0 10px, 10px -10px, -10px 0px;">
                            <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); color: #999; font-size: 14px;">
                                스킨을 선택하면 프리뷰가 표시됩니다
                            </div>
                        </div>
                    </div>
                    <div class="frm_info">선택한 스킨의 모습을 미리 볼 수 있습니다. 실제 팝업과는 다소 차이가 있을 수 있습니다.</div>
                </td>
            </tr>
        </tbody>
    </table>
</div>

<!-- 6. 설정 상태 -->

<h2 id="anc_api6" class="h2_frm">설정 상태</h2>
<?php echo $pg_anchor ?>

<?php if ($has_api_key && $has_vapid_key): ?>
<div class="tbl_frm01 tbl_wrap" style="margin-top: 20px;">
    <table>
        <caption>설정 상태</caption>
        <colgroup>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
            <tr>
                <th scope="row">API 연동 상태</th>
                <td>
                    <span class="fc_373 fc_bl"><b>✓ 완료됨</b></span>
                    <span class="fc_999">(<?php echo date('Y-m-d H:i', strtotime($config['updated_at'])) ?>)</span>
                    <div class="frm_info">API 키와 VAPID 키가 모두 설정되어 푸시 서비스를 사용할 수 있습니다.</div>
                </td>
            </tr>
            <tr>
                <th scope="row">아이콘 설정 상태</th>
                <td>
                    <?php if ($has_push_icon || $has_badge_icon): ?>
                        <span class="fc_373 fc_bl"><b>✓ 설정됨</b></span>
                        <?php if ($has_push_icon): ?>
                            <span class="fc_999">(푸시 아이콘: 설정됨)</span>
                        <?php endif; ?>
                        <?php if ($has_badge_icon): ?>
                            <span class="fc_999">(뱃지 아이콘: 설정됨)</span>
                        <?php endif; ?>
                    <?php else: ?>
                        <span class="fc_999">아이콘이 설정되지 않았습니다.</span>
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <th scope="row">PWA 설정 상태</th>
                <td>
                    <?php if (isset($config['pwa_popup_title']) && !empty($config['pwa_popup_title'])): ?>
                        <span class="fc_373 fc_bl"><b>✓ 설정됨</b></span>
                        <span class="fc_999">(타이틀: <?php echo htmlspecialchars($config['pwa_popup_title']) ?>)</span>
                    <?php else: ?>
                        <span class="fc_999">기본값 사용 중</span>
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <th scope="row">메시지 포맷 상태</th>
                <td>
                    <?php if (isset($config['newpost_title']) || isset($config['comment_title']) || isset($config['memo_title'])): ?>
                        <span class="fc_373 fc_bl"><b>✓ 설정됨</b></span>
                        <span class="fc_999">(사용자 정의 포맷 사용 중)</span>
                    <?php else: ?>
                        <span class="fc_999">기본 포맷 사용 중</span>
                    <?php endif; ?>
                </td>
            </tr>
        </tbody>
    </table>
</div>
<?php endif; ?>

<div class="btn_fixed_top">
    <input type="submit" name="save_config" value="설정 저장" class="btn_submit btn">
    <?php if ($has_api_key && $has_vapid_key): ?>
        <input type="submit" name="test_connection" value="연결 테스트" class="btn_02 btn">
        <input type="submit" name="delete_api_key" value="API 키 삭제" class="btn_02 btn" onclick="return confirm('API 키를 삭제하시겠습니까?\\n푸시 서비스를 더 이상 사용할 수 없게 됩니다.');">
    <?php endif; ?>
    <input type="button" name="reset_format" value="포맷 초기화" class="btn_02 btn" onclick="resetMessageFormats()">
</div>
</form>

<script>
// 스킨 정보 데이터
const skinData = {
    <?php foreach ($available_skins as $index => $skin): ?>
    '<?php echo $skin['name'] ?>': {
        title: '<?php echo $skin['title'] ?>',
        description: '<?php echo addslashes($skin['description']) ?>'
    }<?php echo ($index < count($available_skins) - 1) ? ',' : '' ?>
    <?php endforeach; ?>
};

// 스킨 선택 시 설명 업데이트
function previewSkin(skinName) {
    const descElement = document.getElementById('skin_description');
    if (skinData[skinName]) {
        descElement.textContent = skinData[skinName].description;
    }
    
    // 프리뷰 업데이트 (향후 구현)
    updateSkinPreview(skinName);
}

// 스킨 프리뷰 업데이트
function updateSkinPreview(skinName) {
    const previewContainer = document.getElementById('preview_iframe_container');
    
    // 간단한 프리뷰 표시
    const previewStyles = {
        'default': 'position: absolute; bottom: 0; left: 0; right: 0; background: white; border-top: 1px solid #ddd; padding: 12px; box-shadow: 0 -2px 10px rgba(0,0,0,0.1);',
        'minimal': 'position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 80%; background: white; border-radius: 12px; padding: 24px; box-shadow: 0 8px 32px rgba(0,0,0,0.15); text-align: center;',
        'modern': 'position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 80%; background: linear-gradient(135deg, rgba(255,255,255,0.9), rgba(255,255,255,0.7)); backdrop-filter: blur(10px); border-radius: 20px; padding: 24px; box-shadow: 0 20px 40px rgba(0,0,0,0.1); text-align: center; border: 1px solid rgba(255,255,255,0.3);',
        'bottom': 'position: absolute; bottom: 0; left: 0; right: 0; background: white; border-top: 1px solid #e5e7eb; padding: 10px 12px; box-shadow: 0 -2px 10px rgba(0,0,0,0.1); height: 56px; display: flex; align-items: center;'
    };
    
    const style = previewStyles[skinName] || previewStyles['default'];
    
    previewContainer.innerHTML = `
        <div style="${style}">
            <div style="font-size: 13px; font-weight: 600; margin-bottom: 2px;">앱 설치 안내</div>
            <div style="font-size: 11px; color: #666; margin-bottom: 8px;">홈 화면에 추가하여 앱처럼 편리하게 이용하세요!</div>
            <div style="display: flex; gap: 6px; ${skinName === 'minimal' || skinName === 'modern' ? 'flex-direction: column;' : ''}">
                <button style="background: #2563eb; color: white; border: none; padding: 4px 12px; border-radius: 4px; font-size: 11px; cursor: pointer;">설치하기</button>
                <button style="background: transparent; color: #666; border: 1px solid #ddd; padding: 4px 12px; border-radius: 4px; font-size: 11px; cursor: pointer;">나중에</button>
            </div>
        </div>
    `;
}

// PWA 팝업 테스트
function testPWAPopup() {
    const skinName = document.getElementById('pwa_popup_skin').value;
    const title = document.getElementById('pwa_popup_title').value || '앱 설치 안내';
    const description = document.getElementById('pwa_popup_description').value || '홈 화면에 추가하여 앱처럼 편리하게 이용하세요!';
    
    // 새 창으로 테스트 페이지 열기
    const testUrl = './pwa_popup_test.php?skin=' + encodeURIComponent(skinName) + 
                   '&title=' + encodeURIComponent(title) + 
                   '&description=' + encodeURIComponent(description);
    
    window.open(testUrl, 'pwa_test', 'width=400,height=600,scrollbars=yes,resizable=yes');
}

// 스킨 관리 페이지 열기
function openSkinManager() {
    window.open('./pwa_skin_manager.php', 'skin_manager', 'width=800,height=600,scrollbars=yes,resizable=yes');
}

// 페이지 로드 시 현재 스킨 프리뷰 표시
document.addEventListener('DOMContentLoaded', function() {
    const currentSkin = document.getElementById('pwa_popup_skin').value;
    updateSkinPreview(currentSkin);
});

function toggleApiKey() {
    var input = document.getElementById('api_key_display');
    var btn = event.target;
    
    if (input.type === 'password') {
        input.type = 'text';
        btn.textContent = '숨김';
    } else {
        input.type = 'password';
        btn.textContent = '보기';
    }
}

function previewMessageFormat() {
    var sampleData = {
        'BOARD_NAME': '자유게시판',
        'SENDER_ID': 'user123',
        'SENDER_NICKNAME': '홍길동',
        'POST_TITLE': '안녕하세요! 첫 글입니다.',
        'POST_CONTENT': '여러분 안녕하세요. 처음 가입한 새내기입니다. 잘 부탁드립니다!',
        'POST_AUTHOR': '김철수',
        'COMMENT_CONTENT': '안녕하세요! 환영합니다.',
        'RECEIVER_ID': 'admin',
        'RECEIVER_NICKNAME': '관리자',
        'MEMO_SUBJECT': '문의드립니다',
        'MEMO_CONTENT': '사이트 이용 중 궁금한 점이 있어서 문의드립니다.',
        'SITE_NAME': '<?php echo isset($config['site_name']) ? $config['site_name'] : '테스트사이트' ?>'
    };
    
    var previewHtml = '<h4>메시지 포맷 미리보기</h4>';
    
    // 새글 알림 미리보기
    var newpostTitle = document.getElementById('newpost_title').value;
    var newpostMessage = document.getElementById('newpost_message').value;
    
    previewHtml += '<div style="margin-bottom: 15px; padding: 10px; border: 1px solid #007bff; border-radius: 4px;">';
    previewHtml += '<strong style="color: #007bff;">새글 알림</strong><br>';
    previewHtml += '<strong>타이틀:</strong> ' + replaceVariables(newpostTitle, sampleData) + '<br>';
    previewHtml += '<strong>메시지:</strong><br>' + replaceVariables(newpostMessage, sampleData).replace(/\n/g, '<br>');
    previewHtml += '</div>';
    
    // 댓글 알림 미리보기
    var commentTitle = document.getElementById('comment_title').value;
    var commentMessage = document.getElementById('comment_message').value;
    
    previewHtml += '<div style="margin-bottom: 15px; padding: 10px; border: 1px solid #28a745; border-radius: 4px;">';
    previewHtml += '<strong style="color: #28a745;">댓글 알림</strong><br>';
    previewHtml += '<strong>타이틀:</strong> ' + replaceVariables(commentTitle, sampleData) + '<br>';
    previewHtml += '<strong>메시지:</strong><br>' + replaceVariables(commentMessage, sampleData).replace(/\n/g, '<br>');
    previewHtml += '</div>';
    
    // 쪽지 알림 미리보기
    var memoTitle = document.getElementById('memo_title').value;
    var memoMessage = document.getElementById('memo_message').value;
    
    previewHtml += '<div style="margin-bottom: 15px; padding: 10px; border: 1px solid #ffc107; border-radius: 4px;">';
    previewHtml += '<strong style="color: #856404;">쪽지 알림</strong><br>';
    previewHtml += '<strong>타이틀:</strong> ' + replaceVariables(memoTitle, sampleData) + '<br>';
    previewHtml += '<strong>메시지:</strong><br>' + replaceVariables(memoMessage, sampleData).replace(/\n/g, '<br>');
    previewHtml += '</div>';
    
    document.getElementById('preview_content').innerHTML = previewHtml;
    document.getElementById('preview_result').style.display = 'block';
}

function replaceVariables(text, data) {
    var result = text;
    for (var key in data) {
        var regex = new RegExp('{' + key + '}', 'g');
        result = result.replace(regex, data[key]);
    }
    return result;
}

function resetMessageFormats() {
    if (confirm('메시지 포맷을 기본값으로 초기화하시겠습니까?')) {
        document.getElementById('newpost_title').value = '[{BOARD_NAME}] 새글 알림';
        document.getElementById('newpost_message').value = '{SENDER_NICKNAME}님이 새글을 작성했습니다.\\n제목: {POST_TITLE}';
        document.getElementById('comment_title').value = '댓글 알림';
        document.getElementById('comment_message').value = '{SENDER_NICKNAME}님이 댓글을 남겼습니다.\\n원글: {POST_TITLE}\\n댓글: {COMMENT_CONTENT}';
        document.getElementById('memo_title').value = '쪽지 알림';
        document.getElementById('memo_message').value = '{SENDER_NICKNAME}님으로부터 쪽지가 도착했습니다.\\n내용: {MEMO_CONTENT}';
        alert('메시지 포맷이 기본값으로 초기화되었습니다.');
    }
}
</script>

<?php
include_once(G5_ADMIN_PATH.'/admin.tail.php');
?>