<?php
$sub_menu = "750100";
include_once('./_common.php');
include_once(G5_LIB_PATH.'/pushmanager.lib.php');

auth_check_menu($auth, $sub_menu, "r");

// 메시지 포맷 줄바꿈 보존 함수 추가
function preserve_message_format($text) {
    if (empty($text)) return '';
    
    // 실제 줄바꿈을 특수 문자로 변환하여 DB에 안전하게 저장
    $text = str_replace(array("\r\n", "\r", "\n"), "\\n", $text);
    return clean_xss_tags($text);
}

// 이미지 업로드 디렉토리 설정
$upload_dir = G5_DATA_PATH . '/pushmanager_icons';
$upload_url = G5_DATA_URL . '/pushmanager_icons';

// 업로드 디렉토리가 없으면 생성
if (!is_dir($upload_dir)) {
    if (!mkdir($upload_dir, 0755, true)) {
        alert('아이콘 업로드 디렉토리를 생성할 수 없습니다.', './api_config.php');
    }
}

// 이미지 업로드 함수
function upload_icon($file, $type = 'push') {
    global $upload_dir, $upload_url;
    
    if (!$file || $file['error'] !== UPLOAD_ERR_OK) {
        return false;
    }
    
    // 파일 확장자 검사
    $allowed_types = ['image/png', 'image/jpeg', 'image/jpg', 'image/gif', 'image/webp'];
    if (!in_array($file['type'], $allowed_types)) {
        alert('이미지 파일만 업로드 가능합니다. (PNG, JPG, GIF, WebP)', './api_config.php');
        return false;
    }
    
    // 파일 크기 검사 (2MB 제한)
    if ($file['size'] > 2 * 1024 * 1024) {
        alert('이미지 파일 크기는 2MB 이하여야 합니다.', './api_config.php');
        return false;
    }
    
    // 파일명 생성
    $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
    $filename = $type . '_icon_' . date('YmdHis') . '.' . $ext;
    $filepath = $upload_dir . '/' . $filename;
    
    // 파일 업로드
    if (move_uploaded_file($file['tmp_name'], $filepath)) {
        return $upload_url . '/' . $filename;
    }
    
    return false;
}

// 기존 아이콘 파일 삭제 함수
function delete_icon_file($url) {
    global $upload_dir, $upload_url;
    
    if (empty($url)) return;
    
    $filename = basename($url);
    $filepath = $upload_dir . '/' . $filename;
    
    if (file_exists($filepath)) {
        unlink($filepath);
    }
}

// 메시지 포맷 유효성 검사 함수
function validate_message_format($title, $message, $type) {
    // 길이 검사
    if (strlen($title) > 100) {
        alert($type . ' 타이틀은 100자 이하로 입력해주세요.', './api_config.php');
        return false;
    }
    
    if (strlen($message) > 500) {
        alert($type . ' 메시지는 500자 이하로 입력해주세요.', './api_config.php');
        return false;
    }
    
    // 필수 변수 검사 (각 타입별로)
    $required_vars = array();
    switch ($type) {
        case '새글 알림':
            $required_vars = ['{SENDER_NICKNAME}', '{POST_TITLE}'];
            break;
        case '댓글 알림':
            $required_vars = ['{SENDER_NICKNAME}'];
            break;
        case '쪽지 알림':
            $required_vars = ['{SENDER_NICKNAME}'];
            break;
    }
    
    // 권장 변수가 포함되어 있는지 확인 (경고만)
    $has_required = false;
    foreach ($required_vars as $var) {
        if (strpos($title . $message, $var) !== false) {
            $has_required = true;
            break;
        }
    }
    
    if (!$has_required && !empty($required_vars)) {
        // 경고만 하고 계속 진행
        $recommended = implode(', ', $required_vars);
        // alert에서는 실제 저장을 막지 않고 warning만
    }
    
    return true;
}

// 설정 저장 처리
if ($_POST['save_config']) {
    $site_name = clean_xss_tags($_POST['site_name']);
    $site_url = clean_xss_tags($_POST['site_url']);
    $admin_email = clean_xss_tags($_POST['admin_email']);
    $api_server_url = clean_xss_tags($_POST['api_server_url']);
    $api_key = clean_xss_tags($_POST['api_key']);
    $vapid_public_key = clean_xss_tags($_POST['vapid_public_key']);
    $pwa_popup_title = clean_xss_tags($_POST['pwa_popup_title']);
    $pwa_popup_description = clean_xss_tags($_POST['pwa_popup_description']);
    $pwa_popup_skin = clean_xss_tags($_POST['pwa_popup_skin']);
    
    // 메시지 포맷 데이터
    $newpost_title = clean_xss_tags($_POST['newpost_title']);
    $newpost_message = preserve_message_format($_POST['newpost_message']);
    $comment_title = clean_xss_tags($_POST['comment_title']);
    $comment_message = preserve_message_format($_POST['comment_message']);
    $memo_title = clean_xss_tags($_POST['memo_title']);
    $memo_message = preserve_message_format($_POST['memo_message']);
    
    // 유효성 검사
    if (empty($site_name)) {
        alert('사이트명을 입력해주세요.', './api_config.php');
    }
    
    if (!filter_var($site_url, FILTER_VALIDATE_URL)) {
        alert('올바른 사이트 URL을 입력해주세요.', './api_config.php');
    }
    
    if (!filter_var($admin_email, FILTER_VALIDATE_EMAIL)) {
        alert('올바른 이메일 주소를 입력해주세요.', './api_config.php');
    }
    
    if (!filter_var($api_server_url, FILTER_VALIDATE_URL)) {
        alert('올바른 API 서버 URL을 입력해주세요.', './api_config.php');
    }
    
    // API 키가 입력된 경우 검증
    if (!empty($api_key) && strlen($api_key) < 32) {
        alert('API 키가 너무 짧습니다. 올바른 API 키인지 확인해주세요.', './api_config.php');
    }
    
    // VAPID 키가 입력된 경우 검증
    if (!empty($vapid_public_key)) {
        // VAPID 키 형식 검증 (Base64 URL Safe 형식)
        if (!preg_match('/^[A-Za-z0-9_-]+$/', $vapid_public_key)) {
            alert('VAPID 공개키 형식이 올바르지 않습니다.', './api_config.php');
        }
        
        if (strlen($vapid_public_key) < 60) {
            alert('VAPID 공개키가 너무 짧습니다. 올바른 키인지 확인해주세요.', './api_config.php');
        }
    }

    // PWA 스킨 검증
    if (empty($pwa_popup_skin)) {
        $pwa_popup_skin = 'default';
    }
    
    // 스킨 파일 존재 여부 확인
    $skin_path = G5_PATH . '/plugin/pushmanager/js/popup/' . $pwa_popup_skin;
    if (!is_dir($skin_path) || !file_exists($skin_path . '/popup.html') || !file_exists($skin_path . '/popup.css')) {
        $pwa_popup_skin = 'default'; // 존재하지 않으면 기본 스킨으로
    }
    
    // PWA 설정 기본값 처리
    if (empty($pwa_popup_title)) {
        $pwa_popup_title = '앱 설치 안내';
    }
    
    if (empty($pwa_popup_description)) {
        $pwa_popup_description = '홈 화면에 추가하여 앱처럼 편리하게 이용하세요!';
    }
    
    // PWA 설정 길이 검증
    if (strlen($pwa_popup_title) > 100) {
        alert('PWA 팝업 타이틀은 100자 이하로 입력해주세요.', './api_config.php');
    }
    
    if (strlen($pwa_popup_description) > 500) {
        alert('PWA 팝업 설명은 500자 이하로 입력해주세요.', './api_config.php');
    }
    
    // 메시지 포맷 기본값 처리
    if (empty($newpost_title)) {
        $newpost_title = '[{BOARD_NAME}] 새글 알림';
    }
    if (empty($newpost_message)) {
        $newpost_message = '{SENDER_NICKNAME}님이 새글을 작성했습니다.\n제목: {POST_TITLE}';
    }
    if (empty($comment_title)) {
        $comment_title = '댓글 알림';
    }
    if (empty($comment_message)) {
        $comment_message = '{SENDER_NICKNAME}님이 댓글을 남겼습니다.\n원글: {POST_TITLE}\n댓글: {COMMENT_CONTENT}';
    }
    if (empty($memo_title)) {
        $memo_title = '쪽지 알림';
    }
    if (empty($memo_message)) {
        $memo_message = '{SENDER_NICKNAME}님으로부터 쪽지가 도착했습니다.\n내용: {MEMO_CONTENT}';
    }
    
    // 메시지 포맷 유효성 검사
    if (!validate_message_format($newpost_title, $newpost_message, '새글 알림')) {
        return;
    }
    if (!validate_message_format($comment_title, $comment_message, '댓글 알림')) {
        return;
    }
    if (!validate_message_format($memo_title, $memo_message, '쪽지 알림')) {
        return;
    }
    
    try {
        // 기존 설정 확인
        $existing_config = get_pushmanager_config();
        
        // 아이콘 업로드 처리
        $push_icon_url = $existing_config['push_icon_url'] ?? '';
        $badge_icon_url = $existing_config['badge_icon_url'] ?? '';
        
        // 푸시 아이콘 업로드
        if (isset($_FILES['push_icon']) && $_FILES['push_icon']['error'] === UPLOAD_ERR_OK) {
            $new_push_icon_url = upload_icon($_FILES['push_icon'], 'push');
            if ($new_push_icon_url) {
                // 기존 파일 삭제
                delete_icon_file($push_icon_url);
                $push_icon_url = $new_push_icon_url;
            }
        }
        
        // 뱃지 아이콘 업로드
        if (isset($_FILES['badge_icon']) && $_FILES['badge_icon']['error'] === UPLOAD_ERR_OK) {
            $new_badge_icon_url = upload_icon($_FILES['badge_icon'], 'badge');
            if ($new_badge_icon_url) {
                // 기존 파일 삭제
                delete_icon_file($badge_icon_url);
                $badge_icon_url = $new_badge_icon_url;
            }
        }
        
        if ($existing_config) {
            // 업데이트
            $sql = "UPDATE pushmanager_config SET 
                    site_name = '" . addslashes($site_name) . "',
                    site_url = '" . addslashes($site_url) . "',
                    admin_email = '" . addslashes($admin_email) . "',
                    api_server_url = '" . addslashes($api_server_url) . "',
                    api_key = " . (!empty($api_key) ? "'" . addslashes($api_key) . "'" : 'NULL') . ",
                    vapid_public_key = " . (!empty($vapid_public_key) ? "'" . addslashes($vapid_public_key) . "'" : 'NULL') . ",
                    push_icon_url = " . (!empty($push_icon_url) ? "'" . addslashes($push_icon_url) . "'" : 'NULL') . ",
                    badge_icon_url = " . (!empty($badge_icon_url) ? "'" . addslashes($badge_icon_url) . "'" : 'NULL') . ",
                    pwa_popup_skin = '" . addslashes($pwa_popup_skin) . "',
                    pwa_popup_title = '" . addslashes($pwa_popup_title) . "',
                    pwa_popup_description = '" . addslashes($pwa_popup_description) . "',
                    newpost_title = '" . addslashes($newpost_title) . "',
                    newpost_message = '" . addslashes($newpost_message) . "',
                    comment_title = '" . addslashes($comment_title) . "',
                    comment_message = '" . addslashes($comment_message) . "',
                    memo_title = '" . addslashes($memo_title) . "',
                    memo_message = '" . addslashes($memo_message) . "',
                    updated_at = NOW()
                    WHERE id = " . intval($existing_config['id']);
        } else {
            // 신규 삽입
            $sql = "INSERT INTO pushmanager_config 
                    (site_name, site_url, admin_email, api_server_url, api_key, vapid_public_key, push_icon_url, badge_icon_url, 
                     pwa_popup_title, pwa_popup_description, newpost_title, newpost_message, comment_title, comment_message, 
                     memo_title, memo_message, created_at) 
                    VALUES 
                    ('" . addslashes($site_name) . "', 
                     '" . addslashes($site_url) . "', 
                     '" . addslashes($admin_email) . "', 
                     '" . addslashes($api_server_url) . "', 
                     " . (!empty($api_key) ? "'" . addslashes($api_key) . "'" : 'NULL') . ", 
                     " . (!empty($vapid_public_key) ? "'" . addslashes($vapid_public_key) . "'" : 'NULL') . ", 
                     " . (!empty($push_icon_url) ? "'" . addslashes($push_icon_url) . "'" : 'NULL') . ", 
                     " . (!empty($badge_icon_url) ? "'" . addslashes($badge_icon_url) . "'" : 'NULL') . ", 
                     '" . addslashes($pwa_popup_title) . "', 
                     '" . addslashes($pwa_popup_description) . "', 
                     '" . addslashes($pwa_popup_skin) . "',
                     '" . addslashes($newpost_title) . "', 
                     '" . addslashes($newpost_message) . "', 
                     '" . addslashes($comment_title) . "', 
                     '" . addslashes($comment_message) . "', 
                     '" . addslashes($memo_title) . "', 
                     '" . addslashes($memo_message) . "', 
                     NOW())";
        }
        
        $result = sql_query($sql);
        
        if (!$result) {
            //throw new Exception('데이터베이스 저장 실패: ' . sql_error());
        }
        
        // 로그 기록
        $log_message = '기본 설정이 저장되었습니다.';
        if (!empty($api_key) || !empty($vapid_public_key)) {
            $log_message .= ' API 키, VAPID 키도 함께 설정되었습니다.';
        }
        if (!empty($push_icon_url) || !empty($badge_icon_url)) {
            $log_message .= ' 푸시 아이콘도 함께 업로드되었습니다.';
        }
        $log_message .= ' PWA 설정과 메시지 포맷도 함께 저장되었습니다.';
        
        log_pushmanager_activity('config', '설정 저장', $log_message);
        alert('설정이 저장되었습니다.', './api_config.php');
        
    } catch (Exception $e) {
        alert('설정 저장 중 오류가 발생했습니다.\n오류: ' . $e->getMessage(), './api_config.php');
    }
}

// 아이콘 삭제 처리
if (isset($_POST['delete_push_icon']) && $_POST['delete_push_icon']) {
    $config = get_pushmanager_config();
    
    if ($config && $config['push_icon_url']) {
        delete_icon_file($config['push_icon_url']);
        
        $sql = "UPDATE pushmanager_config SET 
                push_icon_url = NULL,
                updated_at = NOW()
                WHERE id = {$config['id']}";
        sql_query($sql);
        
        log_pushmanager_activity('config', '푸시 아이콘 삭제', '푸시 아이콘이 삭제되었습니다.');
        alert('푸시 아이콘이 삭제되었습니다.', './api_config.php');
    }
}

if (isset($_POST['delete_badge_icon']) && $_POST['delete_badge_icon']) {
    $config = get_pushmanager_config();
    
    if ($config && $config['badge_icon_url']) {
        delete_icon_file($config['badge_icon_url']);
        
        $sql = "UPDATE pushmanager_config SET 
                badge_icon_url = NULL,
                updated_at = NOW()
                WHERE id = {$config['id']}";
        sql_query($sql);
        
        log_pushmanager_activity('config', '뱃지 아이콘 삭제', '뱃지 아이콘이 삭제되었습니다.');
        alert('뱃지 아이콘이 삭제되었습니다.', './api_config.php');
    }
}

// 연결 테스트 처리
if (isset($_POST['test_connection']) && $_POST['test_connection']) {
    $config = get_pushmanager_config();
    
    if (!$config || !$config['api_key']) {
        alert('먼저 API 키를 설정해주세요.', './api_config.php');
    }
    
    try {
        $test_result = test_api_connection($config);
        
        if ($test_result['success']) {
            log_pushmanager_activity('config', '연결 테스트 성공', $test_result['message']);
            alert('API 서버 연결이 정상입니다.\n응답: ' . $test_result['message'], './api_config.php');
        } else {
            log_pushmanager_activity('error', '연결 테스트 실패', $test_result['message']);
            alert('API 서버 연결에 실패했습니다.\n오류: ' . $test_result['message'], './api_config.php');
        }
    } catch (Exception $e) {
        log_pushmanager_activity('error', '연결 테스트 오류', $e->getMessage());
        alert('연결 테스트 중 오류가 발생했습니다.\n오류: ' . $e->getMessage(), './api_config.php');
    }
}

// API 키 삭제 처리
if (isset($_POST['delete_api_key']) && $_POST['delete_api_key']) {
    $config = get_pushmanager_config();
    
    if ($config) {
        $sql = "UPDATE pushmanager_config SET 
                api_key = NULL,
                vapid_public_key = NULL,
                updated_at = NOW()
                WHERE id = {$config['id']}";
        sql_query($sql);
        
        log_pushmanager_activity('config', 'API 키 삭제', 'API 키와 VAPID 키가 삭제되었습니다.');
        
        alert('API 키가 삭제되었습니다.', './api_config.php');
    }
}

// 처리가 완료되지 않은 경우 (잘못된 접근)
alert('잘못된 접근입니다.', './api_config.php');
?>