<?php
$sub_menu = "750900";
include_once('./_common.php');

auth_check($auth[$sub_menu], 'w');

$g5['title'] = '데이터베이스 업데이트';

// 푸시매니저 데이터베이스 업데이트
$updated_count = 0;
$error_count = 0;
$update_messages = array();

// 1. pushmanager_board_notifications 테이블 생성
$table_name = 'pushmanager_board_notifications';
$check_sql = "SHOW TABLES LIKE '{$table_name}'";
$result = sql_query($check_sql, false);

if (!$result || sql_num_rows($result) == 0) {
    $create_sql = "
        CREATE TABLE `{$table_name}` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `member_id` varchar(20) NOT NULL COMMENT '관리자 회원 ID',
            `bo_table` varchar(20) NOT NULL COMMENT '게시판 테이블명',
            `is_active` tinyint(1) NOT NULL DEFAULT 1 COMMENT '알림 활성 상태',
            `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
            `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            UNIQUE KEY `unique_member_board` (`member_id`, `bo_table`),
            KEY `idx_member_id` (`member_id`),
            KEY `idx_bo_table` (`bo_table`),
            KEY `idx_is_active` (`is_active`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='새글 알림 설정'
    ";
    
    if (sql_query($create_sql, false)) {
        $updated_count++;
        $update_messages[] = "{$table_name} 테이블 생성 완료";
    } else {
        $error_count++;
        $update_messages[] = "{$table_name} 테이블 생성 실패: " . sql_error();
    }
} else {
    $update_messages[] = "{$table_name} 테이블은 이미 존재합니다";
}

// 2. pushmanager_user_settings 테이블 생성
$table_name2 = 'pushmanager_user_settings';
$check_sql2 = "SHOW TABLES LIKE '{$table_name2}'";
$result2 = sql_query($check_sql2, false);

if (!$result2 || sql_num_rows($result2) == 0) {
    $create_sql2 = "
        CREATE TABLE `{$table_name2}` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `member_id` varchar(20) DEFAULT NULL COMMENT '회원 ID (NULL = 비회원)',
            `session_id` varchar(64) DEFAULT NULL COMMENT '비회원 세션 ID',
            `message_notification` tinyint(1) NOT NULL DEFAULT 1 COMMENT '쪽지 알림 설정',
            `comment_notification` tinyint(1) NOT NULL DEFAULT 1 COMMENT '댓글 알림 설정',
            `inquiry_notification` tinyint(1) NOT NULL DEFAULT 1 COMMENT '1:1문의 답변 알림 설정',
            `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
            `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            UNIQUE KEY `unique_member` (`member_id`),
            UNIQUE KEY `unique_session` (`session_id`),
            KEY `idx_member_id` (`member_id`),
            KEY `idx_session_id` (`session_id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='사용자별 알림 설정'
    ";
    
    if (sql_query($create_sql2, false)) {
        $updated_count++;
        $update_messages[] = "{$table_name2} 테이블 생성 완료";
    } else {
        $error_count++;
        $update_messages[] = "{$table_name2} 테이블 생성 실패: " . sql_error();
    }
} else {
    $update_messages[] = "{$table_name2} 테이블은 이미 존재합니다";
}

// 3. pushmanager_config 테이블에 아이콘 컬럼 추가
$config_check = "SHOW TABLES LIKE 'pushmanager_config'";
$config_result = sql_query($config_check, false);

if ($config_result && sql_num_rows($config_result) > 0) {
    // push_icon_url 컬럼 확인
    $icon_column_check = "SHOW COLUMNS FROM pushmanager_config LIKE 'push_icon_url'";
    $icon_result = sql_query($icon_column_check, false);
    
    if (!$icon_result || sql_num_rows($icon_result) == 0) {
        // 아이콘 컬럼들 추가
        $add_icon_sql = "ALTER TABLE `pushmanager_config` 
                         ADD COLUMN `push_icon_url` varchar(500) DEFAULT NULL COMMENT '푸시 아이콘 URL' AFTER `vapid_public_key`,
                         ADD COLUMN `badge_icon_url` varchar(500) DEFAULT NULL COMMENT '뱃지 아이콘 URL' AFTER `push_icon_url`";
        
        if (sql_query($add_icon_sql, false)) {
            $updated_count++;
            $update_messages[] = "pushmanager_config 테이블에 아이콘 컬럼 추가 완료";
        } else {
            $error_count++;
            $update_messages[] = "pushmanager_config 테이블 아이콘 컬럼 추가 실패: " . sql_error();
        }
    } else {
        $update_messages[] = "pushmanager_config 테이블의 아이콘 컬럼은 이미 존재합니다";
    }
} else {
    $update_messages[] = "pushmanager_config 테이블이 존재하지 않습니다";
}

// 4. pushmanager_config 테이블에 PWA 설정 컬럼 추가
if ($config_result && sql_num_rows($config_result) > 0) {
    // pwa_popup_title 컬럼 확인
    $pwa_column_check = "SHOW COLUMNS FROM pushmanager_config LIKE 'pwa_popup_title'";
    $pwa_result = sql_query($pwa_column_check, false);
    
    if (!$pwa_result || sql_num_rows($pwa_result) == 0) {
        // PWA 설정 컬럼들 추가
        $add_pwa_sql = "ALTER TABLE `pushmanager_config` 
                        ADD COLUMN `pwa_popup_title` varchar(100) DEFAULT '앱 설치 안내' COMMENT 'PWA 팝업 타이틀' AFTER `badge_icon_url`,
                        ADD COLUMN `pwa_popup_description` text DEFAULT '홈 화면에 추가하여 앱처럼 편리하게 이용하세요!' COMMENT 'PWA 팝업 설명' AFTER `pwa_popup_title`";
        
        if (sql_query($add_pwa_sql, false)) {
            $updated_count++;
            $update_messages[] = "pushmanager_config 테이블에 PWA 설정 컬럼 추가 완료";
        } else {
            $error_count++;
            $update_messages[] = "pushmanager_config 테이블 PWA 설정 컬럼 추가 실패: " . sql_error();
        }
    } else {
        $update_messages[] = "pushmanager_config 테이블의 PWA 설정 컬럼은 이미 존재합니다";
    }
} else {
    $update_messages[] = "pushmanager_config 테이블이 존재하지 않습니다 (PWA 설정 컬럼 추가 건너뜀)";
}

// 5. pushmanager_config 테이블에 메시지 포맷 컬럼 추가 (NEW)
if ($config_result && sql_num_rows($config_result) > 0) {
    // newpost_title 컬럼 확인
    $format_column_check = "SHOW COLUMNS FROM pushmanager_config LIKE 'newpost_title'";
    $format_result = sql_query($format_column_check, false);
    
    if (!$format_result || sql_num_rows($format_result) == 0) {
        // 메시지 포맷 컬럼들 추가
        $add_format_sql = "ALTER TABLE `pushmanager_config` 
                          ADD COLUMN `newpost_title` varchar(100) DEFAULT '[{BOARD_NAME}] 새글 알림' COMMENT '새글 알림 타이틀 포맷' AFTER `pwa_popup_description`,
                          ADD COLUMN `newpost_message` text DEFAULT '{SENDER_NICKNAME}님이 새글을 작성했습니다.\\n제목: {POST_TITLE}' COMMENT '새글 알림 메시지 포맷' AFTER `newpost_title`,
                          ADD COLUMN `comment_title` varchar(100) DEFAULT '댓글 알림' COMMENT '댓글 알림 타이틀 포맷' AFTER `newpost_message`,
                          ADD COLUMN `comment_message` text DEFAULT '{SENDER_NICKNAME}님이 댓글을 남겼습니다.\\n원글: {POST_TITLE}\\n댓글: {COMMENT_CONTENT}' COMMENT '댓글 알림 메시지 포맷' AFTER `comment_title`,
                          ADD COLUMN `memo_title` varchar(100) DEFAULT '쪽지 알림' COMMENT '쪽지 알림 타이틀 포맷' AFTER `comment_message`,
                          ADD COLUMN `memo_message` text DEFAULT '{SENDER_NICKNAME}님으로부터 쪽지가 도착했습니다.\\n내용: {MEMO_CONTENT}' COMMENT '쪽지 알림 메시지 포맷' AFTER `memo_title`";
        
        if (sql_query($add_format_sql, false)) {
            $updated_count++;
            $update_messages[] = "pushmanager_config 테이블에 메시지 포맷 컬럼 추가 완료";
        } else {
            $error_count++;
            $update_messages[] = "pushmanager_config 테이블 메시지 포맷 컬럼 추가 실패: " . sql_error();
        }
    } else {
        $update_messages[] = "pushmanager_config 테이블의 메시지 포맷 컬럼은 이미 존재합니다";
    }
} else {
    $update_messages[] = "pushmanager_config 테이블이 존재하지 않습니다 (메시지 포맷 컬럼 추가 건너뜀)";
}

// 6. pushmanager_push_history 테이블 생성 (NEW)
$table_name3 = 'pushmanager_push_history';
$check_sql3 = "SHOW TABLES LIKE '{$table_name3}'";
$result3 = sql_query($check_sql3, false);

if (!$result3 || sql_num_rows($result3) == 0) {
    $create_sql3 = "
        CREATE TABLE `{$table_name3}` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `recipient_id` varchar(20) DEFAULT NULL COMMENT '수신자 회원 ID',
            `sender_id` varchar(20) DEFAULT NULL COMMENT '발신자 회원 ID (시스템인 경우 NULL)',
            `notification_type` varchar(20) NOT NULL COMMENT '알림 타입 (system, comment, message, inquiry)',
            `push_content` text NOT NULL COMMENT '푸시 메시지 내용',
            `related_table` varchar(50) DEFAULT NULL COMMENT '관련 테이블 (bo_table 등)',
            `related_id` int(11) DEFAULT NULL COMMENT '관련 ID (wr_id, me_id, qa_id 등)',
            `is_read` tinyint(1) NOT NULL DEFAULT 0 COMMENT '읽음 여부',
            `sent_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '발송 시간',
            `read_at` datetime DEFAULT NULL COMMENT '읽은 시간',
            PRIMARY KEY (`id`),
            KEY `idx_recipient_id` (`recipient_id`),
            KEY `idx_sender_id` (`sender_id`),
            KEY `idx_notification_type` (`notification_type`),
            KEY `idx_is_read` (`is_read`),
            KEY `idx_sent_at` (`sent_at`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='푸시 발송 이력'
    ";
    
    if (sql_query($create_sql3, false)) {
        $updated_count++;
        $update_messages[] = "{$table_name3} 테이블 생성 완료";
    } else {
        $error_count++;
        $update_messages[] = "{$table_name3} 테이블 생성 실패: " . sql_error();
    }
} else {
    $update_messages[] = "{$table_name3} 테이블은 이미 존재합니다";
}

// 7. 기타 푸시매니저 관련 테이블들도 체크 (선택사항)
$other_tables = array(
    'pushmanager_config' => "
        CREATE TABLE `pushmanager_config` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `site_name` varchar(100) NOT NULL COMMENT '사이트명',
            `site_url` varchar(255) NOT NULL COMMENT '사이트 URL',
            `admin_email` varchar(100) NOT NULL COMMENT '관리자 이메일',
            `api_server_url` varchar(255) NOT NULL COMMENT 'API 서버 URL',
            `api_key` varchar(255) DEFAULT NULL COMMENT 'API 키',
            `vapid_public_key` varchar(255) DEFAULT NULL COMMENT 'VAPID 공개키',
            `push_icon_url` varchar(500) DEFAULT NULL COMMENT '푸시 아이콘 URL',
            `badge_icon_url` varchar(500) DEFAULT NULL COMMENT '뱃지 아이콘 URL',
            `pwa_popup_title` varchar(100) DEFAULT '앱 설치 안내' COMMENT 'PWA 팝업 타이틀',
            `pwa_popup_description` text DEFAULT '홈 화면에 추가하여 앱처럼 편리하게 이용하세요!' COMMENT 'PWA 팝업 설명',
            `newpost_title` varchar(100) DEFAULT '[{BOARD_NAME}] 새글 알림' COMMENT '새글 알림 타이틀 포맷',
            `newpost_message` text DEFAULT '{SENDER_NICKNAME}님이 새글을 작성했습니다.\\n제목: {POST_TITLE}' COMMENT '새글 알림 메시지 포맷',
            `comment_title` varchar(100) DEFAULT '댓글 알림' COMMENT '댓글 알림 타이틀 포맷',
            `comment_message` text DEFAULT '{SENDER_NICKNAME}님이 댓글을 남겼습니다.\\n원글: {POST_TITLE}\\n댓글: {COMMENT_CONTENT}' COMMENT '댓글 알림 메시지 포맷',
            `memo_title` varchar(100) DEFAULT '쪽지 알림' COMMENT '쪽지 알림 타이틀 포맷',
            `memo_message` text DEFAULT '{SENDER_NICKNAME}님으로부터 쪽지가 도착했습니다.\\n내용: {MEMO_CONTENT}' COMMENT '쪽지 알림 메시지 포맷',
            `pwa_popup_skin` varchar(50) DEFAULT 'default' COMMENT 'PWA 팝업 스킨', 
            `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
            `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Push Manager 설정'
    ",
    
    'pushmanager_subscriptions' => "
        CREATE TABLE `pushmanager_subscriptions` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `member_id` varchar(20) DEFAULT NULL COMMENT '회원 ID',
            `endpoint` text NOT NULL COMMENT '구독 엔드포인트',
            `p256dh_key` varchar(255) NOT NULL COMMENT 'P256DH 키',
            `auth_key` varchar(255) NOT NULL COMMENT '인증 키',
            `user_agent` text DEFAULT NULL COMMENT '사용자 에이전트',
            `ip_address` varchar(45) DEFAULT NULL COMMENT 'IP 주소',
            `is_active` tinyint(1) NOT NULL DEFAULT 1 COMMENT '활성 상태',
            `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
            `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            UNIQUE KEY `unique_endpoint` (`endpoint`(255)),
            KEY `idx_member_id` (`member_id`),
            KEY `idx_is_active` (`is_active`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='푸시 구독 정보'
    ",
    
    'pushmanager_logs' => "
        CREATE TABLE `pushmanager_logs` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `type` varchar(20) NOT NULL COMMENT '로그 타입 (send, error, config)',
            `title` varchar(255) DEFAULT NULL COMMENT '푸시 제목',
            `message` text DEFAULT NULL COMMENT '푸시 메시지',
            `target_count` int(11) DEFAULT NULL COMMENT '발송 대상 수',
            `success_count` int(11) DEFAULT NULL COMMENT '성공 수',
            `error_count` int(11) DEFAULT NULL COMMENT '실패 수',
            `error_message` text DEFAULT NULL COMMENT '에러 메시지',
            `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            KEY `idx_type` (`type`),
            KEY `idx_created_at` (`created_at`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='푸시 관리 로그'
    ",

    'pushmanager_push_history' => "
        CREATE TABLE `pushmanager_push_history` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `recipient_id` varchar(20) DEFAULT NULL COMMENT '수신자 회원 ID',
            `sender_id` varchar(20) DEFAULT NULL COMMENT '발신자 회원 ID (시스템인 경우 NULL)',
            `notification_type` varchar(20) NOT NULL COMMENT '알림 타입 (system, comment, message, inquiry)',
            `push_content` text NOT NULL COMMENT '푸시 메시지 내용',
            `related_table` varchar(50) DEFAULT NULL COMMENT '관련 테이블 (bo_table 등)',
            `related_id` int(11) DEFAULT NULL COMMENT '관련 ID (wr_id, me_id, qa_id 등)',
            `is_read` tinyint(1) NOT NULL DEFAULT 0 COMMENT '읽음 여부',
            `sent_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '발송 시간',
            `read_at` datetime DEFAULT NULL COMMENT '읽은 시간',
            PRIMARY KEY (`id`),
            KEY `idx_recipient_id` (`recipient_id`),
            KEY `idx_sender_id` (`sender_id`),
            KEY `idx_notification_type` (`notification_type`),
            KEY `idx_is_read` (`is_read`),
            KEY `idx_sent_at` (`sent_at`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='푸시 발송 이력'
    "
);

// 기본 테이블들도 없으면 생성
foreach ($other_tables as $table_name => $create_sql) {
    $check_sql = "SHOW TABLES LIKE '{$table_name}'";
    $result = sql_query($check_sql, false);
    
    if (!$result || sql_num_rows($result) == 0) {
        if (sql_query($create_sql, false)) {
            $updated_count++;
            $update_messages[] = "{$table_name} 기본 테이블 생성 완료";
        } else {
            $error_count++;
            $update_messages[] = "{$table_name} 기본 테이블 생성 실패";
        }
    }
}

// 8. pushmanager_config 테이블에 PWA 스킨 설정 컬럼 추가 (NEW)
if ($config_result && sql_num_rows($config_result) > 0) {
    // pwa_popup_skin 컬럼 확인
    $skin_column_check = "SHOW COLUMNS FROM pushmanager_config LIKE 'pwa_popup_skin'";
    $skin_result = sql_query($skin_column_check, false);
    
    if (!$skin_result || sql_num_rows($skin_result) == 0) {
        // PWA 스킨 설정 컬럼 추가
        $add_skin_sql = "ALTER TABLE `pushmanager_config` 
                         ADD COLUMN `pwa_popup_skin` varchar(50) DEFAULT 'default' COMMENT 'PWA 팝업 스킨' AFTER `pwa_popup_description`";
        
        if (sql_query($add_skin_sql, false)) {
            $updated_count++;
            $update_messages[] = "pushmanager_config 테이블에 PWA 스킨 설정 컬럼 추가 완료";
        } else {
            $error_count++;
            $update_messages[] = "pushmanager_config 테이블 PWA 스킨 설정 컬럼 추가 실패: " . sql_error();
        }
    } else {
        $update_messages[] = "pushmanager_config 테이블의 PWA 스킨 설정 컬럼은 이미 존재합니다";
    }
} else {
    $update_messages[] = "pushmanager_config 테이블이 존재하지 않습니다 (PWA 스킨 설정 컬럼 추가 건너뜀)";
}

// 9. 푸시매니저 아이콘 업로드 디렉토리 생성
$upload_dir = G5_DATA_PATH . '/pushmanager_icons';
if (!is_dir($upload_dir)) {
    if (@mkdir($upload_dir, 0755, true)) {
        $updated_count++;
        $update_messages[] = "푸시매니저 아이콘 업로드 디렉토리 생성 완료 ({$upload_dir})";
        
        // .htaccess 파일 생성 (보안)
        $htaccess_content = "# 푸시매니저 업로드 디렉토리\n";
        $htaccess_content .= "Options -Indexes\n";
        $htaccess_content .= "<Files \"*.php\">\n";
        $htaccess_content .= "    Deny from all\n";
        $htaccess_content .= "</Files>\n";
        
        if (@file_put_contents($upload_dir . '/.htaccess', $htaccess_content)) {
            $update_messages[] = "업로드 디렉토리 보안 설정(.htaccess) 생성 완료";
        }
        
        if (@file_put_contents($upload_dir . '/index.html', '')) {
            $update_messages[] = "업로드 디렉토리 접근 차단(index.html) 생성 완료";
        }
    } else {
        $error_count++;
        $update_messages[] = "아이콘 업로드 디렉토리 생성 실패: {$upload_dir}";
    }
} else {
    $update_messages[] = "아이콘 업로드 디렉토리는 이미 존재합니다: {$upload_dir}";
}

// 10. 푸시매니저 메인 업로드 디렉토리도 생성
$main_upload_dir = G5_DATA_PATH . '/pushmanager';
if (!is_dir($main_upload_dir)) {
    if (@mkdir($main_upload_dir, 0755, true)) {
        $updated_count++;
        $update_messages[] = "푸시매니저 메인 업로드 디렉토리 생성 완료 ({$main_upload_dir})";
        
        // .htaccess 파일 생성 (보안)
        $htaccess_content = "# 푸시매니저 업로드 디렉토리\n";
        $htaccess_content .= "Options -Indexes\n";
        $htaccess_content .= "<Files \"*.php\">\n";
        $htaccess_content .= "    Deny from all\n";
        $htaccess_content .= "</Files>\n";
        
        @file_put_contents($main_upload_dir . '/.htaccess', $htaccess_content);
        @file_put_contents($main_upload_dir . '/index.html', '');
    } else {
        $error_count++;
        $update_messages[] = "메인 업로드 디렉토리 생성 실패: {$main_upload_dir}";
    }
} else {
    $update_messages[] = "메인 업로드 디렉토리는 이미 존재합니다: {$main_upload_dir}";
}

// 11. pushmanager_user_settings 테이블에 newpost_notification 컬럼 추가
$user_settings_check = "SHOW TABLES LIKE 'pushmanager_user_settings'";
$user_settings_result = sql_query($user_settings_check, false);

if ($user_settings_result && sql_num_rows($user_settings_result) > 0) {
    // newpost_notification 컬럼 확인
    $newpost_column_check = "SHOW COLUMNS FROM pushmanager_user_settings LIKE 'newpost_notification'";
    $newpost_result = sql_query($newpost_column_check, false);
    
    if (!$newpost_result || sql_num_rows($newpost_result) == 0) {
        // newpost_notification 컬럼 추가
        $add_newpost_sql = "ALTER TABLE `pushmanager_user_settings` 
                           ADD COLUMN `newpost_notification` tinyint(1) NOT NULL DEFAULT 1 COMMENT '새글 알림 설정' AFTER `inquiry_notification`";
        
        if (sql_query($add_newpost_sql, false)) {
            $updated_count++;
            $update_messages[] = "pushmanager_user_settings 테이블에 newpost_notification 컬럼 추가 완료";
        } else {
            $error_count++;
            $update_messages[] = "pushmanager_user_settings 테이블 newpost_notification 컬럼 추가 실패: " . sql_error();
        }
    } else {
        $update_messages[] = "pushmanager_user_settings 테이블의 newpost_notification 컬럼은 이미 존재합니다";
    }
} else {
    $update_messages[] = "pushmanager_user_settings 테이블이 존재하지 않습니다 (newpost_notification 컬럼 추가 건너뜀)";
}

// 결과 메시지 생성
$message_text = "푸시매니저 데이터베이스 업데이트 결과:\\n\\n";

if ($updated_count > 0) {
    $message_text .= "✓ 업데이트 완료: {$updated_count}개\\n";
}

if ($error_count > 0) {
    $message_text .= "✗ 오류 발생: {$error_count}개\\n";
}

$message_text .= "\\n상세 내용:\\n" . implode("\\n", $update_messages);

// 로그 기록 (pushmanager.lib.php가 있으면)
if (file_exists(G5_LIB_PATH.'/pushmanager.lib.php')) {
    include_once(G5_LIB_PATH.'/pushmanager.lib.php');
    
    if (function_exists('log_pushmanager_activity')) {
        log_pushmanager_activity('config', 'DB 업데이트', "업데이트: {$updated_count}개, 오류: {$error_count}개 (메시지 포맷팅 기능 포함)");
    }
}

// 업데이트 성공 시 추가 안내 메시지
if ($updated_count > 0) {
    $message_text .= "\\n\\n📌 추가된 기능:\\n";
    $message_text .= "• 사용자별 푸시 알림 이력 조회";
}

// 최종 알림 및 리다이렉트
if ($updated_count > 0 || $error_count == 0) {
    alert($message_text, './api_config.php');
} else {
    alert("데이터베이스 업데이트 중 오류가 발생했습니다.\\n\\n" . $message_text, './admin.php');
}
?>