<?php
$sub_menu = "750100";
include_once('./_common.php');

auth_check($auth[$sub_menu], 'w');

$g5['title'] = '푸시매니저 설치';
include_once(G5_ADMIN_PATH.'/admin.head.php');

// 설치 처리
if ($_POST['install']) {
    $sql_queries = array();
    
    // pushmanager_config 테이블 생성 (PWA 설정 컬럼 추가)
    $sql_queries[] = "
        CREATE TABLE IF NOT EXISTS `pushmanager_config` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `site_name` varchar(100) NOT NULL COMMENT '사이트명',
            `site_url` varchar(255) NOT NULL COMMENT '사이트 URL',
            `admin_email` varchar(100) NOT NULL COMMENT '관리자 이메일',
            `api_server_url` varchar(255) NOT NULL COMMENT 'API 서버 URL',
            `api_key` varchar(255) DEFAULT NULL COMMENT 'API 키',
            `vapid_public_key` varchar(255) DEFAULT NULL COMMENT 'VAPID 공개키',
            `push_icon_url` varchar(500) DEFAULT NULL COMMENT '푸시 아이콘 URL',
            `badge_icon_url` varchar(500) DEFAULT NULL COMMENT '뱃지 아이콘 URL',
            `pwa_popup_title` varchar(100) DEFAULT '앱 설치 안내' COMMENT 'PWA 팝업 타이틀',
            `pwa_popup_description` text DEFAULT '홈 화면에 추가하여 앱처럼 편리하게 이용하세요!' COMMENT 'PWA 팝업 설명',
            `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
            `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='푸시매니저 설정';
    ";
    
    // pushmanager_subscriptions 테이블 생성
    $sql_queries[] = "
        CREATE TABLE IF NOT EXISTS `pushmanager_subscriptions` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `member_id` varchar(20) DEFAULT NULL COMMENT '회원 ID',
            `endpoint` text NOT NULL COMMENT '구독 엔드포인트',
            `p256dh_key` varchar(255) NOT NULL COMMENT 'P256DH 키',
            `auth_key` varchar(255) NOT NULL COMMENT '인증 키',
            `user_agent` text DEFAULT NULL COMMENT '사용자 에이전트',
            `ip_address` varchar(45) DEFAULT NULL COMMENT 'IP 주소',
            `is_active` tinyint(1) NOT NULL DEFAULT 1 COMMENT '활성 상태',
            `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
            `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            UNIQUE KEY `unique_endpoint` (`endpoint`(255)),
            KEY `idx_member_id` (`member_id`),
            KEY `idx_is_active` (`is_active`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='푸시 구독 정보';
    ";
    
    // pushmanager_logs 테이블 생성
    $sql_queries[] = "
        CREATE TABLE IF NOT EXISTS `pushmanager_logs` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `type` varchar(20) NOT NULL COMMENT '로그 타입 (send, error, config)',
            `title` varchar(255) DEFAULT NULL COMMENT '푸시 제목',
            `message` text DEFAULT NULL COMMENT '푸시 메시지',
            `target_count` int(11) DEFAULT NULL COMMENT '발송 대상 수',
            `success_count` int(11) DEFAULT NULL COMMENT '성공 수',
            `error_count` int(11) DEFAULT NULL COMMENT '실패 수',
            `error_message` text DEFAULT NULL COMMENT '에러 메시지',
            `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            KEY `idx_type` (`type`),
            KEY `idx_created_at` (`created_at`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='푸시 관리 로그';
    ";
    
    // pushmanager_user_settings 테이블 생성
    $sql_queries[] = "
        CREATE TABLE IF NOT EXISTS `pushmanager_user_settings` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `member_id` varchar(20) DEFAULT NULL COMMENT '회원 ID (NULL = 비회원)',
            `session_id` varchar(64) DEFAULT NULL COMMENT '비회원 세션 ID',
            `message_notification` tinyint(1) NOT NULL DEFAULT 1 COMMENT '쪽지 알림 설정',
            `comment_notification` tinyint(1) NOT NULL DEFAULT 1 COMMENT '댓글 알림 설정',
            `inquiry_notification` tinyint(1) NOT NULL DEFAULT 1 COMMENT '1:1문의 답변 알림 설정',
            `newpost_notification` tinyint(1) NOT NULL DEFAULT 1 COMMENT '새글 알림 설정',
            `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
            `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            UNIQUE KEY `unique_member` (`member_id`),
            UNIQUE KEY `unique_session` (`session_id`),
            KEY `idx_member_id` (`member_id`),
            KEY `idx_session_id` (`session_id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='사용자별 알림 설정';
    ";

    // pushmanager_board_notifications 테이블 생성
    $sql_queries[] = "
        CREATE TABLE IF NOT EXISTS `pushmanager_board_notifications` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `member_id` varchar(20) NOT NULL COMMENT '관리자 회원 ID',
            `bo_table` varchar(20) NOT NULL COMMENT '게시판 테이블명',
            `is_active` tinyint(1) NOT NULL DEFAULT 1 COMMENT '알림 활성 상태',
            `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
            `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            UNIQUE KEY `unique_member_board` (`member_id`, `bo_table`),
            KEY `idx_member_id` (`member_id`),
            KEY `idx_bo_table` (`bo_table`),
            KEY `idx_is_active` (`is_active`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='새글 알림 설정';
    ";

    // pushmanager_push_history 테이블 생성
    $sql_queries[] = "
        CREATE TABLE IF NOT EXISTS `pushmanager_push_history` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `recipient_id` varchar(20) DEFAULT NULL COMMENT '수신자 회원 ID',
            `sender_id` varchar(20) DEFAULT NULL COMMENT '발신자 회원 ID (시스템인 경우 NULL)',
            `notification_type` varchar(20) NOT NULL COMMENT '알림 타입 (system, comment, message, inquiry)',
            `push_content` text NOT NULL COMMENT '푸시 메시지 내용',
            `related_table` varchar(50) DEFAULT NULL COMMENT '관련 테이블 (bo_table 등)',
            `related_id` int(11) DEFAULT NULL COMMENT '관련 ID (wr_id, me_id, qa_id 등)',
            `is_read` tinyint(1) NOT NULL DEFAULT 0 COMMENT '읽음 여부',
            `sent_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '발송 시간',
            `read_at` datetime DEFAULT NULL COMMENT '읽은 시간',
            PRIMARY KEY (`id`),
            KEY `idx_recipient_id` (`recipient_id`),
            KEY `idx_sender_id` (`sender_id`),
            KEY `idx_notification_type` (`notification_type`),
            KEY `idx_is_read` (`is_read`),
            KEY `idx_sent_at` (`sent_at`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='푸시 발송 이력';
    ";

    $install_success = true;
    $error_messages = array();
    
    foreach ($sql_queries as $sql) {
        $result = sql_query($sql, false);
        if (!$result) {
            $install_success = false;
            $error_messages[] = sql_error_info();
        }
    }
    
    // 푸시매니저 디렉토리 생성
    if ($install_success) {
        $upload_dir = G5_DATA_PATH . '/pushmanager/';
        if (!is_dir($upload_dir)) {
            if (!@mkdir($upload_dir, 0755, true)) {
                $install_success = false;
                $error_messages[] = '업로드 디렉토리 생성 실패: ' . $upload_dir;
            } else {
                // .htaccess 파일 생성 (보안을 위해)
                $htaccess_content = "# 푸시매니저 업로드 디렉토리\n";
                $htaccess_content .= "Options -Indexes\n";
                $htaccess_content .= "<Files \"*.php\">\n";
                $htaccess_content .= "    Deny from all\n";
                $htaccess_content .= "</Files>\n";
                
                @file_put_contents($upload_dir . '.htaccess', $htaccess_content);
                
                // index.html 파일 생성 (디렉토리 접근 차단)
                @file_put_contents($upload_dir . 'index.html', '');
            }
        }
    }
    
    if ($install_success) {
        alert('푸시매니저 설치가 완료되었습니다.\n아이콘 업로드 디렉토리도 생성되었습니다.', './api_config.php');
    } else {
        $error_msg = implode('\n', $error_messages);
        alert('설치 중 오류가 발생했습니다.\n' . $error_msg);
    }
}

// 설치 상태 확인
$is_installed = false;
$table_status = array();
$directory_status = array();

$tables = array('pushmanager_config', 'pushmanager_subscriptions', 'pushmanager_logs', 'pushmanager_user_settings', 'pushmanager_board_notifications', 'pushmanager_push_history');
foreach ($tables as $table) {
    $sql = "SHOW TABLES LIKE '$table'";
    $result = sql_query($sql, false);
    $table_status[$table] = sql_num_rows($result) > 0;
    if ($table_status[$table]) {
        $is_installed = true;
    }
}

// 디렉토리 상태 확인
$upload_dir = G5_DATA_PATH . '/pushmanager/';
$directory_status['exists'] = is_dir($upload_dir);
$directory_status['writable'] = is_writable($upload_dir);

// 기존 테이블에 PWA 컬럼이 있는지 확인 (업그레이드용)
$need_upgrade = false;
if ($table_status['pushmanager_config']) {
    $sql = "SHOW COLUMNS FROM pushmanager_config LIKE 'pwa_popup_title'";
    $result = sql_query($sql, false);
    if (sql_num_rows($result) == 0) {
        $need_upgrade = true;
    }
    
    // 기존 아이콘 컬럼 확인
    $sql = "SHOW COLUMNS FROM pushmanager_config LIKE 'push_icon_url'";
    $result = sql_query($sql, false);
    if (sql_num_rows($result) == 0) {
        $need_upgrade = true;
    }
}

// pushmanager_board_notifications 테이블 확인 (업그레이드용)
if (!$table_status['pushmanager_board_notifications'] && $is_installed) {
    $need_upgrade = true;
}

// 업그레이드 처리
if ($_POST['upgrade'] && $need_upgrade) {
    $upgrade_queries = array();
    
    // PWA 설정 컬럼 추가
    if ($table_status['pushmanager_config']) {
        $sql = "SHOW COLUMNS FROM pushmanager_config LIKE 'pwa_popup_title'";
        $result = sql_query($sql, false);
        if (sql_num_rows($result) == 0) {
            $upgrade_queries[] = "ALTER TABLE `pushmanager_config` 
                                 ADD COLUMN `pwa_popup_title` varchar(100) DEFAULT '앱 설치 안내' COMMENT 'PWA 팝업 타이틀' AFTER `badge_icon_url`,
                                 ADD COLUMN `pwa_popup_description` text DEFAULT '홈 화면에 추가하여 앱처럼 편리하게 이용하세요!' COMMENT 'PWA 팝업 설명' AFTER `pwa_popup_title`";
        }
        
        // 아이콘 컬럼 추가 (기존 기능)
        $sql = "SHOW COLUMNS FROM pushmanager_config LIKE 'push_icon_url'";
        $result = sql_query($sql, false);
        if (sql_num_rows($result) == 0) {
            $upgrade_queries[] = "ALTER TABLE `pushmanager_config` 
                                 ADD COLUMN `push_icon_url` varchar(500) DEFAULT NULL COMMENT '푸시 아이콘 URL' AFTER `vapid_public_key`,
                                 ADD COLUMN `badge_icon_url` varchar(500) DEFAULT NULL COMMENT '뱃지 아이콘 URL' AFTER `push_icon_url`";
        }
    }
    
    // pushmanager_board_notifications 테이블 생성 (새로운 기능)
    if (!$table_status['pushmanager_board_notifications']) {
        $upgrade_queries[] = "
            CREATE TABLE IF NOT EXISTS `pushmanager_board_notifications` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `member_id` varchar(20) NOT NULL COMMENT '관리자 회원 ID',
                `bo_table` varchar(20) NOT NULL COMMENT '게시판 테이블명',
                `is_active` tinyint(1) NOT NULL DEFAULT 1 COMMENT '알림 활성 상태',
                `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
                `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                PRIMARY KEY (`id`),
                UNIQUE KEY `unique_member_board` (`member_id`, `bo_table`),
                KEY `idx_member_id` (`member_id`),
                KEY `idx_bo_table` (`bo_table`),
                KEY `idx_is_active` (`is_active`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='새글 알림 설정'
        ";
    }
    
    $upgrade_success = true;
    $error_messages = array();
    
    foreach ($upgrade_queries as $sql) {
        $result = sql_query($sql, false);
        if (!$result) {
            $upgrade_success = false;
            $error_messages[] = sql_error_info();
        }
    }
    
    // 디렉토리 생성
    if ($upgrade_success) {
        $upload_dir = G5_DATA_PATH . '/pushmanager/';
        if (!is_dir($upload_dir)) {
            if (!@mkdir($upload_dir, 0755, true)) {
                $upgrade_success = false;
                $error_messages[] = '업로드 디렉토리 생성 실패: ' . $upload_dir;
            } else {
                // .htaccess 파일 생성
                $htaccess_content = "# 푸시매니저 업로드 디렉토리\n";
                $htaccess_content .= "Options -Indexes\n";
                $htaccess_content .= "<Files \"*.php\">\n";
                $htaccess_content .= "    Deny from all\n";
                $htaccess_content .= "</Files>\n";
                
                @file_put_contents($upload_dir . '.htaccess', $htaccess_content);
                @file_put_contents($upload_dir . 'index.html', '');
            }
        }
    }
    
    if ($upgrade_success) {
        alert('푸시매니저 업그레이드가 완료되었습니다.\nPWA 설정, 아이콘 업로드 기능과 게시판 알림 기능이 추가되었습니다.', './api_config.php');
    } else {
        $error_msg = implode('\n', $error_messages);
        alert('업그레이드 중 오류가 발생했습니다.\n' . $error_msg);
    }
}
?>

<div class="local_desc01 local_desc">
    <p>
        푸시매니저를 사용하기 위해 필요한 데이터베이스 테이블을 생성합니다.<br>
        설치 후 API 설정 페이지에서 푸시 서버와의 연동을 설정하세요.
    </p>
</div>

<div class="tbl_frm01 tbl_wrap">
    <table>
        <caption>푸시매니저 설치 상태</caption>
        <colgroup>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
            <tr>
                <th scope="row">설치 상태</th>
                <td>
                    <?php if ($is_installed): ?>
                        <span style="color: #28a745; font-weight: bold;">✓ 설치됨</span>
                        <?php if ($need_upgrade): ?>
                            <span style="color: #fd7e14; font-weight: bold; margin-left: 10px;">⚠ 업그레이드 필요</span>
                        <?php endif; ?>
                    <?php else: ?>
                        <span style="color: #dc3545; font-weight: bold;">✗ 미설치</span>
                    <?php endif; ?>
                </td>
            </tr>
            <?php foreach ($tables as $table): ?>
            <tr>
                <th scope="row"><?php echo $table ?> 테이블</th>
                <td>
                    <?php if ($table_status[$table]): ?>
                        <span style="color: #28a745;">✓ 생성됨</span>
                    <?php else: ?>
                        <span style="color: #dc3545;">✗ 미생성</span>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; ?>
            <tr>
                <th scope="row">업로드 디렉토리</th>
                <td>
                    <?php if ($directory_status['exists']): ?>
                        <span style="color: #28a745;">✓ 생성됨</span>
                        <?php if ($directory_status['writable']): ?>
                            <span style="color: #28a745; margin-left: 10px;">✓ 쓰기 가능</span>
                        <?php else: ?>
                            <span style="color: #dc3545; margin-left: 10px;">✗ 쓰기 불가</span>
                        <?php endif; ?>
                    <?php else: ?>
                        <span style="color: #dc3545;">✗ 미생성</span>
                    <?php endif; ?>
                    <div style="font-size: 11px; color: #666; margin-top: 3px;">
                        <?php echo $upload_dir ?>
                    </div>
                </td>
            </tr>
            <?php if ($need_upgrade): ?>
            <tr>
                <th scope="row">업그레이드 필요</th>
                <td>
                    <span style="color: #fd7e14; font-weight: bold;">⚠ 업그레이드 필요</span>
                    <div style="font-size: 11px; color: #666; margin-top: 3px;">
                        <?php if (!$table_status['pushmanager_board_notifications']): ?>
                            게시판 알림 기능이 누락되었습니다.<br>
                        <?php endif; ?>
                        <?php 
                        if ($table_status['pushmanager_config']) {
                            $sql = "SHOW COLUMNS FROM pushmanager_config LIKE 'pwa_popup_title'";
                            $result = sql_query($sql, false);
                            if (sql_num_rows($result) == 0) {
                                echo "PWA 설정 기능이 누락되었습니다.<br>";
                            }
                            
                            $sql = "SHOW COLUMNS FROM pushmanager_config LIKE 'push_icon_url'";
                            $result = sql_query($sql, false);
                            if (sql_num_rows($result) == 0) {
                                echo "아이콘 업로드 기능이 누락되었습니다.<br>";
                            }
                        }
                        ?>
                        업그레이드를 진행해주세요.
                    </div>
                </td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php if (!$is_installed): ?>
<form name="finstall" method="post">
    <div class="btn_fixed_top">
        <input type="submit" name="install" value="설치하기" class="btn_submit btn" onclick="return confirm('푸시매니저를 설치하시겠습니까?');">
    </div>
</form>
<?php elseif ($need_upgrade): ?>
<form name="fupgrade" method="post">
    <div class="btn_fixed_top">
        <input type="submit" name="upgrade" value="업그레이드" class="btn_submit btn" onclick="return confirm('푸시매니저를 업그레이드하시겠습니까?\\nPWA 설정, 게시판 알림 기능과 아이콘 업로드 기능이 추가됩니다.');">
        <a href="./api_config.php" class="btn btn_02">API 설정으로 이동</a>
    </div>
</form>
<?php else: ?>
<div class="btn_fixed_top">
    <a href="./api_config.php" class="btn btn_01">API 설정으로 이동</a>
</div>
<?php endif; ?>

<div class="local_desc02 local_desc">
    <h2>주요 변경사항</h2>
    <ul>
        <li><strong>PWA 설정 기능 추가:</strong> PWA 설치 유도 팝업의 타이틀과 설명 문구를 관리자가 설정할 수 있습니다.</li>
        <li><strong>게시판 알림 기능 추가:</strong> 관리자가 특정 게시판에 새글이 등록될 때 알림을 받을 수 있습니다.</li>
        <li><strong>아이콘 업로드 기능 추가:</strong> 푸시 알림용 아이콘과 뱃지 아이콘을 업로드할 수 있습니다.</li>
        <li><strong>업로드 디렉토리 생성:</strong> /data/pushmanager/ 디렉토리에 아이콘 파일이 저장됩니다.</li>
        <li><strong>보안 강화:</strong> 업로드 디렉토리에 .htaccess 파일을 생성하여 직접 접근을 차단합니다.</li>
        <li><strong>지원 형식:</strong> PNG, JPG, JPEG, GIF, ICO, SVG 파일을 지원합니다.</li>
    </ul>
</div>

<?php
include_once(G5_ADMIN_PATH.'/admin.tail.php');
?>