<?php
include_once('./_common.php');
include_once(G5_LIB_PATH.'/pushmanager.lib.php');

// 관리자 권한 확인
if (!$is_admin) {
    header('Content-Type: application/json; charset=utf-8');
    http_response_code(403);
    echo json_encode(array('success' => false, 'message' => '관리자 권한이 필요합니다.'));
    exit;
}

header('Content-Type: application/json; charset=utf-8');

$action = $_GET['action'] ?? '';

switch ($action) {
    case 'check_member':
        check_member();
        break;
        
    case 'get_level_count':
        get_level_count();
        break;
        
    case 'get_gender_count':
        get_gender_count();
        break;
        
    case 'search_members':
        search_members();
        break;
        
    default:
        http_response_code(400);
        echo json_encode(array('success' => false, 'message' => '지원하지 않는 액션입니다.'));
        exit;
}

/**
 * 회원 존재 및 구독 여부 확인
 */
function check_member() {
    global $g5;
    
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        http_response_code(405);
        echo json_encode(array('success' => false, 'message' => 'POST 메서드만 허용됩니다.'));
        exit;
    }
    
    $input = json_decode(file_get_contents('php://input'), true);
    $member_id = clean_xss_tags($input['member_id']);
    
    if (empty($member_id)) {
        echo json_encode(array('success' => false, 'message' => '회원 아이디가 필요합니다.'));
        exit;
    }
    
    // 회원 존재 확인
    $sql = "SELECT mb_id, mb_name FROM {$g5['member_table']} WHERE mb_id = '{$member_id}'";
    $member = sql_fetch($sql);
    
    if (!$member) {
        echo json_encode(array('success' => false, 'message' => '존재하지 않는 회원입니다.'));
        exit;
    }
    
    // 구독 여부 확인
    $sql = "SELECT COUNT(*) as cnt FROM pushmanager_subscriptions WHERE member_id = '{$member_id}' AND is_active = 1";
    $subscription_result = sql_fetch($sql);
    $has_subscription = $subscription_result['cnt'] > 0;
    
    echo json_encode(array(
        'success' => true,
        'data' => array(
            'member_id' => $member['mb_id'],
            'member_name' => $member['mb_name'],
            'has_subscription' => $has_subscription
        )
    ));
    exit;
}

/**
 * 레벨별 회원 수 조회
 */
function get_level_count() {
    global $g5;
    
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        http_response_code(405);
        echo json_encode(array('success' => false, 'message' => 'POST 메서드만 허용됩니다.'));
        exit;
    }
    
    $input = json_decode(file_get_contents('php://input'), true);
    $level = intval($input['level']);
    
    if ($level < 1) {
        echo json_encode(array('success' => false, 'message' => '올바른 레벨이 필요합니다.'));
        exit;
    }
    
    // 해당 레벨 총 회원 수
    $sql = "SELECT COUNT(*) as cnt FROM {$g5['member_table']} WHERE mb_level = {$level}";
    $total_result = sql_fetch($sql);
    $total_members = $total_result['cnt'];
    
    // 해당 레벨 구독자 수
    $sql = "SELECT COUNT(DISTINCT ps.member_id) as cnt 
            FROM pushmanager_subscriptions ps 
            INNER JOIN {$g5['member_table']} m ON ps.member_id = m.mb_id 
            WHERE m.mb_level = {$level} AND ps.is_active = 1";
    $subscription_result = sql_fetch($sql);
    $subscription_count = $subscription_result['cnt'];
    
    echo json_encode(array(
        'success' => true,
        'data' => array(
            'level' => $level,
            'total_members' => $total_members,
            'subscription_count' => $subscription_count
        )
    ));
    exit;
}

/**
 * 성별 회원 수 조회
 */
function get_gender_count() {
    global $g5;
    
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        http_response_code(405);
        echo json_encode(array('success' => false, 'message' => 'POST 메서드만 허용됩니다.'));
        exit;
    }
    
    $input = json_decode(file_get_contents('php://input'), true);
    $gender = clean_xss_tags($input['gender']);
    
    if (!in_array($gender, array('M', 'F'))) {
        echo json_encode(array('success' => false, 'message' => '올바른 성별이 필요합니다.'));
        exit;
    }
    
    // 해당 성별 총 회원 수
    $sql = "SELECT COUNT(*) as cnt FROM {$g5['member_table']} WHERE mb_sex = '{$gender}'";
    $total_result = sql_fetch($sql);
    $total_members = $total_result['cnt'];
    
    // 해당 성별 구독자 수
    $sql = "SELECT COUNT(DISTINCT ps.member_id) as cnt 
            FROM pushmanager_subscriptions ps 
            INNER JOIN {$g5['member_table']} m ON ps.member_id = m.mb_id 
            WHERE m.mb_sex = '{$gender}' AND ps.is_active = 1";
    $subscription_result = sql_fetch($sql);
    $subscription_count = $subscription_result['cnt'];
    
    echo json_encode(array(
        'success' => true,
        'data' => array(
            'gender' => $gender,
            'total_members' => $total_members,
            'subscription_count' => $subscription_count
        )
    ));
    exit;
}

/**
 * 회원 검색
 */
function search_members() {
    global $g5;
    
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        http_response_code(405);
        echo json_encode(array('success' => false, 'message' => 'POST 메서드만 허용됩니다.'));
        exit;
    }
    
    $input = json_decode(file_get_contents('php://input'), true);
    $search = clean_xss_tags($input['search']);
    
    if (empty($search)) {
        echo json_encode(array('success' => false, 'message' => '검색어가 필요합니다.'));
        exit;
    }
    
    // 회원 검색 (아이디, 이름, 이메일)
    $search_sql = "SELECT m.mb_id, m.mb_name, m.mb_email,
                          (SELECT COUNT(*) FROM pushmanager_subscriptions ps 
                           WHERE ps.member_id = m.mb_id AND ps.is_active = 1) as has_subscription
                   FROM {$g5['member_table']} m 
                   WHERE (m.mb_id LIKE '%{$search}%' 
                          OR m.mb_name LIKE '%{$search}%' 
                          OR m.mb_email LIKE '%{$search}%')
                   ORDER BY m.mb_datetime DESC 
                   LIMIT 20";
    
    $result = sql_query($search_sql);
    $members = array();
    
    while ($row = sql_fetch_array($result)) {
        $members[] = array(
            'mb_id' => $row['mb_id'],
            'mb_name' => $row['mb_name'],
            'mb_email' => $row['mb_email'],
            'has_subscription' => $row['has_subscription'] > 0
        );
    }
    
    echo json_encode(array(
        'success' => true,
        'data' => array(
            'search' => $search,
            'members' => $members,
            'count' => count($members)
        )
    ));
    exit;
}
?>