<?php
$sub_menu = '750500';

include_once('./_common.php');
include_once(G5_LIB_PATH.'/pushmanager.lib.php');

auth_check_menu($auth, $sub_menu, "r");

$g5['title'] = '푸시매니저 새글 알림 현황';
include_once(G5_ADMIN_PATH.'/admin.head.php');

// 설정 확인
$config = get_pushmanager_config();
if (!$config) {
    alert('푸시매니저 설정이 필요합니다.', './api_config.php');
}

// 새글 알림 설정 테이블이 없으면 생성
$table_exists = false;
$sql = "SHOW TABLES LIKE 'pushmanager_board_notifications'";
$result = sql_query($sql, false);
if ($result && sql_num_rows($result) > 0) {
    $table_exists = true;
}

if (!$table_exists) {
    $create_sql = "
        CREATE TABLE IF NOT EXISTS `pushmanager_board_notifications` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `member_id` varchar(20) NOT NULL COMMENT '관리자 회원 ID',
            `bo_table` varchar(20) NOT NULL COMMENT '게시판 테이블명',
            `is_active` tinyint(1) NOT NULL DEFAULT 1 COMMENT '알림 활성 상태',
            `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
            `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            UNIQUE KEY `unique_member_board` (`member_id`, `bo_table`),
            KEY `idx_member_id` (`member_id`),
            KEY `idx_bo_table` (`bo_table`),
            KEY `idx_is_active` (`is_active`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='새글 알림 설정';
    ";
    
    if (!sql_query($create_sql, false)) {
        alert('새글 알림 테이블 생성에 실패했습니다.');
    }
}

// 게시판 목록 조회
$boards = array();
$sql = "SELECT bo_table, bo_subject, bo_admin, bo_list_level, bo_write_level 
        FROM {$g5['board_table']} 
        ORDER BY bo_table ASC";
$result = sql_query($sql);
if ($result) {
    while ($row = sql_fetch_array($result)) {
        $boards[] = $row;
    }
}

// 디버그: 게시판 개수 확인
if (empty($boards)) {
    // 테이블명 직접 확인
    $test_sql = "SHOW TABLES LIKE '{$g5['board_table']}'";
    $test_result = sql_query($test_sql, false);
    
    if (!$test_result || sql_num_rows($test_result) == 0) {
        // 일반적인 그누보드 테이블명으로 재시도
        $sql = "SELECT bo_table, bo_subject, bo_admin, bo_list_level, bo_write_level 
                FROM g5_board 
                ORDER BY bo_table ASC";
        $result = sql_query($sql, false);
        if ($result) {
            while ($row = sql_fetch_array($result)) {
                $boards[] = $row;
            }
        }
    }
}

// 전체 통계 조회
$total_stats_sql = "SELECT 
                COUNT(DISTINCT member_id) as total_admin_count,
                COUNT(DISTINCT bo_table) as total_board_count,
                COUNT(*) as total_settings
              FROM pushmanager_board_notifications 
              WHERE is_active = 1";
$total_stats = sql_fetch($total_stats_sql);

// 게시판별 알림 등록 현황 조회 (모든 게시판을 LEFT JOIN으로 포함)
$all_boards_with_stats = array();
$notification_stats = array();

// 먼저 알림 등록 현황을 배열로 저장
$sql = "SELECT bo_table, COUNT(*) as admin_count
        FROM pushmanager_board_notifications 
        WHERE is_active = 1 
        GROUP BY bo_table";
$result = sql_query($sql);
while ($row = sql_fetch_array($result)) {
    $notification_stats[$row['bo_table']] = intval($row['admin_count']);
}

// 모든 게시판과 알림 통계를 합침
foreach ($boards as $board) {
    $admin_count = $notification_stats[$board['bo_table']] ?? 0;
    $all_boards_with_stats[] = array(
        'bo_table' => $board['bo_table'],
        'bo_subject' => $board['bo_subject'],
        'bo_admin' => $board['bo_admin'],
        'bo_list_level' => $board['bo_list_level'],
        'bo_write_level' => $board['bo_write_level'],
        'admin_count' => $admin_count
    );
}

// 등록자 수 내림차순으로 정렬
usort($all_boards_with_stats, function($a, $b) {
    if ($a['admin_count'] == $b['admin_count']) {
        return strcmp($a['bo_subject'] ?: $a['bo_table'], $b['bo_subject'] ?: $b['bo_table']);
    }
    return $b['admin_count'] - $a['admin_count'];
});

// 등록된 게시판과 미등록 게시판 분리 (통계용)
$boards_with_notification = array_filter($all_boards_with_stats, function($board) {
    return $board['admin_count'] > 0;
});

$boards_without_notification = array_filter($all_boards_with_stats, function($board) {
    return $board['admin_count'] == 0;
});

// 최근 알림 등록 현황 (일자별)
$recent_stats_sql = "SELECT 
                DATE(created_at) as date,
                COUNT(*) as daily_count
                FROM pushmanager_board_notifications 
                WHERE is_active = 1 
                AND created_at >= DATE_SUB(NOW(), INTERVAL 30 DAY)
                GROUP BY DATE(created_at)
                ORDER BY date DESC
                LIMIT 10";
$recent_stats = array();
$result = sql_query($recent_stats_sql);
while ($row = sql_fetch_array($result)) {
    $recent_stats[] = $row;
}
?>

<div class="local_desc01 local_desc">
    <p>
        새글 알림이 등록된 게시판별 현황을 확인할 수 있습니다.<br>
        개인정보 보호를 위해 회원별 정보는 표시하지 않으며, 게시판별 알림 등록자 수만 표시됩니다.
    </p>
</div>

<!-- 전체 통계 -->
<div class="tbl_frm01 tbl_wrap">
    <table>
        <caption>새글 알림 전체 현황</caption>
        <colgroup>
            <col class="grid_4">
            <col>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
            <tr>
                <th scope="row">알림 등록 관리자</th>
                <td><strong class="fc_373"><?php echo number_format($total_stats['total_admin_count']) ?>명</strong></td>
                <th scope="row">알림 등록 게시판</th>
                <td><strong class="fc_373"><?php echo number_format(count($boards_with_notification)) ?>개</strong></td>
            </tr>
            <tr>
                <th scope="row">전체 게시판</th>
                <td>
                    <strong><?php echo number_format(count($boards)) ?>개</strong>
                    <?php if (empty($boards)): ?>
                        <div style="color:#dc3545; font-size:11px; margin-top:3px;">
                            ⚠ 게시판을 불러올 수 없습니다.<br>
                            테이블: <?php echo $g5['board_table'] ?>
                        </div>
                    <?php endif; ?>
                </td>
                <th scope="row">미등록 게시판</th>
                <td>
                    <strong><?php echo number_format(count($boards_without_notification)) ?>개</strong>
                    <span style="color:#666;">(<?php echo count($boards) > 0 ? round((count($boards_without_notification) / count($boards)) * 100, 1) : 0 ?>%)</span>
                </td>
            </tr>
            <tr>
                <th scope="row">전체 알림 설정</th>
                <td colspan="3"><?php echo number_format($total_stats['total_settings']) ?>개</td>
            </tr>
        </tbody>
    </table>
</div>

<!-- 게시판별 알림 등록 현황 (통합 테이블) -->
<div class="tbl_head01 tbl_wrap" style="margin-top:30px;">
    <table>
        <caption>전체 게시판 새글 알림 현황 (등록자 수 순)</caption>
        <thead>
        <tr>
            <th scope="col">게시판명</th>
            <th scope="col">등록자 수</th>
            <th scope="col">권한</th>
        </tr>
        </thead>
        <tbody>
        <?php
        if (!empty($all_boards_with_stats)) {
            foreach ($all_boards_with_stats as $board) {
                $has_notification = $board['admin_count'] > 0;
        ?>
        <tr<?php echo !$has_notification ? ' style="background:#f8f9fa;"' : '' ?>>
            <td class="td_left">
                <div style="font-weight:bold; margin-bottom:3px;">
                    <?php echo $board['bo_subject'] ?: $board['bo_table'] ?>
                </div>
                <?php if ($board['bo_subject'] && $board['bo_subject'] !== $board['bo_table']): ?>
                <div style="font-size:11px; color:#666;">
                    <?php echo $board['bo_table'] ?>
                </div>
                <?php endif; ?>
            </td>
            <td class="td_center">
                <?php if ($has_notification): ?>
                    <strong class="fc_373" style="font-size:16px;">
                        <?php echo number_format($board['admin_count']) ?>명
                    </strong>
                <?php else: ?>
                    <span style="color:#999; font-size:14px;">0명</span>
                <?php endif; ?>
            </td>
            <td class="td_center" style="font-size:11px;">
                읽기: <?php echo $board['bo_list_level'] ?><br>
                쓰기: <?php echo $board['bo_write_level'] ?>
            </td>
        </tr>
        <?php
            }
        } else {
        ?>
        <tr>
            <td colspan="6" class="empty_table">게시판이 없습니다.</td>
        </tr>
        <?php } ?>
        </tbody>
    </table>
</div>

<!-- 최근 등록 현황 -->
<?php if (!empty($recent_stats)): ?>
<div class="tbl_frm01 tbl_wrap" style="margin-top:30px;">
    <table>
        <caption>최근 30일 알림 등록 현황</caption>
        <thead>
        <tr>
            <th scope="col">날짜</th>
            <th scope="col">신규 등록 수</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($recent_stats as $stat): ?>
        <tr>
            <td class="td_center"><?php echo $stat['date'] ?></td>
            <td class="td_center">
                <strong class="fc_373"><?php echo number_format($stat['daily_count']) ?>개</strong>
            </td>
        </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
<?php endif; ?>

<!-- 게시판별 상세 통계 차트 -->
<div class="tbl_frm01 tbl_wrap" style="margin-top:30px;">
    <table>
        <caption>알림 등록 현황 요약</caption>
        <tbody>
            <tr>
                <th scope="row">등록자가 많은 게시판</th>
                <td>
                    <?php
                    $top_boards = array_slice($boards_with_notification, 0, 5);
                    if (!empty($top_boards)) {
                        $top_board_info = array();
                        foreach ($top_boards as $board) {
                            $top_board_info[] = ($board['bo_subject'] ?: $board['bo_table']) . ' (' . $board['admin_count'] . '명)';
                        }
                        echo implode(' | ', $top_board_info);
                    } else {
                        echo '<span style="color:#999;">등록된 게시판이 없습니다.</span>';
                    }
                    ?>
                </td>
            </tr>
            <tr>
                <th scope="row">등록률</th>
                <td>
                    <?php
                    $registration_rate = count($boards) > 0 ? round((count($boards_with_notification) / count($boards)) * 100, 1) : 0;
                    $rate_color = $registration_rate >= 70 ? '#28a745' : ($registration_rate >= 40 ? '#ffc107' : '#dc3545');
                    ?>
                    <strong style="color:<?php echo $rate_color ?>; font-size:16px;">
                        <?php echo $registration_rate ?>%
                    </strong>
                    <span style="color:#666; margin-left:10px;">
                        (<?php echo count($boards_with_notification) ?>/<?php echo count($boards) ?>개 게시판)
                    </span>
                </td>
            </tr>
            <tr>
                <th scope="row">평균 등록자 수</th>
                <td>
                    <?php
                    $avg_admins = count($boards_with_notification) > 0 ? 
                        round($total_stats['total_settings'] / count($boards_with_notification), 1) : 0;
                    ?>
                    <strong class="fc_373"><?php echo $avg_admins ?>명</strong>
                    <span style="color:#666; margin-left:10px;">게시판당 평균</span>
                </td>
            </tr>
        </tbody>
    </table>
</div>

<!-- 안내 정보 -->
<div class="local_desc02 local_desc" style="margin-top:30px;">
    <h2>새글 알림 현황 안내</h2>
    <ul>
        <li><strong>등록자 수:</strong> 각 게시판별로 새글 알림을 등록한 관리자 수입니다.</li>
        <li><strong>개인정보 보호:</strong> 개별 회원 정보는 표시되지 않으며, 통계 정보만 제공됩니다.</li>
        <li><strong>알림 작동:</strong> 등록된 게시판에 새글이 올라오면 해당 관리자들에게 푸시 알림이 발송됩니다.</li>
        <li><strong>미등록 게시판:</strong> 아직 알림이 등록되지 않은 게시판들을 확인할 수 있습니다.</li>
        <li><strong>등록률:</strong> 전체 게시판 중 알림이 등록된 게시판의 비율입니다.</li>
    </ul>
</div>

<script>
// 통계 차트나 추가 기능을 위한 데이터 (필요시 활용)
var allBoardStats = <?php echo json_encode($all_boards_with_stats); ?>;
var totalBoards = <?php echo count($boards); ?>;
var registrationRate = <?php echo $registration_rate ?? 0; ?>;

// 상세 정보 토글 기능
function toggleDetails(element) {
    var details = element.nextElementSibling;
    if (details && details.style.display === 'none') {
        details.style.display = 'block';
        element.innerHTML = element.innerHTML.replace('▶', '▼');
    } else if (details) {
        details.style.display = 'none';
        element.innerHTML = element.innerHTML.replace('▼', '▶');
    }
}

// 검색 기능
function searchBoards() {
    var input = document.getElementById('boardSearch');
    var filter = input.value.toUpperCase();
    var tables = document.querySelectorAll('.tbl_head01 table');
    
    tables.forEach(function(table) {
        var rows = table.querySelectorAll('tbody tr');
        rows.forEach(function(row) {
            var boardName = row.cells[1] ? row.cells[1].textContent.toUpperCase() : '';
            var tableName = row.cells[2] ? row.cells[2].textContent.toUpperCase() : '';
            
            if (boardName.indexOf(filter) > -1 || tableName.indexOf(filter) > -1) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    });
}

// 페이지 로딩 시 통계 애니메이션 효과
document.addEventListener('DOMContentLoaded', function() {
    // 숫자 카운트업 애니메이션
    var numbers = document.querySelectorAll('.fc_373');
    numbers.forEach(function(number) {
        var target = parseInt(number.textContent.replace(/[^\d]/g, ''));
        if (target > 0) {
            var current = 0;
            var increment = target / 50;
            var timer = setInterval(function() {
                current += increment;
                if (current >= target) {
                    number.textContent = number.textContent.replace(/\d+/, target.toLocaleString());
                    clearInterval(timer);
                } else {
                    number.textContent = number.textContent.replace(/\d+/, Math.floor(current).toLocaleString());
                }
            }, 20);
        }
    });
});
</script>

<?php
include_once(G5_ADMIN_PATH.'/admin.tail.php');
?>