<?php
include_once('./_common.php');
include_once(G5_LIB_PATH.'/pushmanager.lib.php');

// 관리자 권한 확인
if (!$is_admin) {
    http_response_code(403);
    echo '<div style="text-align:center; color:#dc3545;">관리자 권한이 필요합니다.</div>';
    exit;
}

$member_key = clean_xss_tags($_POST['member_key']);

if (empty($member_key)) {
    echo '<div style="text-align:center; color:#dc3545;">회원 정보가 필요합니다.</div>';
    exit;
}

// 엔드포인트 마스킹 함수
function mask_endpoint($endpoint) {
    if (empty($endpoint)) return '';
    
    $url_parts = parse_url($endpoint);
    $domain = $url_parts['host'] ?? '';
    $path = $url_parts['path'] ?? '';
    
    // 도메인과 처음 몇 글자, 마지막 몇 글자만 표시
    if (strlen($path) > 20) {
        $masked_path = substr($path, 0, 10) . '***' . substr($path, -7);
    } else {
        $masked_path = substr($path, 0, 5) . '***';
    }
    
    return $domain . $masked_path;
}

// 단말기 삭제 처리
if ($_POST['delete_device_modal']) {
    $subscription_id = intval($_POST['subscription_id']);
    
    if ($subscription_id > 0) {
        $sql = "DELETE FROM pushmanager_subscriptions WHERE id = {$subscription_id}";
        $result = sql_query($sql);
        
        if ($result) {
            log_pushmanager_activity('config', '단말기 구독 삭제', "구독 ID: {$subscription_id}");
            echo '<script>alert("해당 단말기의 구독이 삭제되었습니다."); parent.location.reload();</script>';
            exit;
        } else {
            echo '<script>alert("구독 삭제에 실패했습니다.");</script>';
        }
    }
}

// 회원인지 비회원인지 구분
$is_guest = strpos($member_key, 'guest_') === 0;

if ($is_guest) {
    // 비회원의 경우
    $guest_id = substr($member_key, 6); // 'guest_' 제거
    $sql = "SELECT ps.*, NULL as mb_name, NULL as mb_email, NULL as mb_level 
            FROM pushmanager_subscriptions ps 
            WHERE ps.id = {$guest_id}
            ORDER BY ps.created_at DESC";
} else {
    // 회원의 경우
    $sql = "SELECT ps.*, m.mb_name, m.mb_email, m.mb_level 
            FROM pushmanager_subscriptions ps 
            LEFT JOIN {$g5['member_table']} m ON ps.member_id = m.mb_id 
            WHERE ps.member_id = '" . addslashes($member_key) . "'
            ORDER BY ps.created_at DESC";
}

$result = sql_query($sql);
$device_count = sql_num_rows($result);

if ($device_count == 0) {
    echo '<div style="text-align:center; color:#999;">등록된 단말기가 없습니다.</div>';
    exit;
}

// 회원 정보 표시
$first_row = sql_fetch_array($result);
sql_data_seek($result, 0); // 결과셋 포인터를 처음으로 되돌림
?>

<div style="margin-bottom:15px; padding:10px; background:#f8f9fa; border-radius:3px;">
    <?php if (!$is_guest): ?>
        <strong style="color:#333;">회원 ID:</strong> <?php echo $member_key ?><br>
        <?php if ($first_row['mb_name']): ?>
        <strong style="color:#333;">회원명:</strong> <?php echo $first_row['mb_name'] ?><br>
        <?php endif; ?>
        <?php if ($first_row['mb_level']): ?>
        <strong style="color:#333;">레벨:</strong> <?php echo $first_row['mb_level'] ?><br>
        <?php endif; ?>
    <?php else: ?>
        <strong style="color:#333;">비회원 구독</strong><br>
        <span style="color:#666;">Guest ID: <?php echo substr($member_key, 6) ?></span><br>
    <?php endif; ?>
    <strong style="color:#333;">등록된 단말기:</strong> <?php echo $device_count ?>개
</div>

<form method="post" onsubmit="return confirmDeviceDelete(event)">
<input type="hidden" name="member_key" value="<?php echo htmlspecialchars($member_key) ?>">

<table style="width:100%; border-collapse:collapse; font-size:12px;">
    <thead>
        <tr style="background:#f1f3f4;">
            <th style="padding:8px; border:1px solid #ddd; text-align:center;">번호</th>
            <th style="padding:8px; border:1px solid #ddd;">구독 정보</th>
            <th style="padding:8px; border:1px solid #ddd;">접속 정보</th>
            <th style="padding:8px; border:1px solid #ddd; text-align:center;">상태</th>
            <th style="padding:8px; border:1px solid #ddd; text-align:center;">관리</th>
        </tr>
    </thead>
    <tbody>
    <?php
    $device_num = 1;
    while ($row = sql_fetch_array($result)) {
        $status_class = $row['is_active'] ? 'color:#28a745' : 'color:#6c757d';
        $status_text = $row['is_active'] ? '활성' : '비활성';
        $status_badge = $row['is_active'] ? 'background:#28a745' : 'background:#6c757d';
    ?>
    <tr>
        <td style="padding:8px; border:1px solid #ddd; text-align:center; vertical-align:top;">
            <strong><?php echo $device_num ?></strong>
        </td>
        <td style="padding:8px; border:1px solid #ddd; vertical-align:top;">
            <div style="margin-bottom:5px;">
                <strong>가입:</strong> <?php echo date('Y-m-d H:i', strtotime($row['created_at'])) ?>
            </div>
            <?php if ($row['updated_at'] != $row['created_at']): ?>
            <div style="margin-bottom:5px;">
                <strong>갱신:</strong> <?php echo date('Y-m-d H:i', strtotime($row['updated_at'])) ?>
            </div>
            <?php endif; ?>
            <div style="margin-bottom:5px;">
                <strong>엔드포인트:</strong><br>
                <span style="font-family:monospace; font-size:10px; color:#666; word-break:break-all;">
                    <?php echo mask_endpoint($row['endpoint']) ?>
                </span>
            </div>
            <div style="font-size:10px; color:#999;">
                ID: <?php echo $row['id'] ?>
            </div>
        </td>
        <td style="padding:8px; border:1px solid #ddd; vertical-align:top;">
            <?php if ($row['ip_address']): ?>
            <div style="margin-bottom:3px;">
                <strong>IP:</strong> <?php echo $row['ip_address'] ?>
            </div>
            <?php endif; ?>
            <?php if ($row['user_agent']): ?>
            <div>
                <strong>브라우저:</strong><br>
                <span style="color:#666; font-size:10px;">
                    <?php echo $row['user_agent'] ?>
                </span>
            </div>
            <?php endif; ?>
        </td>
        <td style="padding:8px; border:1px solid #ddd; text-align:center; vertical-align:top;">
            <span style="<?php echo $status_class ?>; font-weight:bold;">
                <?php echo $status_text ?>
            </span>
            <br>
            <span style="display:inline-block; margin-top:3px; padding:2px 6px; <?php echo $status_badge ?>; color:white; border-radius:10px; font-size:10px;">
                <?php echo $row['is_active'] ? 'ON' : 'OFF' ?>
            </span>
        </td>
        <td style="padding:8px; border:1px solid #ddd; text-align:center; vertical-align:top;">
            <button type="submit" name="delete_device_modal" value="1" 
                    onclick="setDeleteTarget(<?php echo $row['id'] ?>)" 
                    class="btn_02" 
                    style="padding:4px 8px; font-size:11px; border:1px solid #dc3545; background:#dc3545; color:white; border-radius:3px; cursor:pointer;">
                삭제
            </button>
        </td>
    </tr>
    <?php
        $device_num++;
    }
    ?>
    </tbody>
</table>

<input type="hidden" name="subscription_id" id="deleteTargetId" value="">
</form>

<div style="margin-top:15px; padding:10px; background:#fff3cd; border-radius:3px; font-size:11px; color:#856404;">
    <strong>참고:</strong>
    <ul style="margin:5px 0; padding-left:20px;">
        <li>각 단말기는 브라우저별, 기기별로 구분되어 등록됩니다.</li>
        <li>동일한 회원이 여러 기기(PC, 모바일, 태블릿)나 여러 브라우저를 사용할 경우 각각 별도로 등록됩니다.</li>
        <li>엔드포인트는 보안을 위해 일부만 표시됩니다.</li>
        <li>비활성 상태는 브라우저에서 알림을 차단했거나 구독이 만료된 경우입니다.</li>
    </ul>
</div>

<script>
function setDeleteTarget(subscriptionId) {
    document.getElementById('deleteTargetId').value = subscriptionId;
}

function confirmDeviceDelete(event) {
    event.preventDefault();
    
    var subscriptionId = document.getElementById('deleteTargetId').value;
    if (!subscriptionId) {
        alert('삭제할 단말기를 선택해주세요.');
        return false;
    }
    
    if (confirm('이 단말기의 구독을 삭제하시겠습니까?\\n삭제된 단말기는 더 이상 푸시 알림을 받을 수 없습니다.')) {
        event.target.submit();
    }
    
    return false;
}
</script>